#ident	"@(#)xdebug.h	1.3	91/01/04"
#ifndef _SYS_XDEBUG_H
#define _SYS_XDEBUG_H
#ident "@(#) xdebug.h 22.1 90/01/15 "
#ident "@(#)xdebug.h	1.3 89/10/07"
#ident "@(#) xdebug.h 1.7 89/07/27 "

/*
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 *	Portions Copyright 1980-1989 Microsoft Corporation
 *   Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *	Portions Copyright 1990-1991 Altos Computer Systems
 *		      All Rights Reserved
 */

/* #ident	"@)#(head.sys:xdebug.h	1.2" */

#ifdef i386
/*
 * xdebug.h - kernel debugging macros
 */

/*
 * Reasons for Entering Debugger
 */
#define DR_USER		0	/* User request via sysi86 or key sequence */
#define DR_BPT1		1	/* Int 1 breakpoint trap */
#define DR_STEP		2	/* (Int 1) single-step trap */
#define DR_BPT3		3	/* Int 3 (breakpoint) trap */
#define DR_PANIC	4	/* Panic occurred */
#define DR_OTHER	5	/* Miscellaneous */

#define NO_FRAME	((int *)0)

#ifndef NODEBUGGER

extern void (*cdebugger)();
extern int nullsys();
#define debugentry(r0ptr)	((*cdebugger)(DR_OTHER, r0ptr))

#ifdef ALTOS_UPS
#define calldebug()		kb_enable(), debugentry(NO_FRAME)
#else
#define calldebug()		debugentry(NO_FRAME)
#endif	/* ALTOS_UPS */

#else

#define debugentry(r0ptr)
#define calldebug()

#endif	/* NODEBUGGER */

#ifdef MSDEBUGGER
# ifndef MSDEBUG
#  define MSDEBUG
# endif
# define debugger(class) if ( debug(class, DL_HALT) ) calldebug();
#else
# define debugger(class)
#endif

#ifdef MSDEBUG
# define debug(class, level) (bugbits[class] & level)
# define dentry(class, name) if (debug(class,DL_CALL)) printf(entryfmt,name);
# define dexit(class, name) if (debug(class,DL_CALL)) printf(exitfmt, name);
  extern char entryfmt[];
  extern char exitfmt[];
#else
# define debug(class, level)	0
# define dentry(class, name) 
# define dexit(class, name)
#endif

/*
 * Debugging classes
 */
#define DB_EXEC		0	/* Exec system call */
#define DB_FP		1	/* Floating Point */
#define DB_MAIN		2	/* System initialization */
#define DB_MALLOC	3	/* Memory allocation */
#define DB_MMU		4	/* memory management */
#define DB_PHYSIO	5	/* raw I/O */
#define DB_SIG		6	/* Signals */
#define DB_SLP		7	/* Process switching */
#define DB_TEXT		8	/* Text table management */
#define DB_TRAP		9	/* Traps and faults */
#define DB_PFAULT	10
#define DB_PGOUT	11
#define DB_SCALL	12
#define DB_PHASH	13	/* filesystem page cache */
#define DB_FORK		14	/* copy on write fork */
#define DB_SWAP		15	/* swapping */
#define DB_IPC		16	/* ipc msgs, sems, shm */
#define DB_CONSOLE	17	/* console */
#define	DB_DISK		18	/* disk driver */
#define DB_SYNC		19	/* page synchronization */
#define DB_SWTCH	20	/* context switching */
#define	DB_DMA		21	/* dma */
#define NDBC		22	/* number of debugging classes */
#define DB_TAPE		23	/* tape */

/* 
 * Debugging levels
 */
#define DL_TERSE	1	/* terse output */
#define DL_VERB		2	/* verbose output */
#define DL_HALT		4	/* call debug() at strategic points */
#define DL_CALL		8	/* function entry/exit trace */

/*
 * Manifest constants for debugger
 */
#define NAR	19		/* can't match anything in reg.h */

extern char bugbits[];

#else

#define	calldebug()	debug(0)
#define dentry(class, name) 
#define dexit(class, name)

#endif

#endif	/* _SYS_XDEBUG_H */
