#ident	"@(#)vid.h	1.3	91/02/21"
#ifndef _SYS_VID_H
#define _SYS_VID_H

#ident  "@(#) vid.h 22.3 90/02/15 "
#ident "@(#)vid.h	1.3 90/03/07"
#ident  "@(#) vid.h 1.17 89/08/23 "
/* 
 *      Copyright (C) The Santa Cruz Operation, 1985 - 1990
 *      This Module contains Proprietary Information of the Santa
 *      Cruz Operation, and should be treated as confidential. 
 */

#define M_S_UNIX 1	/* must be defined for the space.c build */

#ifndef MAXFK
#include <sys/comcrt.h>
#endif

#define TRUE	1
#define FALSE	0

/*
 * Maximum nunmber of multiscreens.
 */
#define	MAXSCRN		12	/* max number of screens */

/*
 * maximum number of allowed.
 */
#define MAXADAPTERS	16

/*
 * Maximum number of control sequence parameters in
 * an escape sequence.
 */
#define NCSPARAMS	3

/*
 * Maximum number of keyboard scan codes that can
 * be saved in the read ahead buffer.
 */
#define	MAXRA	8

/*
 * Commands to the (*v_sgr)() routine.
 * Defined by ANSI
 */
#define SGR_NORMAL	0	/* return attributes to normal	*/
#define SGR_BOLD	1	/* called INTENSE in video'ese	*/
#define SGR_FAINT	2	/* NOT-supported		*/
#define SGR_PRCOLORS	2	/* PR's set the normal colors	*/
#define SGR_ITALIC	3	/* NOT-supported		*/
#define SGR_PRBLKCTL	3	/* PR's blink bit control	*/
#define SGR_UNDERL	4	/* underline			*/
#define SGR_BLINK	5	/* blink			*/
#define SGR_FBLINK	6	/* NOT-supported		*/
#define SGR_REVERSE	7	/* reverse video w/ setcolor	*/
#define SGR_CONCEALED	8	/* hide characters		*/
#define SGR_CROSSED	9	/* NOT-supported		*/
#define SGR_FONT	10	/* fonts 0 through 9 w/ 10-19	*/
#define SGR_GOTHIC	20	/* NOT-supported		*/
#define SGR_DLBUNDERL	21	/* NOT-supported		*/
#define SGR_NORMCI	22	/* NOT-supported		*/
#define SGR_0ITALIC	23	/* NOT-supported		*/
#define SGR_0UNDERL	24	/* NOT-supported		*/
#define SGR_0BLINK	25	/* NOT-supported		*/
#define SGR_RES1	26	/* RESERVED by ANSI		*/
#define SGR_0REVERSE	27	/* NOT-supported		*/
#define SGR_0CONCEALED	28	/* NOT-supported		*/
#define SGR_0CROSSED	29	/* NOT-supported		*/
#define SGR_FORECOLOR	30	/* ANSI forground colors 30-37	*/
#define SGR_RES2	38	/* RESERVED by ANSI 		*/
#define SGR_DEFFOREFOL	39	/* NOT-supported		*/
#define SGR_BACKCOLOR	40	/* ANSI background colors 40-47	*/
#define SGR_RES3	48	/* RESERVED by ANSI		*/
#define SGR_DEFBACKCOL	49	/* NOT-supported		*/

/*
 * Commands to the (*v_adapctl)() routine.
 * Defined by SCO
 */
#define	AC_BLINKB	0	/* Clear or Set the blink bit	*/
#define	AC_FONTCHAR	1	/* display font character	*/
#define	AC_DEFCSR	2	/* define Cursor type		*/
#define AC_BOLDBKG	3	/* turn on intense bg color	*/
#define	AC_DEFNF	10	/* define normal forground	*/
#define	AC_DEFNB	11	/* define normal background	*/
#define	AC_ONN		12	/* begin using normal colors	*/
#define	AC_DEFRF	13	/* define reverse forground	*/
#define	AC_DEFRB	14	/* define reverse background	*/
#define	AC_ONR		15	/* turn on reverse colors	*/
#define	AC_DEFGF	16	/* define graphic forground	*/
#define	AC_DEFGB	17	/* define graphic background	*/
#define	AC_ONG		18	/* turn on graphic colors	*/
#define	AC_SETOS	30	/* set overscan colors		*/
#define AC_PRIMODE	100	/* return primary text mode	*/
#define AC_SAVSZQRY	101	/* return size (bytes) of state	*/
#define AC_SAVSCRN	102	/* save screen			*/
#define AC_RESSCRN	103	/* restore screen		*/
#define AC_CSRCTL	104	/* arg=0 hide cursor, arg=1 show cursor	*/
#define AC_USERFONT	105	/* load or dump the soft font	*/
#define AC_IOPRIVL	106	/* grant or revoke IO privl	*/
#define AC_SOFTRESET	107	/* reset text mode (keep colors)*/
#define AC_SENDSCRN	108	/* write screen chars to stdin	*/
#define	AC_ONSCREEN	109	/* turn video on.		*/
#define AC_OFFSCREEN	110	/* turn video off		*/

#ifdef VPIX
#define AC_VTKDPARAM	200	/* get VPIX display parameters	*/
#define AC_TXTRECVR	201	/* recover text mode from DOS	*/
#define AC_TXTRELSE	202	/* release text mode to DOS	*/
#define	AC_OFFVIDEO	203	/* turn off video output */
#endif

typedef struct {
	int cmd, flg;		/* weird data structure to make loadable */
	faddr_t faddr;		/* fonts easier to implement	*/
} pgiofontarg_t;

#if defined(M_I386) || defined(M_S_UNIX)
typedef short *strixp_t;	/* pointer to function key text index's	*/
typedef uchar_t *strtabp_t;	/* pointer to function key text table	*/
typedef short *vseg_t;		/* pointer to a video segment of 'short's */
typedef long *vecp_t;
#else
typedef short far *strixp_t;	/* pointer to key/scrn table of chars	*/
typedef uchar_t far *strtabp_t;	/* pointer to function key text table	*/
typedef short far *vseg_t;	/* pointer to a video segment of 'short's */
typedef long far *vecp_t;
#endif

extern char	ansicolormap[];

struct colors {
	char fore;			/* foreground colors	*/
	char back;			/* background colors	*/
};

/*
 * Structure for listing valid
 * adapter IO addresses
 */
struct portrange {
	ushort first;		/* first port */
	ushort count;		/* number of valid right after 'first' */
};

/*
 * Structure for a user virtual address.
 */
struct userva {
	faddr_t addr;
	unsigned size;
};

#define	BLACK		0x0
#define	BLUE		0x1
#define	GREEN		0x2
#define	CYAN		0x3
#define	RED		0x4
#define	MAGENTA		0x5
#define	BROWN		0x6
#define	WHITE		0x7
#define	GRAY		0x8
#define	LT_BLUE		0x9
#define	LT_GREEN	0xA
#define	LT_CYAN		0xB
#define	LT_RED		0xC
#define	LT_MAGENTA	0xD
#define	YELLOW		0xE
#define	HI_WHITE	0xF

/*
 * A keyboard group is a set of Multiscreens,
 * a set of video adapter drivers and the global
 * state of one keyboard.
 */
struct kbgrp {
	struct mscrn *kg_m0;	/* multi-screens[] for the keyboard grp	*/
	struct adapter *kg_a0;	/* adaptsw[] for the keyboard grp	*/
	int (*kg_in)();		/* keybd grp line displn in() routine	*/
	struct map *kg_memmap;	/* keybd grp multiscreen save area map	*/
	short kg_dtoa[MAXADAPTERS];/* device # to adapter index table	*/
	short kg_curscrn;	/* Current screen			*/
	short kg_maxscrn;	/* Maximum valid screen in keyboard grp	*/
	struct keymap *kg_keymap;	/* ScanCode translation map	*/
	char kg_rabuf[MAXRA];	/* keyboard scan code read ahead buffer	*/
	uchar_t *kg_rafp;	/* read ahead buf front pointer		*/
	uchar_t *kg_rabp;	/* read ahead buf back pointer		*/
	uchar_t kg_break;	/* was last Scan Code a break?		*/
	short	kg_down;	/* Which state keys are down		*/
	uchar_t kg_state;	/* Local keyboard state			*/
	uchar_t kg_gblklk;	/* Global key lock keyboard state	*/
	uchar_t	kg_kbmode;	/* keyboard mode AT vs. XT		*/
	int (*kg_scrsend)();	/* kb command sender (leds) S001	*/
	int (*kg_scrdrain)();	/* clear any keyboard data  S001	*/
	int (*kg_scrgetkey)();	/* fetch key from keyboard  S001	*/
	int (*kg_scrmode)();	/* put kb in AT or XT mode  S001	*/
	int (*kg_bell)();	/* activate bell	    S003	*/ 
 	int kg_extmode;		/* Extended mode flag 	    S006	*/
 	int kg_altseq;		/* ALT key sequence	    S006	*/
/* #ifdef VPIX */
	int (*kg_sound)();	/* VP/ix sound generator    S004	*/
	uchar_t kg_num;		/* keyboard group number		*/
	uchar_t kg_vtlock;	/* VT interlock token			*/
	uchar_t kg_vtsw_id;	/* serialized VT screen switch number	*/
	struct mscrn *kg_vtswtchto;	/* next screen in a VT switch	*/
/* #endif */
/* #ifdef MERGE386 */
	int merge_swtch;	/* merge keyboard state for screen switch */
/* #endif MERGE386 */
};

/*
 * All activity center around a multi-screen.
 */
struct mscrn {
	struct kbgrp	*m_grp;		/* multiscreen group header	*/
	int		m_num;		/* screen number		*/
	struct tty	*m_tty;		/* tty structure		*/
	/*
	 * video part
	 */
	struct adapter *mv_adapter;	/* ptr to the screen's adapter	*/
	vseg_t mv_savscrn;		/* save screen RAM		*/
	unsigned mv_savsz;		/* size of save screen used	*/
	faddr_t mv_smap;		/* font value translation table	*/
	uchar_t mv_font;		/* ANSI font, one of 0, 1, or 2	*/
	ushort mv_tmpcol;		/* used by ANSI			*/
	ushort mv_row, mv_col;		/* cursor position		*/
	ushort mv_rsz, mv_csz;		/* text screen size		*/
	ushort mv_csstate;		/* Ctl Sequ state		*/
	ushort mv_csparam[NCSPARAMS];	/* Ctl Sequ parameters		*/
	uchar_t mv_csindex;		/* Ctl Sequ parameter index	*/
	uchar_t mv_cstyp;		/* cursor type			*/
	struct colors	mv_norm,	/* normal attributes		*/
			mv_rev,		/* reverse video attributes	*/
			mv_grfc;	/* graphic character attributes	*/
	uchar_t mv_ovscan;		/* border color			*/
/* #ifdef VPIX */
/*
 * VP/ix virtual terminals.
 */
	struct proc *vt_procp;
	struct v86dat *vt_v86p;
	ushort vt_pid;
	uchar_t vt_relsig;
	uchar_t vt_acqsig;
	uchar_t vt_frsig;
	uchar_t vt_kbmode;
	uchar_t vt_scrnmode;
/* #endif */

/* #ifdef MERGE386 */
	void	(*m_kb_vpi)();	/* Merge keyboard vpi function pointer */
	struct	mcon	*merge;	/* Pointer to Merge console structure */
	int	m_flags;
/* #endif MERGE386 */
/*
 * Keyboard part
 */
	char mk_qstr[MAXFK];	/* work space for func. key conf	*/
	strixp_t mk_strix;	/* function key string table pointer	*/
	strtabp_t mk_strtab;	/* function key string text table	*/
	uchar_t mk_keylock;	/* caps/num/scroll lock			*/
/*
 * flag definitions for mk_keylock
 */
#define	CLKED	0x01		/* caps   locked */
#define	NLKED	0x02		/* num    locked */
#define	SLKED	0x04		/* scroll locked */
/*
 * Bell part
 */
	ushort mb_time;		/* bell duration 1/10 secs */
	ushort mb_freq;		/* bell frequency (pitch) */
/*
 * Misc. Features
 */
	ushort mf_savrow;	/* ^[[7 save current row & col	*/
	ushort mf_savcol;	/* ^[[8 restore row & col	*/
	ushort mf_snd_row;	/* row and col for sendscreen	*/
	ushort mf_snd_col;
	ushort mf_status;	/* terminal status bit field	*/
	ushort mf_xtraopenf;	/* flags for systty support	*/
/*
 * Defines for mf_status.
 */
#define MFS_SND_SCRN	0x0001		/* currently send screening	*/
#define MFS_KBD_LOCK	0x0002		/* keyboard is locked		*/
#define MFS_TEXTMODE	0x0004		/* textmode (not graphics mode)	*/
#define MFS_LOSTPUTC	0x0008		/* kernl putc's lost in grafixs	*/
#define MFS_NOMARGIN	0x0010		/* no automargin mode		*/
#ifdef VPIX
#define MFS_PROCMODE	0x0020		/* screen has VPix handler proc	*/
#define MFS_VTWAIT	0x0040		/* writes to noncur scrs, block */
#define MFS_VTMAPPED	0x0080		/* display is mapped VPix style	*/
#endif
#define	MFS_TMODES	0x0300		/* mask for text modes.		*/
#define	MFS_REVSTEXT	0x0100		/* display is reverse video text*/
#define	MFS_GRAFTEXT	0x0200		/* display is in graphics text	*/
/*
 * Defines for mf_xtraopenf.
 */
#define MFXOF_CONS	0x0001
#define MFXOF_CDEV	0x0002
/*
 * Per Screen hardware fields for use by the adapter drivers.
 * Each adapter driver uses this area in any manner it choses.
 * If the adapter driver wished to make use of m6845.c then
 * the first 8 bytes of the adapter area must match m6845_a.
 */
	uchar_t adp_area[32];
};

/*
 * All adapter multiscreen field definitions must have
 * these fields at the top if the adapter driver is
 * intended to work with m6845.c
 */
struct m6845_a {
	uchar_t	a_battr;	/* Bold & Blink attributes	*/
	uchar_t	a_cattr;	/* Color/Reverse attributes	*/
	uchar_t	a_attrs;	/* OR battr with cattr		*/
	uchar_t	a_modereg;	/* contents of 6845 mode reg	*/
	ushort	a_csr;		/* cursor shape			*/
	ushort	a_scroff;	/* offset of screen in video	*/
};

/*
 *  Data for accessing an adapter driver.
 */
struct adapter {
	char	*v_name;		/* name of the adapter ie "CGA"	*/

	ushort	v_type;			/* basic type eg. MONO, CGA,... */
	ushort	v_oem;			/* nonstandard vendor name 	*/
	struct mscrn *v_curscrn;	/* pointer to the current screen*/

	ushort	v_initrc;		/* saved return value of v_init */
	/*
	 * Adapter routines
	 * These routines manipulate the
	 * on video and save image screens.
	 */
	int (*v_init)();	/* init the adapter driver		*/
	int (*v_cmos)();	/* Extra cmos type checking		*/
	int (*v_initscreen)();	/* init a multiscreen on the adapter	*/
	void (*v_scroll)();
	void (*v_copy)();
	void (*v_clear)();
	void (*v_pchar)();	/* put a string of characters		*/
	void (*v_scurs)();	/* set the active and cursor position	*/
	void (*v_sgr)();	/* set graphic rendition; see Ansi X.64	*/
	int (*v_ioctl)();	/* Adapter specific ioctl handler	*/
	int (*v_adapctl)();	/* Adapter specific misc other stuff	*/

	vseg_t	v_videoram;	/* Kernel pointer to video ram		*/
	paddr_t	v_paddr;	/* Physical address of video ram	*/
	ulong_t	v_size;		/* Size of of video ram in bytes	*/
/* #ifdef VPIX */
	ulong_t	v_v86addr;	/* Where VP/ix needs this card		*/
/* #endif */
/* #ifdef ALTOS_UPS */
	int (*v_shut)();	/* UPS shut routine */
	int (*v_restart)();	/* UPS restart routine */
/* #endif */
};

/* bits fields of v_initrc (Adapter Init return values */
#define AI_PRESENT	0x0001
#define AI_COLOR	0x0002
#define ADAP_NP		0

/* misc. macros */
#define DISPLAYED(msp)	((msp)->mv_adapter->v_curscrn == (msp))
#define TEXTMODE(msp)	(MFS_TEXTMODE & (msp)->mf_status)
#define SCREENSZ(msp)	((msp)->mv_rsz * (msp)->mv_csz)
#define CURSOR(msp)	((msp)->mv_row * (msp)->mv_csz + (msp)->mv_col)

#if defined(M_I386) || defined(M_S_UNIX)
#ifdef M_S_UNIX
#define	VIDMEMGET(pages)	(memget(pages))
#define	VIDERR			(0)
#else
#define	VIDMEMGET(pages)	( (pfn_t) memget(pages) )
#define	VIDERR			(0)
#endif
#else	/* M_I286 */
#define	VIDMEMGET(pages)	( (mloc_t) mmuget(pages) )
#define	VIDERR			(MMUERR)
#endif

faddr_t vidmap();
faddr_t vidumapinit();

#ifdef VPIX
struct kbgrp *vidgetgrpp();	/* get a kb grp ptr from a kb grp num	*/
int vidgetgrpnum();		/* get a kb grp num from a kb grp ptr	*/
#endif

#ifdef M_S_UNIX
#define mstob(x)	ctob(x)
#endif

/* S007 vvv */
struct vid_info
{
	short	size;			/* must be first field		*/
	short	m_num;			/* multiscreen number, 0 based	*/
	ushort	mv_row, mv_col;		/* cursor position		*/
	ushort	mv_rsz, mv_csz;		/* text screen size		*/
	struct colors	mv_norm,	/* normal attributes		*/
			mv_rev,		/* reverse video attributes	*/
			mv_grfc;	/* graphic character attributes	*/
	uchar_t mv_ovscan;		/* border color			*/
	uchar_t mk_keylock;		/* caps/num/scroll lock		*/
};

struct m6845_info
{
	short	size;		/* must be first field */
	ushort	screen_top;	/* offset of screen in video	*/
	ushort	cursor_type;	/* cursor shape			*/
};
/* S007 ^^^ */

struct vidclass
{
	char   *name;
	char   *text;
	long	base;
	long	size;
	struct portrange *ports;
};

#endif	/* _SYS_VID_H */
