#ident "@(#)vd.h	1.7 91/05/16"
/*	Copyright (c) 1989 Altos Computer Systems	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ALTOS	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
 *	VD - virtual disk driver
 */

#define VDMAXDEV	12
#define VDMAXMRR	4
#define VDMAXERR	100
#define SIGVDBAD	SIGPIPE			/* used by kernel to signal */

struct vd {
	char vd_type;				/* S = striped, M = Mirrored */
	char vd_flags;				/* Unused */
	short vd_count;				/* Number of component devices*/
	daddr_t vd_size;			/* Stripe size in blocks */
	int vd_nblks;				/* Total vdisk size */
	dev_t vd_dev[VDMAXDEV];			/* Array of component devices*/
};

struct mrrinfo {
	int count;
	short pending;
	char flags;
	dev_t dev[VDMAXMRR];
	daddr_t blkno[VDMAXMRR];
};
#define DSKBAD(x)	(1<<(x))

struct bogus_block {
	dev_t dev;
	char isbad;
	char good_override;
	int count;
	dev_t vdev;
	daddr_t vblk;
	daddr_t blk[VDMAXERR];
};

#ifdef INKERNEL
struct mrrinfo *getmrrinfo();
struct buf *allocvdhdr(), *vdiodone();
#endif
