#ident	"@(#)utsname.h	1.5 91/04/01"
#ifndef _SYS_UTSNAME_H
#define _SYS_UTSNAME_H
/*
 *   Portions Copyright 1983-1990 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	Copyright (c) 1987, 1988 Microsoft Corporation	*/
/*	  All Rights Reserved	*/

/*	This Module contains Proprietary Information of Microsoft  */
/*	Corporation and should be treated as Confidential.	   */

/* #ident	"@)#(head.sys:utsname.h	1.3.1.1" */

struct scoutsname {
	char	sysname[9];
	char 	nodename[9];
	char	release[16];
	char	kernelid[20];
	char	machine[9];
	char	bustype[9];
	char	sysserial[10];
	unsigned short sysorigin;
	unsigned short sysoem;
	char	numuser[9];
	unsigned short numcpu;
	char	version[8];		/* Altos only */
};
extern struct scoutsname scoutsname;

struct utsname {
	char	sysname[9];
	char	nodename[9];
	char	release[9];
	char	version[9];
	char	machine[9];
#if	defined( M_XOUT )
	char	reserved[15];
	unsigned short sysorigin;	/* original supplier of the system */
	unsigned short sysoem;		/* OEM for this system */
	long	sysserial;		/* serial number of this system */
#endif	/* M_XOUT */
};
extern struct utsname utsname;


#define SYS_NMLN 9

struct xutsname {
	char	sysname[SYS_NMLN];
	char	nodename[SYS_NMLN];
	char	release[SYS_NMLN];
	char	version[SYS_NMLN];
	char	machine[SYS_NMLN];
	char	reserved[15];
	unsigned short sysorigin;	/* original supplier of the system */
	unsigned short sysoem;		/* OEM for this system */
	long	sysserial;		/* serial number of this system */
};
extern struct xutsname xutsname;

#ifndef INKERNEL

#if	defined(__STDC__) && !defined(NO_PROTOTYPE)
extern int uname(struct utsname *);
#else
extern int uname();
#endif

#endif	/* INKERNEL */

#endif	/* _SYS_UTSNAME_H */
