#ident	"@(#)unistd.h	1.3 91/04/01"
#ifndef _SYS_UNISTD_H
#define _SYS_UNISTD_H
/*
 *   Portions Copyright 1983-1990 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/* #ident	"@)#(head:unistd.h	1.5" */

/* System definitions for standard file descriptors */
#define STDIN_FILENO	0	/* The standard input file descriptor */
#define STDOUT_FILENO	1	/* The standard output file descriptor */
#define STDERR_FILENO	2	/* The standard error output file descriptor */
  
/* Symbolic constants for the "access" routine: */
#define	R_OK	4	/* Test for Read permission */
#define	W_OK	2	/* Test for Write permission */
#define	X_OK	1	/* Test for eXecute permission */
#define	F_OK	0	/* Test for existence of File */

#define F_ULOCK	0	/* Unlock a previously locked region */
#define F_LOCK	1	/* Lock a region for exclusive use */
#define F_TLOCK	2	/* Test and lock a region for exclusive use */
#define F_TEST	3	/* Test a region for other processes locks */


/* Symbolic constants for the "lseek" routine: */
#define	SEEK_SET	0	/* Set file pointer to "offset" */
#define	SEEK_CUR	1	/* Set file pointer to current plus "offset" */
#define	SEEK_END	2	/* Set file pointer to EOF plus "offset" */

/* Path names: */
#define	GF_PATH	"/etc/group"	/* Path name of the "group" file */
#define	PF_PATH	"/etc/passwd"	/* Path name of the "passwd" file */

/*
 * registration of POSIX Optional Facilities
 *
 * In accordance with POSIX 1003.1, section 2.10.4 the following constants
 * are undefined. 
 *
 *		_POSIX_CHOWN_RESTRICED
 *		_POSIX_NO_TRUNC
 *
 * The value of these may vary across filesystems and therefore is dependent
 * on a pathname at runtime. The exact value may be determined at runtime
 * with pathconf() and fpathconf().
 */

#define	_POSIX_JOB_CONTROL 1    /* supports job control */
#define	_POSIX_SAVED_IDS 1      /* has saved set-user-id and set-group-id */
#define	_POSIX_VERSION  198808L /* version of POSIX standard */
#define	_POSIX_VDISABLE (255)	/* terminal special characters can be disabled */

/*
 * symbolic definitions for pathconf(...,name) function
 */
#define	_PC_LINK_MAX    0       /* index to LINK_MAX value */
#define	_PC_MAX_CANON   1       /* index to MAX_CANON value */
#define	_PC_MAX_INPUT   2       /* index to MAX_INPUT value */
#define	_PC_NAME_MAX    3       /* index to NAME_MAX value */
#define	_PC_PATH_MAX    4       /* index to PATH_MAX value */
#define	_PC_PIPE_BUF    5       /* index to PIPE_BUF value */
#define	_PC_CHOWN_RESTRICTED 6  /* index to _POSIX_CHOWN_RESTRICTED value */
#define	_PC_NO_TRUNC    7       /* index to _POSIX_NO_TRUNC value */
#define	_PC_VDISABLE    8       /* index to _POSIX_VDISABLE value */

/*
 * symbolic definitions to POSIX sysconf(name) function
 */
#define	_SC_ARG_MAX     0       /* index to ARG_MAX */
#define	_SC_CHILD_MAX   1       /* index to CHILD_MAX */
#define	_SC_CLK_TCK     2       /* index to CLK_TCK */
#define	_SC_NGROUPS_MAX 3       /* index to NGROUPS_MAX */
#define	_SC_OPEN_MAX    4       /* index to OPEN_MAX */
#define	_SC_JOB_CONTROL 5       /* index to _POSIX_JOB_CONTROL */
#define	_SC_SAVED_IDS   6       /* index to _POSIX_SAVED_IDS */
#define	_SC_VERSION     7       /* index to _POSIX_VERSION */
#define _SC_PASS_MAX	8	/* index to _PASS_MAX (XPG3) */
#define _SC_XOPEN_VERSION 9	/* index to _XOPEN_VERSION (XPG3) */

#define _PASS_MAX	80	/* password size (excluding null) */
#define _XOPEN_VERSION	3	/* for the '3' in XPG3 */

#endif	/* _SYS_UNISTD_H */
