#ident	"@(#)types.h	1.4 91/04/01"
#ifndef _SYS_TYPES_H
#define _SYS_TYPES_H
/*
 *   Portions Copyright 1983-1990 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	Copyright (c) 1987, 1988 Microsoft Corporation	*/
/*	  All Rights Reserved	*/

/*	This Module contains Proprietary Information of Microsoft  */
/*	Corporation and should be treated as Confidential.	   */

/*
 *      Copyright (C) Corollary, Inc., 1986, 1987, 1988, 1989.
 *      All Rights Reserved.
 *      This Module contains Proprietary Information of
 *      Corollary, Inc., and should be treated as Confidential.
 */

typedef	struct { int r[1]; } *physadr;
typedef	long		daddr_t;	/* <disk address> type */
typedef	char *		caddr_t;	/* ?<core address> type */

/*
 * Lots of unsigned types.  Take your pick.
 */
typedef	unsigned char	unchar;
typedef unsigned char   u_char;
typedef unsigned char	uchar_t;

typedef	unsigned short	ushort;
typedef unsigned short  u_short;

typedef	unsigned int	uint;
typedef unsigned int    u_int;

typedef	unsigned long	ulong;
typedef unsigned long   u_long;
typedef unsigned long	ulong_t;

#define	GETUCHAR(uc)	(uc)
#define	GETULONG(ul)	(ul)

typedef	ushort		ino_t;		/* <inode> type */
#ifndef	M_UNIX
	typedef char		cnt_t;		/* ?<count> type */
#else
	typedef	short		cnt_t;		/* ?<count> type */
#endif	/* M_UNIX */

#ifndef	_TIME_T
#	define	_TIME_T
	typedef	long		time_t;		/* <time> type */
#endif	/* _TIME_T */

typedef	int		label_t[6];
typedef unsigned short	mode_t;
typedef short		nlink_t;
typedef	short		dev_t;		/* <old device number> type */
typedef	long		off_t;		/* ?<offset> type */
typedef	unsigned long	paddr_t;	/* <physical address> type */
typedef unsigned short	mloc_t;		/* memory region size */
typedef	long		key_t;		/* IPC key type */
typedef int		pfn_t;
typedef	unsigned char	use_t;		/* use count for swap.  */

#if	defined(M_I386) || defined(i386)
#	define	inodep_t	struct inode *
#	define	inodepp_t	struct inode **
#	define	filep_t		struct file *
#else
#	define	inodep_t	struct inode far *
#	define	inodepp_t	struct inode far * far *
#	define	filep_t		struct file far *
#endif	/* M_I386 or i386 */

struct saddr {
	unsigned short	sa_seg;
	long			sa_off;
};

typedef	short		sysid_t;
typedef	short		index_t;
typedef	short		lock_t;		/* lock work for busy wait */
#ifndef	_SIZE_T
#	define	_SIZE_T
	typedef	unsigned int	size_t;		/* len param for string funcs */
#endif /* _SIZE_T */
typedef ushort		sel_t;		/* Selector type */

/* The following were added for ANSI compliance */
#ifndef	_CLOCK_T
#	define	_CLOCK_T
	typedef	long	clock_t;	/* value returned by clock() */
#endif	/* _CLOCK_T */

#ifndef	_PTRDIFF_T
#	define	_PTRDIFF_T
	typedef	int	ptrdiff_t;	/* difference between two pointeres */
#endif	/* _PTRDIFF_T */

#ifndef	_FPOS_T
#	define	_FPOS_T
	typedef long	fpos_t;	/* file positioning */
#endif	/* _FPOS_T */

#ifndef	_SIG_ATOMIC_T
#	define	_SIG_ATOMIC_T
	typedef	int	sig_atomic_t;	/* atomic entity for signal handling */
#endif	/* _SIG_ATOMIC_T */

#ifndef	_DIV_T
#	define	_DIV_T
	typedef	struct {
		int	quot;
		int	rem;
	} div_t;
#endif	/* _DIV_T */

#ifndef	_LDIV_T
#	define	_LDIV_T
typedef	struct {
	long	quot;
	long	rem;
} ldiv_t;
#endif	/* _LDIV_T */

/* wchar_t is needed for ANSI, but we don't have it yet */
/*typedef	ushort	wchar_t;	*/

/*
 * Types from XENIX
 */
#if defined( M_I286 )
#	define	faddr_t	char far *
#	define	fdesc_t	struct desctab far *
#else
	typedef	char *		faddr_t;   /* same as caddr_t for 8086/386 */
#endif

typedef unsigned short	uid_t;
typedef unsigned short	gid_t;

typedef short	pid_t;		/* used for process ids */

#define	NBBY	8		/* number of bits in a byte */

/*
 * Select uses bit masks of file descriptors in longs.
 * These macros manipulate such bit fields (the filesystem macros use chars).
 * FD_SETSIZE may be defined by the user, but the default here
 * should be >= NOFILE (param.h).
 */
#ifndef	FD_SETSIZE
#	define	FD_SETSIZE	60
#endif

typedef long	fd_mask;
#define NFDBITS	(sizeof(fd_mask) * NBBY)	/* bits per mask */

#ifndef howmany
#	define	howmany(x, y)	(((x)+((y)-1))/(y))
#endif

typedef	struct fd_set {
	fd_mask	fds_bits[howmany(FD_SETSIZE, NFDBITS)];
} fd_set;

#define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1L << ((n) % NFDBITS)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1L << ((n) % NFDBITS)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1L << ((n) % NFDBITS)))
#define FD_ZERO(p)	bzero((caddr_t)(p), sizeof(*(p)))

							/* BEGIN    SCO_C2TCB */
typedef unsigned long	mask_t;		/* for variable length bit strings */
typedef mask_t		priv_t;		/* privilege vector */

/*
 * Within a name space, this uniquely references an object.
 */

#ifndef MKSHLIB

typedef union obj  {
	char *o_file;
	int o_pid;
	int o_semid;
	int o_shmid;
	int o_msgid;
	int o_sockid;
	int o_fdes;
} obj_t;

#endif	/* MKSHLIB */
							/* END     SCO_C2TCB */

#include <sys/ci/cidefs.h>

#endif	/* _SYS_TYPES_H */
