#ifndef M_I386
/*
 *	@(#) text.h 2.2 88/07/13 
 *
 *	Copyright (C) The Santa Cruz Operation, 1984, 1985, 1986, 1987, 1988.
 *	Copyright (C) Microsoft Corporation, 1984, 1985, 1986, 1987, 1988.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation, Microsoft Corporation
 *	and AT&T, and should be treated as Confidential.
 */

/*
 * Text structure.
 * One allocated per pure procedure on swap device.
 * Manipulated by text.c
 */
struct text
{
	short	x_daddr;     /* disk address of segment (relative to swplo) */
	short	x_size;		/* size (clicks) */
#ifdef M_I386
	struct proc *x_caddr;	/* ptr to linked proc, if loaded */
#else
	mloc_t	x_caddr;	/* ptr to linked proc, if loaded */
#endif
	inodep_t x_iptr;	/* inode of prototype */
	char	x_count;	/* reference count */
	char	x_ccount;	/* number of loaded references */
	char	x_flag;		/* traced, written flags */
	char	x_lcount;	/* lock count */
	unsigned short	x_fcsel;/* first code selector */
	unsigned short	x_lsize;/* size of the text ldt in bytes */
};

extern struct text text[];

#define	XTRC	01		/* Text may be written, exclusive use */
#define	XWRIT	02		/* Text written into, must swap out */
#define	XLOAD	04		/* Currently being read from file */
#define	XLOCK	010		/* Being swapped in or out */
#define	XWANT	020		/* Wanted for swapping */
#define XLARGE  040		/* large text segment 286/86 uses this flag */
#define XFPU    0100            /* text uses floating point */

#endif
