#ident	"@(#)tape.h	1.2	90/08/08"
#ifndef _SYS_TAPE_H
#define _SYS_TAPE_H
#ident "@(#) tape.h 22.1 90/01/15 "
#ident "@(#)tape.h	1.2 89/09/29"
#ident "@(#) tape.h 1.3 89/07/27 "
/*
 *	Copyright (C) The Santa Cruz Operation, 1988, 1989.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and should be treated as Confidential.
 */

/* Device-independent tape things for UNIX 3.2 */

#define	MTIOC		('m'<<8)	/* ioctl code for tape commands */
#define	MT_STATUS	(MTIOC | 0)	/* read tape status */
#define	MT_RESET	(MTIOC | 1)	/* reset tape hardware */
#define	MT_RETEN	(MTIOC | 2)	/* retention tape */
#define	MT_REWIND	(MTIOC | 3)	/* rewind tape */
#define	MT_ERASE	(MTIOC | 4)	/* erase tape */
#define	MT_AMOUNT	(MTIOC | 5)	/* report on amount of data xfered */
#define	MT_RFM		(MTIOC | 6)	/* find next filemark */
#define	MT_WFM		(MTIOC | 7)	/* write filemark */
#define MT_LOAD		(MTIOC | 8)	/* load tape */
#define MT_UNLOAD	(MTIOC | 9)	/* unload tape */
#define MT_DSTATUS	(MTIOC | 10)	/* device-dependent status */
#define MT_FORMAT	(MTIOC | 11)	/* format a tape */
#define MT_GETHDR	(MTIOC | 12)	/* get the tape header */
#define MT_PUTHDR	(MTIOC | 13)	/* write a new tape header */
#define MT_GETNEWBB	(MTIOC | 14)	/* get new bad block list */
#define MT_PUTNEWBB	(MTIOC | 15)	/* update bad block table */
#define MT_GETVTBL	(MTIOC | 16)	/* get volume table */
#define MT_PUTVTBL	(MTIOC | 17)	/* write volume table */
#define	MT_SERVO	(MTIOC | 18)	/* servo-write a blank tape */
#define MT_REPORT	(MTIOC | 64)	/* report device type */

/* AT&T ioctls for compatibility */

#define T_RETENSION 	MT_RETEN
#define T_RWD		MT_REWIND
#define T_LOAD		MT_LOAD
#define T_UNLOAD	MT_UNLOAD
#define T_ERASE		MT_ERASE
#define T_WRFILEM	MT_WFM
#define T_RST		MT_RESET
#define T_SFF		(0)		/* skip forward arg files */
#define T_SBF		(0)		/* skip forward arg blocks */
#define T_RDSTAT	MT_DSTATUS

/* result of MT_REPORT ioctl */

#define MT_UNKNOWN_TYPE 0
#define MT_CT_TYPE	1
#define MT_QIC40_TYPE	2
#define MT_IR_TYPE	3
#define MT_SCSI_TYPE	4
#define MT_QIC80_TYPE	5

/* Device-independent status block */

struct tape_status {
	unsigned long ready	:1;	/* drive ready */
	unsigned long error	:1;	/* error detected */
	unsigned long bot	:1;	/* beginning of tape */
	unsigned long eot	:1;	/* end of tape */
	unsigned long wprot	:1;	/* cart. write-protected */
	unsigned long nocart	:1;	/* no cartridge in drive */
	unsigned long offline	:1;	/* drive is off-line */
	unsigned long reset	:1;	/* drive was reset */
	unsigned long newcart	:1;	/* new cartridge inserted */
	unsigned long track	:1;	/* track found */
	unsigned long type	:1;	/* cartridge type */
	unsigned long filemark	:1;	/* at-filemark */
	unsigned long reserved	:20;	/* reserved for future use */
};

struct tape_info {
	union {
		struct tape_status 	status;	/* status bits */
		unsigned long		s;
	} s;
	union {
		struct tape_status	valid;	/* which bits are valid */
		unsigned long		v;
	} v;
	long errno;	/* error number, if any */
	long sfterr;	/* soft errors */
	long hrderr;	/* hard errors */
	long undrun;	/* underruns */
};


#endif	/* _SYS_TAPE_H */
