#ident	"@(#)systm.h	1.2	90/08/08"
#ifndef _SYS_SYSTM_H
#define _SYS_SYSTM_H
#ident "@(#) systm.h 22.1 90/01/15 "
#ident "@(#)systm.h	1.2 89/09/29"
#ident "@(#) systm.h 1.9 89/07/27 "
/*
 *	Copyright (C) The Santa Cruz Operation, 1988, 1989.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and should be treated as Confidential.
 *
 */
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	Copyright (c) 1987, 1988 Microsoft Corporation	*/
/*	  All Rights Reserved	*/

/*	This Module contains Proprietary Information of Microsoft  */
/*	Corporation and should be treated as Confidential.	   */

/*
 * Random set of variables used by more than one routine.
 */

extern struct inode *rootdir;	/* pointer to inode of root directory */
extern short cputype;		/* type of cpu = 40, 45, 70, 780, 0x3b15 */
extern time_t lbolt;		/* time in HZ since last boot */
extern time_t time;		/* time in sec from 1970 */
extern int Dstflag;		/* configurable timezone */
extern int Timezone;		/* configurable DST flag */
extern int Hz;			/* Ticks/second of the clock */
extern int Cmask;		/* configurable cmask */

extern char runin;		/* scheduling flag */
extern char runout;		/* scheduling flag */
extern char runrun;		/* scheduling flag */
extern char curpri;		/* current priority */
extern struct proc *curproc;	/* current proc */
extern struct proc *old_curproc;/* previous curproc */
extern struct proc *oldproc;	/* previous proc that exited */
extern struct proc *runq;	/* head of linked list of running processes */

extern		maxmem;		/* max available memory (clicks) */
extern		physmem;	/* physical memory (clicks) on this CPU */
extern		maxclick;	/* Highest physical click + 1.		*/
extern daddr_t	swplo;		/* block number of start of swap space */
extern		nswap;		/* size of swap space in blocks*/
extern dev_t	rootdev;	/* device of the root */
extern dev_t	swapdev;	/* swapping device */
extern dev_t	pipedev;	/* pipe device */
extern dev_t	dumpdev;	/* dump device */
extern char	*panicstr;	/* panic string pointer */
extern		blkacty;	/* active block devices */
extern		pwr_cnt, pwr_act;
extern int 	(*pwr_clr[])();

int		selwait;	/* selecting processes wait on this */

dev_t getmdev();
struct inode *iget();
struct inode *namei();
struct inode *remote_call();
struct buf *getblk();
struct buf *geteblk();
struct buf *getablk();
struct buf *bread();
struct buf *breada();
struct file *falloc();
int	upath();
int	spath();
struct proc *prfind();

/*
 * Structure of the system-entry table
 */
extern struct sysent {
	char	sy_narg;		/* total number of arguments */
	char	sy_setjmp;		/* set to 1 if systrap() should not do a setjmp() */
	int	(*sy_call)();		/* handler */
} sysent[];

extern int nsysent;             /* number of valid entries in sysent */

#endif	/* _SYS_SYSTM_H */
