#ident	"@(#)stat.h	1.3 91/04/01"
#ifndef _SYS_STAT_H
#define _SYS_STAT_H
/*
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 *	Portions Copyright 1980-1989 Microsoft Corporation
 *   Portions Copyright 1983-1990 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	Copyright (c) 1987, 1988 Microsoft Corporation	*/
/*	  All Rights Reserved	*/

/*	This Module contains Proprietary Information of Microsoft  */
/*	Corporation and should be treated as Confidential.	   */

/* #ident	"@)#(head.sys:stat.h	1.3.1.2" */

#include <sys/types.h>

/*
 * stat structure, used by stat(2) and fstat(2)
 */
struct	stat {
	dev_t	st_dev;
	ino_t	st_ino;
	mode_t 	st_mode;
	nlink_t	st_nlink;
	uid_t 	st_uid;
	gid_t 	st_gid;
	dev_t	st_rdev;
	off_t	st_size;
	time_t	st_atime;
	time_t	st_mtime;
	time_t	st_ctime;
};

#define	S_IFMT	0170000		/* type of file */
#define		S_IFREG	0100000	/* regular */
#define		S_IFBLK	0060000	/* block special */
#define		S_IFNAM 0050000 /* special named file */
#define		S_IFDIR	0040000	/* directory */
#define		S_IFCHR	0020000	/* character special */
#define		S_IFIFO	0010000	/* fifo */
#define		S_ISREG(m)	(((m) & S_IFMT) == S_IFREG)
#define		S_ISBLK(m)	(((m) & S_IFMT) == S_IFBLK)
#define		S_ISNAM(m)	(((m) & S_IFMT) == S_IFNAM)
#define		S_ISDIR(m)	(((m) & S_IFMT) == S_IFDIR)
#define		S_ISCHR(m)	(((m) & S_IFMT) == S_IFCHR)
#define		S_ISFIFO(m)	(((m) & S_IFMT) == S_IFIFO)
#define S_INSEM 01		/* XENIX semaphore subtype of IFNAM file */
#define S_INSHD 02		/* XENIX shared data subtype of IFNAM file */
#define	S_ISUID	04000		/* set user id on execution */
#define	S_ISGID	02000		/* set group id on execution */
#define	S_ISVTX	01000		/* save swapped text even after use */
#define	S_ENFMT	S_ISGID		/* record locking enforcement flag */
#define	S_IRWXU	00700		/* read, write, execute: owner */
#define	S_IRUSR	00400		/* read permission: owner */
#define	S_IREAD		00400	/* read permission, owner */
#define	S_IWUSR	00200		/* write permission: owner */
#define	S_IWRITE	00200	/* write permission, owner */
#define	S_IXUSR	00100		/* execute permission: owner */
#define	S_IEXEC		00100	/* execute/search permission, owner */
#define	S_IRWXG	00070		/* read, write, execute: group */
#define	S_IRGRP	00040		/* read permission: group */
#define	S_IWGRP	00020		/* write permission: group */
#define	S_IXGRP	00010		/* execute permission: group */
#define	S_IRWXO	00007		/* read, write, execute: other */
#define	S_IROTH	00004		/* read permission: other */
#define	S_IWOTH	00002		/* write permission: other */
#define	S_IXOTH	00001		/* execute permission: other */

#ifndef INKERNEL

#if	defined(__STDC__) && !defined(NO_PROTOTYPE)
extern int  chmod(char *, mode_t);
extern int  stat(char *, struct stat *);
extern int  fstat(int, struct stat *);
extern int  mkdir(char *, mode_t);
extern int  mkfifo(char *, mode_t);
extern mode_t  umask(mode_t);
#else
extern int  chmod();
extern int  fstat();
extern int  mkdir();
extern int  mkfifo();
extern int  stat();
extern mode_t  umask();
#endif

#endif	/* INKERNEL */

#endif /* _SYS_STAT_H */
