/*
 *	@(#) space.h 2.6 88/07/13 
 *
 *	Copyright (C) The Santa Cruz Operation, 1984, 1985, 1986, 1987, 1988.
 *	Copyright (C) Microsoft Corporation, 1984, 1985, 1986, 1987, 1988.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation, Microsoft Corporation
 *	and AT&T, and should be treated as Confidential.
 */

/*
 * THIS FILE CONTAINS CODE WHICH IS SPECIFIC TO THE
 * INTEL CPU'S AND MAY REQUIRE MODIFICATION
 * WHEN ADAPTING XENIX TO NEW HARDWARE.
 */

#ifdef M_I386
#include  "page.h"
#include  "init.h"
#endif

#include  "seg.h"
#include  "buf.h"
#include  "proc.h"
#ifndef M_I386
#include  "text.h"
#endif
#include  "signal.h"
#include  "mmu.h"
#include  "file.h"
#include  "inode.h"
#include  "namei.h"
#include  "map.h"
#include  "callo.h"
#include  "mount.h"
#include  "var.h"
#include  "systm.h"
#include  "utsname.h"

#include  "locking.h"
#include  "ipc.h"
#include  "sd.h"
#include  "msg.h"
#include  "sem.h"
#include  "emap.h"
#include  "nmap.h"
#include  "sxt.h"
#include  "dio.h"
#include  "disk.h"

#ifdef M_I386
#include  "stream.h"
#include  "event.h"
#endif

int Timezone=TIMEZONE;
int Dstflag=DSTFLAG;
int Cmask=CMASK;
int dma_single=DMAEXCL;

#ifdef M_I386
int memlim=MEMLIM;
int swplim=SWPLIM;
#endif

#ifndef M_I386

char sabuf[NSABUF][BSIZE];

#if NBUF==0
struct buf buf[MAXBUF];
#else
struct buf buf[NBUF+NSABUF];
#endif

#endif

#ifdef M_I386
struct	pfree	pfreelist;	/* Head of physio header pool */
struct	buf	pbuf[NPBUF];	/* Physical io header pool */
struct  pgstat  pgstat;
#endif

struct hbuf hbuf[NHBUF];	/* buffer hash table */

#ifdef M_I386
struct file file[NFILE];
struct inode inode[NINODE];
struct namecache namecache[NINODE];
short i_txtcnt[NINODE];
#else
struct file  far file[NFILE];
struct inode far inode[NINODE];
struct namecache far namecache[NINODE];
#endif

struct locklist locklist[NFLOCKS];

struct sd sdtab[NSDSEGS * NSDSLOTS];
struct shmid_ent shmid_tab[NSDSEGS];
int    shmid_pos;
struct proc proc[NPROC];
#ifndef M_I386
struct text text[NTEXT];
#endif

#ifdef M_I386
struct mapent sptent[100];
struct map    sptmap = {0, 100, sptent};
#else
struct mapent coreent[CMAPSIZ];
struct map    coremap = {0, CMAPSIZ, coreent};
struct mapent swapent[SMAPSIZ];
struct map    swapmap = {0, SMAPSIZ, swapent};
#endif

struct callo callout[NCALL];
struct cblock cfree[NCLIST];
struct mount mount[NMOUNT];
struct emap emap[NEMAP];
struct nmap nmap[NEMAP];
struct Link sxtlink[NSXT];
struct diskinfo diskinfo[NDISK];

int Hz=HZ;

/* uts node name */
char node[SYS_NMLN] = NODE;

/* message facility */
struct	mapent		msgent[MSGMAP];
struct	map		msgmap = {0, MSGMAP, msgent};
struct  msqid_ds	msgque[MSGMNI];
struct	msg		msgh[MSGTQL];
struct	msginfo		msginfo = 
{
	MSGMAP,
	MSGMAX,
	MSGMNB,
	MSGMNI,
	MSGSSZ,
	MSGTQL,
	MSGSEG
};

/* System V semaphore facility */
struct	semid_ds	sema[SEMMNI];
struct	sem		sem[SEMMNS];
struct	mapent		sement[SEMMAP];
struct	map		semmap = {0, SEMMAP, sement};
struct	sem_undo	*sem_undo[NPROC];
#define SEMUSZ	(sizeof(struct sem_undo) + sizeof(struct undo) * SEMUME)
int	semu[((SEMUSZ * SEMMNU) + NBPW - 1) / NBPW];
union	
{
	ushort		semvals[SEMMSL];
	struct		semid_ds	ds;
	struct		sembuf		semops[SEMOPM];
}	semtmp;
struct	seminfo		seminfo =
{
	SEMMAP,
	SEMMNI,
	SEMMNS,
	SEMMNU,
	SEMMSL,
	SEMOPM,
	SEMUME,
	SEMUSZ,
	SEMVMX,
	SEMAEM,
};

#ifdef M_I386
struct  shminfo		shminfo386 =
{
	SHMMAX,
	SHMMIN,
	SHMMNI,
	SHMSEG,
	SHMBRK,
	SHMALL
};

struct  shminfo		shminfo286 =
{
	0x10000,
	1,
	SHMMNI,
	SHMSEG,
	SHMBRK,
	SHMALL
};
#endif

struct var v=
{
	NBUF,
	NSABUF,
	NHBUF,
	NHBUF-1,
	MAXBUF,
	NCALL,
	NINODE,
	&inode[NINODE],
	NFILE,
	&file[NFILE],
	NMOUNT,
	&mount[NMOUNT],
	NPROC,
	&proc[NPROC],
#ifndef M_I386
	NTEXT,
	&text[NTEXT],
#endif
	NCLIST,
	MAXUPRC,
	MAXMEM,
	NFLOCKS,
	NSDSEGS,
	NSDSLOTS,
	MSGMAP,
	MSGMAX,
	MSGMNB,
	MSGMNI,
	MSGTQL,
	MSGSSZ,
	MSGSEG,
	SEMMAP,
	SEMMNI,
	SEMMNU,
	SEMMSL,
	SEMOPM,
	SEMUME,
	SEMVMX,
	SEMAEM,
	SEMMNS,
	SEMUSZ,
	NSCRN,
	NPBUF,
	NEMAP,
	NSXT,
#ifdef  M_I386
	SHMMAX,
	SHMMIN,
	SHMMNI,
	SHMSEG,
	SHMBRK,
	SHMALL,
	NSDSEGS*NSDSLOTS,
#else	/* not yet for 286 */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
#endif
	NQUEUE,
	NSTREAM,
	NBLK8192,
	NBLK4096,
	NBLK2048,
	NBLK1024,
	NBLK512,
	NBLK256,
	NBLK128,
	NBLK64,
	NBLK32,
	NBLK16,
	NBLK4,
	NDISK,
	EVQUEUES,
	EVDEVS,
	EVDEVSPERQ,
	SCRNMEM,
	KBTYPE,
};

#ifdef M_I386
/* Streams Data Structures and tuneable variables */
struct queue queue[NQUEUE];
struct stdata streams[NSTREAM];
mblk_t mblock[NMBLOCK];
dblk_t dblock[NDBLOCK];
struct linkblk linkblk[NMUXLINK];
struct strevent strevent[NSTREVENT];
int nmblock = NMBLOCK;
int nmuxlink = NMUXLINK;
int nstrpush = NSTRPUSH;
int nstrevent = NSTREVENT;
int maxsepgcnt = MAXSEPGCNT;
int strmsgsz = STRMSGSZ;
int strctlsz = STRCTLSZ;
char strlofrac = STRLOFRAC;
char strmedfrac = STRMEDFRAC;
#endif /* M_I386 */

/* Event driver/line discipline data structures */
struct evldchan evldchan[EVDEVS];
struct evdev	evdevice[EVDEVS];
struct evchan	evchannel[EVQUEUES];

char	evdindextab[EVQUEUES * EVDEVSPERQ];
char	*evdindex[EVQUEUES];
