#ident	"@(#)signal.h	1.3 91/04/01"
#ifndef _SYS_SIGNAL_H
#define _SYS_SIGNAL_H

/*
 *   Portions Copyright 1983-1990 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ifndef SIGNAL_H_INCLUDED
#define SIGNAL_H_INCLUDED

#define	SIGHUP	1	/* hangup */
#define	SIGINT	2	/* interrupt (rubout) */
#define	SIGQUIT	3	/* quit (ASCII FS) */
#define	SIGILL	4	/* illegal instruction (not reset when caught)*/
#define	SIGTRAP	5	/* trace trap (not reset when caught) */
#define	SIGIOT	6	/* IOT instruction */
#define SIGABRT 6	/* used by abort, replace SIGIOT in the  future */
#define	SIGEMT	7	/* EMT instruction */
#define	SIGFPE	8	/* floating point exception */
#define	SIGKILL	9	/* kill (cannot be caught or ignored) */
#define	SIGBUS	10	/* bus error */
#define	SIGSEGV	11	/* segmentation violation */
#define	SIGSYS	12	/* bad argument to system call */
#define	SIGPIPE	13	/* write on a pipe with no one to read it */
#define	SIGALRM	14	/* alarm clock */
#define	SIGTERM	15	/* software termination signal from kill */
#define	SIGUSR1	16	/* user defined signal 1 */
#define	SIGUSR2	17	/* user defined signal 2 */
#define	SIGCLD	18	/* death of a child */
#define	SIGPWR	19	/* power-fail restart */
#define SIGWINCH 20	/* window change */

			/* SIGPHONE only used in UNIX/PC */
/*#define SIGPHONE 21*/	/* handset, line status change */

#if	defined( M_XOUT )
#	define	SIGPOLL	20	/* pollable even occurred */
#else
#	define SIGPOLL 22	/* pollable event occured */
#endif

#define SIGCHLD SIGCLD  /* compatibility */

#if	defined( M_UNIX )
#	define SIGSTOP 23      /* sendable stop signal not from tty */
#	define SIGTSTP 24      /* stop signal from tty */
#	define SIGCONT 25      /* continue a stopped process */
#	define SIGTTIN 26      /* to readers pgrp upon background tty read */
#	define SIGTTOU 27      /* like TTIN for output if (tp->t_local&TOSTOP) */

#	define	SIGALL          (~(sigset_t)0L)		/* new for POSIX */

#	define	NSIG	28	/* The valid signal number is from 1 to NSIG-1 */
#	define MAXSIG	32	/* size of u_signal[], NSIG-1 <= MAXSIG*/
			/* MAXSIG is larger than we need now. */
			/* In the future, we can add more signal */
			/* number without changing user.h */

#	define	SIG_SETMASK	0	/* set mask in sigprocmask. new for POSIX */
#	define	SIG_BLOCK	1	/* union mask in sigprocmask. new for POSIX */
#	define	SIG_UNBLOCK	2	/* intrsct mask in sigprocmask. new for POSIX */
#else
#	define	NSIG	20
#	define	MAXSIG	32
#endif	/* M_UNIX */

typedef	long	sigset_t;

#define         sigbit(n)       (1L << ((n) - 1))
#define         sigemptyset(s)  (*(s) = ~SIGALL)

#ifdef INKERNEL

#define         sigfillset(s)   (*(s) = SIGALL)
#define         sigaddset(s,n)  (*(s) |= sigbit(n))
#define         sigdelset(s,n)  (*(s) &= ~sigbit(n))
#define         sigismember(set,n) ((*(set) & sigbit(n)) == sigbit(n))

#endif /* INKERNEL */

/*
 * Signal vector "template" used in sigaction call.
 */
struct  sigaction {
        void    (*sa_handler)();        /* signal handler */
        sigset_t sa_mask;               /* signal mask to apply */
        int     sa_flags;               /* see signal options below */
};

#define         SA_NOCLDSTOP    0x01	/* ignore SIGCHLD */
#define		SA_SIGACTION	0x80	/* signify that we use sigaction()
					 * instead of other signal mechanisms
					 */


#if lint
#define SIG_ERR (void(*)())0
#else
#define SIG_ERR	(void(*)())-1
#endif
#define	SIG_DFL	(void(*)())0
#if lint
#define	SIG_IGN	(void (*)())0
#else
#define	SIG_IGN	(void (*)())1
#endif
#if lint
#define SIG_HOLD (void(*)())0
#else
#define SIG_HOLD (void(*)())2
#endif

/* The following definitions are only used by kernel */
#ifdef INKERNEL
#define SIGNO_MASK	0xff
#define SIGDEFER	0x100
#define SIGHOLD		0x200
#define SIGRELSE	0x400
#define SIGIGNORE	0x800
#define SIGPAUSE	0x1000
#endif

#endif	/* SIGNAL_H_INCLUDED */
#endif	/* _SYS_SIGNAL_H */
