#ident "@(#)scsi.h	2.6 90/12/21"
#ident "@(#)scsi.h	1.11 90/07/27"
#ident	"@(#) scsi.h 22.2 89/10/23 "
#ifndef _SYS_SCSI_H
#define _SYS_SCSI_H
/*
 *	Copyright (C) The Santa Cruz Operation, 1988, 1989.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and should be treated as Confidential.
 */

#define SCSI_MAXDEVS	16		/* maximum number of each device type
					   supported under SCSI */
#define SCSI_CMD_LEN	14		/* Maximum SCSI command length */
#define	INQUIRY_LEN	(40 - 4)	/* temp	/* 2 bytes of data required */
#define	MODE_LEN	200		/* 200 bytes of data required	*/
#define READ_CAP_LEN	8

#define SCSI_SEND	0		/* types of adapter calls */
#define SCSI_INIT	1		/* SCO gets 0 - 50 */
#define	SCSI_BUS_RESET	2		/* do immediate bus reset */
#define SCSI_SG		3		/* do scatter-gather command */
#define SCSI_INFO	4		/* return info about capabilities */
#define SCSI_SLOT	5		/* return slot number of host adapter */

#define SCSI_IO		0		/* type of transaction */
#define SCSI_HA_CMD	1

#define SCSI_GO		1		/* start */

#define SCSI_IN		1		/* transfer direction */
#define SCSI_OUT	2

#define SCSI_DISK_INFO	0		/* adapter disk info */
#define SCSI_TAPE_INFO	1		/* adapter tape info */
#define	SCSI_SET_ASYNC	2		/* ensure async xfer */

#define	NADAPTERS	2	/* number of adapters supported	*/
#define	NADCTLS		16	/* this many controllers	*/
#define	NAD		 4	/* this many devices per ctlr	*/
#define	CMDLENGTH	14	/* MAX SCSI command length	*/
#define	SENSE_LEN	14	/* length of sense data		*/
#define	NADDEVICES     	(NAD * NADCTLS)  /* total possible devices */
#define NADRETRY        4	/* max software retry count	*/
#define	OUTBOARD	2	/* used for getablk calls	*/

				/* sense bit definitions	*/
#define	SS_FM		0x80	/* file mark detected		*/
#define	SS_EOM		0x40	/* end-of-media			*/
#define	SS_ILI		0x20	/* illegal length inidicator	*/

#define	SS_SKEY		0x0F	/* sense key mask		*/

				/* sense key definitions	*/
#define	SS_NONE		0x0	/* no sense			*/
#define	SS_SOFT		0x1	/* recoverable error		*/
#define	SS_NOTRDY	0x2	/* drive not ready 		*/
#define	SS_MEDERR	0x3	/* media error			*/
#define	SS_HARDERR	0x4	/* hardware error		*/
#define	SS_ILLREQ	0x5	/* illegal request		*/
#define	SS_UATT		0x6	/* unit attention		*/
#define	SS_WPROT	0x7	/* write protected		*/
#define	SS_BLANK	0x8	/* blank check 			*/
#define	SS_COPYAB	0xA	/* copy aborted 		*/
#define	SS_CMDAB	0xB	/* command aborted		*/
#define	SS_VOFLOW	0xD	/* volume overflow		*/

#define	LTHIB(x)	( (x >> 24) & 0xff)
#define	LTMSB(x)	( (x >> 16) & 0xff)
#define	LTMID(x)	( (x >>  8) & 0xff)
#define	LTLSB(x)	(        x  & 0xff)
#define	LTBLKS(x)	(        x  >> 9)

				/* driver issued commands	*/
#define	CMD_INVALID	0xFF	/* invalid command		*/
#define	TEST_CMD	0x00 
#define	SENSE_CMD	0x03
#define	REASSIGN_CMD	0x07
#define	REASSIGN_IND	0xFF	/* special case, see adioctl	*/	
#define	RD_BACK_CMD	0x07
#define	READ_CMD	0x08
#define	WRITE_CMD	0x0A
#define	REWIND_CMD	0x01	/* also a recal			*/
#define	SEEK_CMD	0x0B
#define	SETTRK_CMD	0x0B
#define	FORMAT_CMD	0x04
#define	INQUIRY_CMD	0x12
#define	MODESELECT_CMD	0x15
#define	MODESENSE_CMD	0x1A
#define	START_UNIT_CMD	0x1B
#define	READ_CAP_CMD	0x25
				/* specific device commands	*/
#define	TP_RDB		0x0F
#define	TP_WFM		0x10
#define	TP_SP		0x11
#define	TP_LOAD		0x1B
#define	TP_ERASE	0x19
				/* command specific option bits	*/
#define	CCS_FORMAT	0x01	/* inquiry data in CCS format	*/
#define	VENDOR_BITS	0x00	/* always zero			*/
#define	FLAG_LINK	0x00	/* no linked commands		*/
#define	WRTLENCHK	0x10	/* outbound lengths checked	*/
#define	RDLENCHK	0x08	/* inbound lengths checked	*/
#define	MODE_SP		0x01	/* save parameters bit		*/
#define	FIXED		0x01	/* fixed size blocks		*/
#define	IMMED		0x01	/* immediate status		*/
#define	SILI_BIT	0x02	/* suppress incorrect length	*/
#define	PCF		0x00	/* request current values	*/
#define	PAGE_CODE_ERR	0x01	/* r/w error recovery		*/
#define	PAGE_CODE_CON	0x02	/* disconnect & reconnect	*/
#define	PAGE_CODE_FMT	0x03	/* DA format parameters (RO)	*/
#define	PAGE_CODE_GEO	0x04	/* geometry parameters  (RO)	*/
#define	PAGE_CODE_DCP	0x39	/* Quatum DCP			*/
#define	PAGE_CODE_ALL	0x3f	/* request all fields		*/
#define	FMTDAT_BIT	0x00	/* data list follows cmd	*/
#define	CMPLST_BIT	0x00	/* list is not complete		*/
#define	DEFECT_LST_FMT	0x00	/* grown list saved		*/
#define	FMT_FLAGS	(FMTDAT_BIT | CMPLST_BIT | DEFECT_LST_FMT)
#define	DATAPATTERN	0xEB	/* format data pattern		*/
#define	DEF_INTERL	0x10	/* default interleave		*/
#define	FMT_OPTIONS	0x00	/* with Quantum in mind		*/

/* sense keys */

#define SCSI_NO_SENSE	0
#define SCSI_REC_ERROR	1
#define SCSI_NOT_READY	2
#define SCSI_MED_ERROR	3
#define SCSI_HARD_ERROR	4
#define SCSI_ILL_REQ	5
#define SCSI_UNIT_ATTN	6
#define SCSI_DATA_PROT	7
#define SCSI_BLANK_CHK	8
#define SCSI_VEND_UNIQ	9
#define SCSI_COPY_ABORT	10
#define SCSI_CMD_ABORT	11
#define SCSI_EQUAL	12
#define SCSI_VOL_OVF	13
#define SCSI_MISCOMPARE	14
#define SCSI_RESERVED	15

#define	REQ_DONE	0x01	/* command completed OK		*/
#define	REQ_ABORTED_OK	0x02	/* command aborted by host	*/
#define	REQ_ABORTED_BAD	0x03	/* aborted command not found	*/
#define	REQ_DONE_ERROR 	0x04	/* command completed w/ errors	*/
#define	REQ_LINKED_OK	0x0A	/* linked cmd completed OK	*/
#define	REQ_LINKED_BAD	0x0B	/* linked cmd completed BAD	*/
#define	REQ_TIMEOUT	0x11	/* selection time out		*/
#define	REQ_OVERRUN	0x12	/* data overrun			*/
#define	REQ_BUS_FREE	0x13	/* unexpected bus free		*/
#define	REQ_BUS_PHASE	0x14	/* target bus phase seq. error	*/
#define	REQ_COMMAND	0x15	/* command is not allowed       */

struct exten {				/* extension structre */
	int type;			/* type of extension */
	struct exten *next;		/* pointer to next extension */
	char data[20];			/* most adapters do byte I/O */
};
typedef struct exten EXTENSION;

struct scsi_dev_cfg {
	int index;
	char *dev_name;			/* device prefix */
	dev_t devnum;			/* device number */
	unsigned char ha_num;		/* host adapter number (0, 1, 2, ...) */
	unsigned char id;		/* SCSI priority and address */
	unsigned char lun;		/* logical unit number of device */
	/*
	 * Corollary is using the blank fill byte immediately
	 * following "lun" for multiprocessing purposes.
	 */
	int (*adapter_entry)();		/* host adapter entry point */
	struct exten *dext;	        /* extensions to SCSI spec */
};
typedef struct scsi_dev_cfg DEVCFG;

struct scsi_ha_cfg {
	paddr_t ha_base;		/* host adapter base address */
	char *ha_name;			/* host adapter prefix */
	unsigned char ha_num;		/* host adapter number (0, 1, 2, ...) */
	unsigned char dmach;		/* dma channel */
	unsigned char vec;		/* interrupt channel */
	int (*adapter_entry)();		/* host adapter entry point */
	struct exten *hext;	        /* extensions to SCSI spec */
}; 
typedef struct scsi_ha_cfg HACFG;

#pragma pack(1)

struct	inq_data {
	char	dev_type;	/* device type			*/
	char	rmb_dtq;	/* RMD & dev type qualifier	*/
	char	vers;		/* version			*/
	char	rdf;		/* response data format		*/
	char	len;		/* length of additional data	*/
	char	add_data;	/* optional data area		*/
} ;
typedef struct inq_data INQ_DATA;

/* mode sense/select data structures */

struct scsi_block_descr {
	char density;
	char num_blks[3];
	char reserved;
	char blk_len[3];
};

struct scsi_mode_sense {
	unsigned char data_len;
	unsigned char medium;
	unsigned char speed:4;
	unsigned char buffered:3;
	unsigned char wprot:1;
	unsigned char bdescr_len;
	struct scsi_block_descr bdescr;
};

struct scsi_sense {
	unsigned char	error:7;
	unsigned char	valid:1;
	unsigned char	segno;
	unsigned char	key:4;
	unsigned char	reserved:1;
	unsigned char	ili:1;
	unsigned char	eom:1;
	unsigned char	filemark:1;
	long 		info;
	unsigned char 	addl_len;
	unsigned long	cmdinfo;
	unsigned char	addl_code;
	unsigned char	addl_qual;
/*	unsigned char	fruc;
	unsigned char	key_specific[3];*/
};

union scsi_cdb {		
	struct SixCmd {
		unsigned char opcode;
		unsigned char misc:5;
		unsigned char lun:3;
		unsigned char data[3];
		unsigned char control;
	} six;
	struct TenCmd {
		unsigned char opcode;
		unsigned char misc:5;
		unsigned char lun:3;
		unsigned long block;
		unsigned char reserved;
		unsigned short length;
		unsigned char control;
	} ten;
	struct TwelveCmd {
		unsigned char opcode;
		unsigned char misc:5;
		unsigned char lun:3;
		unsigned long block;
		unsigned long length;
		unsigned char reserved;
		unsigned char control;
	} twelve;
	unsigned char raw[12+sizeof(struct scsi_sense)];
};

#pragma pack()

struct	flg {
	u_char	sg_req:1;	/* scatter/gather request		*/
	u_char	active:1;	/* command started on this request	*/
	u_char	dma_req:1;	/* dma in progress flag			*/
	u_char	low_lev:1;	/* command executing in low-level mode  */
	u_char	discon:1;	/* unit has disconnected		*/
	u_char	recon:1;	/* reconnect pending			*/
	u_char	notmr:1;	/* decrement timer, but nothing else	*/
	u_char	check:1;	/* SCSI check condition 		*/
	u_char	req_sens:1;	/* internal request sense cmd in prog.	*/
	u_char	bus_pend:1;	/* bus service interrupt pending	*/
	u_char	status:1;	/* status phase in progress		*/
	u_char	messin:1;	/* message in phase in progress		*/
	u_char	fill:4;		/* pad bits				*/
};

struct scsi_io_req {			/* scsi io request block */
	unsigned short req_type;	/* one of the classes of calls to 
					   the adapter driver module */
	struct scsi_io_req *req_forw;	/* forward pointer to next 
					   scsi_io request block */
	struct exten *ext_p;		/* normally reserved, ptr to
					   SCSI extensions structure */
	char	opcode;
	char	id;
	char	lun;
	char	ha_num;		/* host adapter number		*/
	char	dir;
	char	cmdlen;		/* CMDLENGTH			*/
	paddr_t	data_len;	/* data length			*/
	paddr_t	data_ptr;	/* data pointer			*/
	paddr_t	data_blk;	/* logical block		*/
	paddr_t	link_ptr;	/* link pointer			*/
	char	link_id;
	char	host_sts;
	char	target_sts;
	union scsi_cdb scsi_cmd;
	char	sense_len;
	paddr_t	scsi_sense;
	paddr_t	req_id;		/* request block's id		*/

	/* below is only used by each driver	*/

	char	use_flag;	/* zero if available			*/
	char	internal;	/* driver internal request if non-zero	*/
	char	jq;		/* job queue index			*/
	char	ctlr;		/* controller address			*/
	char	req_status;	/* req blk status at intr time		*/
	char	adapter;	/* adapter base address			*/
	char	r_count;	/* retry count				*/
	char	hacmd;		/* host adapter command			*/
	struct	buf * rbuf;	/* request per this buf if non zero	*/
	int (*io_intr)();	/* device driver intr handler */
	char	*s1;		/* for use by drivers */
	char 	*s2;

/*
 *	The following are used by the bi SCSI host adapter driver and
 *	are Altos extensions.
 */

	struct scsi_io_req *req_back;	/* backward pointer to previous blk */
	char	saved_ptr[3];	/* saved data pointer (three bytes)	*/
	char	state;		/* copy of the Command Phase Register	*/
	int	dma_resid;	/* DMA residual byte count		*/
	struct scsi_sg_list *sg; /* scatter/gather list			*/
	short	sg_cnt;		/* number of entries in scatter list	*/

	union {
		struct	flg flgs;/* request state flags			*/
		short	clrflg;	/* setting this to zero clears all flgs */
	} fl;


};
typedef struct scsi_io_req REQ_IO;


extern struct scsi_io_req	*reqiobuf;
extern struct scsi_io_req	riofreelist;

struct scsi_sg_list {
	unsigned int 	length;
	paddr_t	 	data;	
};
typedef struct scsi_sg_list SG_LIST;

struct scsi_ha_info {
	unsigned int do_sg:1;		/* 1 if adapter does scatter/gather */
	unsigned int do_buffer:1;	/* 1 if adapter buffers cmds */
	unsigned int reserved:29;	/* reserved for future use */
	unsigned int do_retry:1;	/* 1 if adapter does retry */
};
typedef struct scsi_ha_info HAINFO;

extern long scsi_stol();		/* scsi 4 byte value to 4 byte	*/
extern long scsi_s3tol();		/* scsi 3 byte value to 4 byte	*/
extern caddr_t scsi_stok();		/* scsi 3 byte adr to kernel */
extern scsi_mkadr();			/* convert 4 byte address 
					   to 3 byte address */
extern scsi_mkadr3();

struct scsi_oemtab {
	char *name;
	char *model;
	int (*init_fn)();
};

#define F_OPEN	1
#define F_CLOSE 2
#define F_IOCTL 3

struct Sadapter {
	char *name;			/* Host adapter name */
	int (*adapter_entry)();		/* Host adapter entry routine */
	int (*adapter_restart)();	/* Host adapter restart routine */
	int (*adapter_shutsave)();	/* Host adapter shutsave routine */
	char chans_per_board;		/* Number of channels per board */
};

#define ADD_DISK	1		/* ioctl to dynamically add disks */

#endif	/* _SYS_SCSI_H */
