#ident	"@(#)proc.h	1.3 91/04/01"
#ifndef _SYS_PROC_H
#define _SYS_PROC_H

/*
 *	Portions Copyright 1983-1990 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 *
 *      Portions Copyright (C) Corollary, Inc., 1986, 1987, 1988, 1989, 1990.
 *      All Rights Reserved.
 *      This Module contains Proprietary Information of
 *      Corollary, Inc., and should be treated as Confidential.
 */

/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	Copyright (c) 1987, 1988 Microsoft Corporation	*/
/*	  All Rights Reserved	*/

/*	This Module contains Proprietary Information of Microsoft  */
/*	Corporation and should be treated as Confidential.	   */

/*	One structure allocated per active process. It contains all
**	data needed about the process while the process may be swapped
**	out.  Other per process data (user.h) may swapped with the
**	process but in fact it is not.
*/
#include <sys/signal.h>
#include <sys/ci/cilock.h>


typedef struct	proc {
	char	p_stat;			/* status of process */
	char	p_pri;			/* priority, negative is high */
	char	p_cpu;			/* cpu usage for scheduling */
	char	p_nice;			/* nice for cpu usage */
	uint	p_flag;			/* flags defined below */
	ushort	p_uid;			/* real user id */
	ushort	p_suid;			/* saved (effective) uid from exec */
	int	p_sid;			/* POSIX session id number */
	short	p_pgrp;			/* name of process group leader */
	short	p_pid;			/* unique process id*/
	short	p_ppid;			/* process id of parent*/
	ushort	p_sgid;			/* saved (effective) gid from exec */
	sigset_t	p_sig;		/* signals pending to this process */
	struct	proc	*p_flink;	/* forward link */
	struct	proc	*p_blink;	/* backward link */
	union {				/* wait addr for sleeping processes */
		caddr_t	p_cad;		/* Union is for XENIX compatibility */
		int	p_int;
	} p_unw;
#define	p_wchan	p_unw.p_cad		/* Map MP name to old UNIX name */
#define	p_arg	p_unw.p_int		/* Map MP name to old UNIX name */
	struct	proc	*p_parent;	/* ptr to parent process */
	struct	proc	*p_child;	/* ptr to first child process */
	struct	proc	*p_sibling;	/* ptr to next sibling proc on chain */
	int	p_clktim;		/* time to alarm clock signal */
	uint	p_size;			/* size of swappable image in pages */
	time_t	p_utime;		/* user time, this process */
	time_t	p_stime;		/* system time, this process */
	struct  proc *p_mlink;		/* linked list of processes sleeping
					 * on memwant or swapwant
					 */
	ushort	p_usize;		/* size of u-block (*4096 bytes) */
	ushort	p_res1;			/* Pad because p_usize is replacing
					 * a paddr_t (i.e., long) field, and
					 * it is only a short.
					 */
	caddr_t	p_ldt;			/* address of ldt */
	long	p_res2;			/* Pad because a 'pde_t *' field was
					 * removed here.  Its function is
					 * replaced by p_ubptbl[MAXUSIZE].
					 */

	preg_t	*p_region;		/* process regions */
	ushort	p_mpgneed;		/* number of memory pages needed in
					 * memwant.
					 */
	char	p_time;			/* resident time for scheduling */
	unchar	p_cursig;		/* current signal */
	short	p_epid;			/* effective pid; normally same as
					 * p_pid; for servers, the system that
					 * sent the msg
					 */
	sysid_t p_sysid;		/* normally same as sysid; for servers,
					 * the system that sent the msg
					 */
	struct	rcvd  *p_minwd;		/* server msg arrived on this queue */
	struct	proc  *p_rlink;		/* linked list for server */
	int	p_trlock;
	struct	inode *p_trace;		/* pointer to /proc inode */
	long	p_sigmask;		/* tracing signal mask for /proc */
	sigset_t	p_hold;		/* hold signal bit mask */
	sigset_t	p_chold;	/* deferred signal bit mask; sigset(2)
					 * turns these bits on while signal(2)
					 * does not.
					 */
	short	p_xstat;		/* exit status for wait */
	short	p_slot;			/* proc slot we're occupying */
	struct  v86dat *p_v86;          /* pointer to v86 structure */
	dbd_t	p_ubdbd;		/* DBD for ublock when swapped out */
	ushort	p_whystop;		/* Reason for process stop */
	ushort	p_whatstop;		/* More detailed reason */
	pde_t	p_ubptbl[MAXUSIZE];	/* u-block page table entries */
	struct	sd *p_sdp;		/* pointer to XENIX shared data */
	int	p_sigflags[MAXSIG];	/* modify signal behavior (POSIX) */
} proc_t;

#define	p_link	p_flink

extern struct proc proc[];		/* the proc table itself */

/* stat codes */

#define	SSLEEP	1		/* awaiting an event */
#define	SRUN	2		/* running */
#define	SZOMB	3		/* process terminated but not waited for */
#define	SSTOP	4		/* process stopped by debugger */
#define	SIDL	5		/* intermediate state in process creation */
#define	SONPROC	6		/* process is being run on a processor */
#define SXBRK	7		/* process being xswapped */

/* flag codes */

#define	SSYS	0x00000001	/* system (resident) process */
#define	STRC	0x00000002	/* process is being traced */
#define	SWTED	0x00000004	/* ptraced process has been given to parent
				 * by wait(2); don't return this process to
				 * parent again until it runs first.
				 */
#define	SNWAKE	0x00000008	/* process cannot be awakened by a signal */
#define	SLOAD	0x00000010	/* in core */
#define	SLOCK   0x00000020	/* process cannot be swapped */
#define	SRSIG	0x00000040	/* set when signal goes remote */
#define	SPOLL	0x00000080	/* process in stream poll */
#define SSEL	SPOLL		/* or doing select() (see SPOLL) */
#define	SPRSTOP	0x00000100	/* process is being stopped via /proc */
#define	SPROCTR	0x00000200	/* signal or syscall tracing via /proc */
#define	SPROCIO	0x00000400	/* doing I/O via /proc, so don't run */
#define	SSEXEC	0x00000800	/* stop on exec */
#define	SPROPEN	0x00001000	/* process is open via /proc */
#define	SULOAD  0x00002000	/* u-block in core */
#define	SRUNLCL	0x00004000	/* set process running on last /proc close */
#define	SNOSTOP	0x00008000	/* proc asleep, stop not allowed */
#define	SPTRX	0x00010000	/* process is exiting via ptrace(2) */
#define	SASLEEP	0x00020000	/* proc is stopped within a call to sleep() */
#define	SUSWAP	0x00040000	/* u-block is being swapped in or out */
#define	SUWANT	0x00080000	/* waiting for u-block swap to complete */
				/* POSIX changes below */
#define SOMASK	0x00100000	/* restore old mask after taking signal */
#define SNEXEC	0x00200000	/* child of a fork, but no exec yet */

#define PTRACED(p)	((p)->p_flag&(STRC|SPROCTR|SSEXEC|SPROPEN))

#define	ubptbl(PP)	((PP)->p_ubptbl)
/* Flags for newproc() */

#define NP_FAILOK	0x1	/* don't panic if cannot create process */
#define NP_NOLAST	0x2	/* don't use last process slot */
#define	NP_SYSPROC	0x4	/* system (resident) process */

/* Reasons for stopping (values of p_whystop) */

#define	REQUESTED	1
#define	SIGNALLED	2
#define	SYSENTRY	3
#define	SYSEXIT		4

/* Macro to reduce unnecessary calls to issig() */

#define	ISSIG(p, why) \
  ((p)->p_cursig || (((p)->p_sig || ((p)->p_flag & SPRSTOP)) && issig(why)))

/* Reasons for calling issig() */

#define	FORREAL		0	/* Usual side-effects */
#define	JUSTLOOKING	1	/* Don't stop the process */

#endif	/* _SYS_PROC_H */
