#ident	"@(#)param.h	1.2	90/08/08"
#ifndef _SYS_PARAM_H
#define _SYS_PARAM_H
#ident "@(#) param.h 22.1 90/01/15 "
#ident "@(#)param.h	1.2 89/09/29"
#ident "@(#) param.h 1.11 89/08/10 "

/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	Copyright (c) 1987, 1988 Microsoft Corporation	*/
/*	  All Rights Reserved	*/

/*	This Module contains Proprietary Information of Microsoft  */
/*	Corporation and should be treated as Confidential.	   */

/*
 *	Copyright (C) The Santa Cruz Operation, 1988, 1989.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and should be treated as Confidential.
 */

/*
 * fundamental variables
 * don't change too often
 */
#include <sys/fs/s5param.h>

#define	MAXPID	30000		/* max process id */
#define	MAXUID	60000		/* max user id */
#define	MAXLINK	1000		/* max links */

#define	SSIZE	1		/* initial stack size (*4096 bytes) */
#define	SINCR	1		/* increment of stack (*4096 bytes) */
#define	USIZE	MINUSIZE	/* initial size of user block (*4096 bytes) */
#define	MINUSIZE  2		/* min size of user block (*4096 bytes) */
#define	MAXUSIZE 18		/* max size of user block (*4096 bytes) */

#define	CANBSIZ	256		/* max size of typewriter line	*/
#define	HZ	60		/* 60 ticks/second of the clock */

#define	NCARGS	5120		/* # characters in exec arglist */
				/*   must be multiple of NBPW.  */

/*	The following define is here for temporary compatibility
**	and should be removed in the next release.  It gives a
**	value for the maximum number of open files per process.
**	However, this value is no longer a constant.  It is a
**	configurable parameter, NOFILES, specified in the kernel
**	master file and available in v.v_nofiles.  Programs which
**	include this header file and use the following value may
**	not operate correctly if the system has been configured
**	to a different value.
*/

#define	NOFILE	60

/*	The following represent the minimum and maximum values to
**	which the paramater NOFILES in the kernel master file may
**	be set.
*/

#define	NOFILES_MIN	 20
#define	NOFILES_MAX	100

/*	The following represents the maximum value to which
**	the parameter NGROUPS in the kernel master file may be set.
**
**	New for POSIX
*/

#define NGROUPS_MAXTUNE	16
#define NULLGROUP	((gid_t) 65535)

/*	The following defines apply to the kernel virtual
**	address space.
*/

#define	SYSSEGSZ 1024	/* The size of the kernel segment	*/
			/* sysseg in pages.  The starting	*/
			/* address comes from the vuifile.	*/

#define	MAXKSEG		127	/* max no of pages per kseg */

/*	To avoid prefetch errors at the end of a region, it must
**	be padded with the following number of bytes.
*/

#define	PREFETCH	0

/*
 * priorities
 * should not be altered too much
 */

#define	PMASK	0177
#define	PCATCH	0400
#define	PNOSTOP	01000
#define	PSWP	0
#define	PINOD	10
#define	PRIBIO	20
#define	PZERO	25
#define PMEM	0
#define	NZERO	20
#define	PPIPE	26
#define	PWAIT	30
#define	PSLEP	39
#define	PUSER	60
#define	PIDLE	127

/*
 * Priority for tracing (ptrace and paccess)
 */

#define	IPCPRI	PZERO

/*
 * fundamental constants of the implementation--
 * cannot be changed easily
 */

#define	NBPW	sizeof(int)	/* number of bytes in an integer */
#define	NCPPT	1024		/* Number of clicks per page table */
#define	CPPTSHIFT	10	/* LOG2(NCPPT) if exact */
#define	NBPC	4096		/* Number of bytes per click */
#define	BPCSHIFT	12	/* LOG2(NBPC) if exact */

#ifndef NULL
#define	NULL	0
#endif

#define	CDLIMIT	(1L<<14)	/* default max write address */
#define	NODEV	(dev_t)(-1)
#define NBPSCTR         512     /* Bytes per LOGICAL disk sector. */
#define SCTRSHFT        9       /* Shift for BPSECT.            */

#define	UMODE	3		/* current Xlevel == user */
#define	USERMODE(cs)	(((cs) & SEL_RPL) == UMODE)

#define	lobyte(X)	(((unsigned char *)&X)[0])
#define	hibyte(X)	(((unsigned char *)&X)[1])
#define	loword(X)	(((ushort *)&X)[0])
#define	hiword(X)	(((ushort *)&X)[1])

#define	MAXSUSE	255

/* REMOTE -- whether machine is primary, secondary, or regular */
#define SYSNAME 9		/* # chars in system name */
#define PREMOTE 39

/* XENIX compatibility */
#define	ktop(vaddr)	((paddr_t)svirtophys(vaddr))
#define ptok(vaddr) 	(phystokv(vaddr))

/* Maxmimum pathsize acceptable to namei */

#if MINUSIZE == 2 && NBPC < 4096
#define PATHSIZE	512
#else
#define PATHSIZE	1024
#endif

#endif	/* _SYS_PARAM_H */
