/*      @(#)slip.h	3.1 LAI System V.3 STREAMS TCP/IP  source        */
/*
 * System V STREAMS TCP - Release 3.0 
 *
 * Copyright 1987, 1988, 1989 Lachman Associates, Incorporated (LAI) 
 * All Rights Reserved. 
 *
 * The copyright above and this notice must be preserved in all copies of this
 * source code.  The copyright above does not evidence any actual or intended
 * publication of this source code. 
 *
 * This is unpublished proprietary trade secret source code of Lachman
 * Associates.  This source code may not be copied, disclosed, distributed,
 * demonstrated or licensed except as expressly authorized by Lachman
 * Associates. 
 *
 * System V STREAMS TCP was jointly developed by Lachman Associates and
 * Convergent Technologies. 
 */
/*
 * Copyright (c) 1985 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef slip__h
#define slip__h
#ident	"@(#)slip.h	1.2 :/source/uts/common/netinet/s.slip.h 2/11/87 20:46:28"

/*
 * N.B.: SLMTU is now a hard limit on input packet size. SLMTU must be <=
 * CLBYTES - sizeof(struct ifnet *). 
 */
#define	SLMTU	1006

/* per physical unit structure */
struct sl_softc {
	u_char          sc_flags;	/* see below */
	long            sc_sap;		/* link type for current packet */
	mblk_t         *sc_msgb;	/* input packet */
	struct sl_pcb  *sc_curpcb;	/* current output consumer for this
					 * unit */
	queue_t		*sc_rdq;	/* queue to tty */
	struct ifstats  sc_stats;	/* netstat stuff */
};

/* per minor stucture; minor is physical unit, consumer combo */
struct sl_pcb {
	queue_t        *sl_rdq;		/* read queue */
	struct sl_softc *sl_softc;	/* physical unit */
	struct sl_pcb  *sl_nextpcb;	/* next consumer for this unit */
	long            sl_sap;		/* SLIP link type for this consumer */
	mblk_t		*sl_header;	/* header mblock */
	u_char          sl_flags;	/* LLI state */
	u_char		sl_totty;	/* 1 if stream goes to tty, else 0 */
};

/* sc_flags */
#define	SC_ESCAPED	0x01		/* saw a FRAME_ESCAPE */
#define SC_ERROR	0x02		/* error in input */

/* sl_flags */
#define SL_BOUND	0x01

#define FRAME_END	 	0300	/* Frame End */
#define FRAME_ESCAPE		0333	/* Frame Esc */
#define TRANS_FRAME_END	 	0334	/* transposed frame end */
#define TRANS_FRAME_ESCAPE 	0335	/* transposed frame esc */

#endif				/* slip__h */
