#ident	"@(#)keyboard.h	1.2	90/08/08"
#ifndef _SYS_KEYBOARD_H
#define _SYS_KEYBOARD_H
#ident "@(#) keyboard.h 22.1 90/01/15 "
#ident "@(#)keyboard.h	1.2 89/09/29"
#ident "@(#) keyboard.h 1.7 89/07/27 "
/*
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 *	Portions Copyright 1980-1989 Microsoft Corporation
 *   Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*
 *	Copyright (C) The Santa Cruz Operation, 1984-1989.
 *	Copyright (C) Microsoft Corporation, 1984-1989.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation, Microsoft Corporation
 *	and AT&T, and should be treated as Confidential.
 */

/*
 *	User level include file for: 
 *	PC monitor keyboard related defines and variables.
 *
 */

#define NUM_KEYS	256	/* Max number of possible physical keys */
#define NUM_STATES	8	/* Number of key states */
#define NFKEYS		96

#define	NUM_KEYS_21	111	/* Max number of keys under 2.1.x */

#define MIOC	('k' << 8)

/* GET/SET FKEY in machdep.h are (MIOC|0) and (MIOC|1) */
/* GIO/PIO _SCRNMAP in console.h are (MIOC|2) and (MIOC|3) */

#define GIO_STRMAP_21	(MIOC|4)	/* Get 2.1 function key string table */
#define PIO_STRMAP_21	(MIOC|5)	/* Put 2.1 function key string table */

#define GIO_KEYMAP	(MIOC|6)	/* Get keyboard map table */
#define PIO_KEYMAP	(MIOC|7)	/* Put keyboard map table */

#define GIO_KEYMAP_21	(MIOC|8)	/* Get 2.1 keyboard map table */
#define PIO_KEYMAP_21	(MIOC|9)	/* Put 2.1 keyboard map table */

#define SETLOCKLOCK	(MIOC|10)	/* global cap/num lock on/off */

#define GIO_STRMAP	(MIOC|11)	/* Get function key string table */
#define PIO_STRMAP	(MIOC|12)	/* Put function key string table */

#define	KBIO_SETMODE	(MIOC|13)	/* Put AT keyboard into XT | AT mode */
#define	KBIO_GETMODE	(MIOC|14)	/* Get the AT/XT keyboard mode */

/* keyboard mode -- set by KBIO_MODE */
#define	KBM_XT	0	/* XT keyboard mode */
#define	KBM_AT	1	/* AT keyboard mode */

#ifdef M_I386
#pragma pack(2)
#endif

struct keymap {
	short  n_keys ;
	struct key_t {
		unsigned char map[NUM_STATES];
		unsigned char spcl;
		unsigned char flgs;
	} key[NUM_KEYS+1];
};
typedef struct keymap keymap_t;

#ifdef M_I386
#pragma pack()
#endif

/* key map table flags */
#define	KMF_CLOCK	0x01		/* affected by caps lock */
#define	KMF_NLOCK	0x02		/* affected by num lock */

#define	L_O	0
#define	L_C	1
#define	L_N	2
#define	L_B	3

#define NORMAL		0
#define SHIFT		1
#define CTRL		2
#define	SHFCTL		3
#define ALT		4
#define	ALTSHF		5
#define	ALTCTL		6
#define	ALTSHFCTL	7

/***************** Special range macros and keys *****************/

#define	IS_SPECIAL(km, c, i)	( (km).key[(c)].spcl & (0x80>>(i)) )

#define	K_NOP	0	/* Keys with no function */
#define K_LSH	2	/* Left shift */
#define K_RSH	3	/* Right shift */
#define K_CLK	4	/* Caps lock */
#define K_NLK	5	/* Num lock */
#define K_SLK	6	/* Scroll lock */
#define	K_BTAB	8	/* Back tab */
#define K_ALT	7	/* Alt */
#define	K_LALT	K_ALT	/* Left Alt */
#define	K_RALT	124	/* Right Alt */
#define K_CTL	9	/* Control */
#define	K_LCTL	K_CTL	/* Left Ctrl */
#define	K_RCTL	123	/* Right Ctrl */
#define K_NXSC	10	/* Switch to next screen */
#define K_SCRF	11	/* Switch to first screen */
#define	K_SCRL	26	/* Switch to last screen */
#define	K_FUNF	27	/* First function key */
#define	K_FUNL	122	/* Last function key */

/***************** Expanded function and screen key macros ***************/

#define	NSTRKEYS	(K_FUNL-K_FUNF+1)
#define STRTABLN_21	256	/* max length of the sum of all strings */
#define STRTABLN	512	/* max length of the sum of all strings */

#define	FKEYSTART	0	/* The F1 key is string key #0 */

#define	IS_SCRKEY(x)	( ((x) >= K_SCRF) && ((x) <= K_SCRL) )
#define	IS_FUNKEY(x)	( ((x) >= K_FUNF) && ((x) <= K_FUNL) )

typedef unsigned char strmap_t[STRTABLN];

/***************** Special system scan codes ****************************/

#define	KBD_OVERRUN	-1	/* keyboard imput data queue has been overrun */
#define	KBD_BREAK	0x4000	/* key make/break flag (make=0/break=1) */
#define	KBD_SCMASK	0xff	/* scan code mask */

#endif	/* _SYS_KEYBOARD_H */
