#ident	"@(#)ioctl.h	1.8	91/03/13"
#ifndef _SYS_IOCTL_H
#define _SYS_IOCTL_H
#ident "@(#) ioctl.h 22.1 90/01/15 "
#ident "@(#)ioctl.h	1.7 90/02/08"
#ident "@(#) ioctl.h 1.6 89/07/27 "
/*
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 *	Portions Copyright 1980-1989 Microsoft Corporation
 *   Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *       Portions Copyright 1989-1991 Altos Computer Systems
 *		      All Rights Reserved
 */
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	Copyright (c) 1987, 1988 Microsoft Corporation	*/
/*	  All Rights Reserved	*/

/*	This Module contains Proprietary Information of Microsoft  */
/*	Corporation and should be treated as Confidential.	   */

/* #ident	"@)#(head.sys:ioctl.h	1.3.1.2" */

/*
 *	Ioctl commands
 */
#define	IOCTYPE	0xff00

#define	LIOC	('l'<<8)
#define	LIOCGETP	(LIOC|1)
#define	LIOCSETP	(LIOC|2)
#define	LIOCGETS	(LIOC|5)
#define	LIOCSETS	(LIOC|6)

#define	DIOC	('d'<<8)
#define	DIOCGETC	(DIOC|1)
#define	DIOCGETB	(DIOC|2)
#define	DIOCSETE	(DIOC|3)

/*
**	Union for use by all device handler ioctl routines.
*/
union ioctl_arg {
	struct termio	*stparg;	/* ptr to termio struct */
	struct Generic	*sparg;		/* ptr to generic struct */
	char		*cparg;		/* ptr to character */
	char		carg;		/* character */
	int		*iparg;		/* ptr to integer */
	int		iarg;		/* integer */
	long            *lparg;         /* ptr to long */
	long            larg;           /* long */
};

/*
 * Commands needed for XENIX ioctl() compatibility
 */

#define	TIOC	('T'<<8)
#define	TCFLSH	(TIOC|7)


/*
 * Altos-specific definitions for MODEM settings, and hardware flow control.
 * Used by the SIO/2 and MDC/2 device drivers.
 */

#define tIOC ('t'<<8)

#define	SETMODEM	(tIOC|23)	/* Set modem control */
#define	SETFLOW		(tIOC|24)	/* Set hardware flow control */
#define	GETFLOW		(tIOC|25)	/* Get hardware flow control */
#define	GETMODEM	(tIOC|26)	/* Get modem control */
#define GETPORTTYPE	(tIOC|31)	/* Get serial/parallel port type */
#define SETSERIAL	(tIOC|32)	/* Set to serial port type */
#define SETPARALLEL	(tIOC|33)	/* Set to IN/OUT/INOUT parallel type */
#define SETAUTOFEED	(tIOC|34)	/* Set auto-feed flag */
#define	GENBRK		(tIOC|35)	/* Generate a break */
#define PRINIT		(tIOC|36)	/* Pulse INIT line */
#define GETXID		(tIOC|37)	/* Get XID from secondary */
#define GETKEEPALIVE	(tIOC|38)	/* Get state of 'keepalive' bit */
#define SETKEEPALIVE	(tIOC|39)	/* Set state of 'keepalive' bit */
#define GETSTAT		(tIOC|40)	/* Get latest device status */
#define GETXONCHAR	(tIOC|41)	/* Get X-ON char */
#define GETXOFFCHAR	(tIOC|42)	/* Get X-OFF char */
#define SETXONCHAR	(tIOC|43)	/* Set X-ON char */
#define SETXOFFCHAR	(tIOC|44)	/* Set X-OFF char */
#define SETPAPER_OUT	(tIOC|45)	/* Set 'paper out' flag */
#define SETPLLERR	(tIOC|46)	/* Set 'parallel error' flag */
#define SETINPUTPREF	(tIOC|47)	/* Set 'input-preferred' flag */
#define GETINPUTPREF	(tIOC|48)	/* Get 'input-preferred' flag */

#define	MIOBGET		(('a'<<8)|0)	/* Get the output bits */
#define	MIOBSET		(('a'<<8)|1)	/* Set the output bits */

#define	MIOBIGET	(('b'<<8)|1)	/* Get the input bits */

/*
 * Modem control/status bits
 */
#define RTS		0x08
#define DTR		0x02

#define CTS		0x40
#define DSR		0x80

/*
 * Definitions for [SG]ETMODEM ioctls
 */
#define MDM_USER	0		/* User sets HUPCL and CLOCAL */
#define MDM_ON		1		/* Forces HUPCL, ~CLOCAL on each open */
#define MDM_OFF		2		/* Forces ~HUPCL, CLOCAL on each open */

/*
 * Definitions for [SG]ETFLOW ioctls
 */
#define TXHARD		0x01
#define RXHARD		0x10
#define RTSHARD		0x02
#define CTSHARD		0x04

/*
 * MDC/2 channel types (GETPORTTYPE/SETPARALLEL)
 */
#define	SERIAL		0		/* Configured for SERIAL */
#define	PLLIN		1		/* Configured for PARALLEL IN */
#define	PLLOUT		2		/* Configured for PARALLEL OUT */
#define PLLINOUT	3		/* Configured for PARALLEL IN & OUT */

/*
 * GET/SET ioctl arguments.
 */ 
#define OFF		0
#define	ON		1

/*
 * Get number of ports.
 * Not used with current products.
 */
#define IOCHOWMANY	(('h'<<8)|0)

struct io_howmany {
	unsigned char i_first;
	unsigned char i_last;
	unsigned char i_type;
};

/*
 * Virtual disk ioctl's
 */
#define VDIOC	('V'<<8)
#define VDGET	(VDIOC|1)	/* get virtual disk info */
#define VDSET	(VDIOC|2)	/* set virtual disk info */
#define VDMAX	(VDIOC|3)	/* max. number of virtual disk devices */
#define VDDELBAD (VDIOC|4)	/* Delete entry from bad-block list */
#define VDGETBBL (VDIOC|5)	/* get kernel's bad-block list */
#define VDDMPID	(VDIOC|6)	/* tell kernel the proc id of vddaemon */
#define VDFIXED	(VDIOC|7)	/* reset isbad flag for specified phys dev */
#define VDSETBBL (VDIOC|8)	/* set kernel's bad-block list */
#define VDSIMERR (VDIOC|9)	/* enable error simulation ioctl (debug) */
#define VDGETMAXPHYS (VDIOC|10)	/* max number of physical components
					across all virtual disks */
#define VDOVERRIDE (VDIOC|11)	/* Ignore bad block information */
#define VDNOOVERRIDE (VDIOC|12)	/* Don't ignore bad block information */

#ifdef	VPIX
#  define AIOC		  ('A'<<8)
#  define AIOCINTTYPE     (AIOC|60)        /* set pseudorupt personality */
#  define AIOCDOSMODE     (AIOC|61)        /* set DOSMODE */
#  define AIOCNONDOSMODE  (AIOC|62)        /* reset DOSMODE */
#  define AIOCSERIALOUT   (AIOC|63)        /* serial device data write */
#  define AIOCSERIALIN    (AIOC|64)        /* serial device data read */
#  define AIOCSETSS       (AIOC|65)        /* set start/stop chars */
#  define AIOCINFO        (AIOC|66)        /* tell user what device we are */
#endif	/* VPIX */
#endif	/* _SYS_IOCTL_H */
