/*
 *	@(#) i8259.h 2.1 88/05/18 
 *
 *	Copyright (C) The Santa Cruz Operation, 1984, 1985, 1986, 1987.
 *	Copyright (C) Microsoft Corporation, 1984, 1985, 1986, 1987.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation, Microsoft Corporation
 *	and AT&T, and should be treated as Confidential.
 */

/*
 * THIS FILE CONTAINS CODE WHICH IS SPECIFIC TO THE
 * GENERIC 286 COMPUTER AND MAY REQUIRE MODIFICATION
 * WHEN ADAPTING XENIX TO NEW HARDWARE.
 */


/*
 * i8259.h
 *      definitions for interrupt control system on the 286.
 *
 */

/*
 * PIC  Initialization Constants 
 * 	constants for ICW1 are defined in oem.c
 */
#define	PIC_VECT_BASE	0x40		/* start vectors at 64 */
#define	PIC_SPF_MODE	0x10		/* special fully nested mode */
#define	PIC_SLAVE_BUF	0x08		/* buffered mode, slave */
#define	PIC_MASTER_BUF	0x0C		/* buffered mode, master */
#define	PIC_AUTO_EOI	0x02		/* set to auto eoi */
#define	PIC_86_MODE	0x01		/* MCS 86 mode */
#define PIC_SINGLE	0x02		/* icw1 ( no cascade mode ) */

/*
 * PIC commands
 */
#define	PIC_EOI		0x20		/* Non-specific EOI command */
#define PIC_SEOI	0x60		/* Specific EOI command */
#define	PIC_SET_PRI	0xC0		/* Set priority command */
#define	PIC_ISR_READ	0x0B		/* Select ISR for input */
#define	PIC_IRR_READ	0x0A		/* Select IRR for input */

/*
 * Generate masks to turn on/off a given level.
 * PIC_MASK: bit(i) = 1 ==> masked; 0 ==> enabled.
 */

#define	PIC_MON(i)	(0xFF & ~(1<<(i)))
#define	PIC_MOFF(i)	(1<<(i))

/*
 * define master & slave levels
 * encoding for master levels
 *	lev = master#
 * encoding for slave levels
 *	lev = (master# + 1) * 8 + slave#
 *
 * or,
 *	   7   6   5   4   3   2   1   0
 *	-----------------------------------
 *	|      pic index     | active lev |
 *	-----------------------------------
 */
#define PIC_ML0	0
#define PIC_ML1	1
#define PIC_ML2	2
#define PIC_ML3	3
#define PIC_ML4	4
#define PIC_ML5	5
#define PIC_ML6	6
#define PIC_ML7	7
#define PIC_MCL0	8
#define PIC_MCL1	16
#define PIC_MCL2	24
#define PIC_MCL3	32
#define PIC_MCL4	40
#define PIC_MCL5	48
#define PIC_MCL6	56
#define PIC_MCL7	64
#define PIC_SL0	0
#define PIC_SL1	1
#define PIC_SL2	2
#define PIC_SL3	3
#define PIC_SL4	4
#define PIC_SL5	5
#define PIC_SL6	6
#define PIC_SL7	7
