#ident	"@(#)xfsdsa.h	1.2	90/08/08"
#ifndef _SYS_FS_XFSDSA_H
#define _SYS_FS_XFSDSA_H
#ident "@(#) xfsdsa.h 22.1 90/01/15 "
#ident "@(#)xfsdsa.h	1.2 89/09/29"
#ident "@(#) xfsdsa.h 1.4 89/07/27 "
/*
 *	Copyright (C) The Santa Cruz Operation, 1984-1989.
 *	Copyright (C) Microsoft Corporation, 1984, 1985, 1986, 1987.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation, Microsoft Corporation
 *	and AT&T, and should be treated as Confidential.
 */
/***
**
**  @)#( h/xfs/dsa.h	 Copyright Microsoft Corporation 1984
**			 All Rights Reserved
**
**  AUTHORS:
**     Bob Rinne
**     Ken Masden
**
**  Intel Corporation
**  ISO-S
**  2402 W. Beardsley Road
**  Phoenix, Arizona  85027
**
*/
/* -------------------------------------------------- */

/*
*  Macros used for creating and determining a remote inode for
*  the Network file consumer.
*/

extern int	xnet_fstyp;


#define	NI_NOTREMOTE	(-1)

#define REMOTE(IP)	((xnet_fstyp != -1) && \
				(IP) && ((IP)->i_fstyp == xnet_fstyp))
#define NOTREM(IP)	((xnet_fstyp == -1) || ( ! (IP)) || \
				( ((IP)->i_fstyp != xnet_fstyp)) )

#define XNET_IP(IP)	REMOTE(IP)
#define TYPEREM(IP)	(IP)->i_fstyp = xnet_fstyp

#define NFC_NSYS  1
#define NAMSZ	16

/* 
*  Network file consumer routines
*/

extern int nfc_sup ();
extern int nfc_init ();

extern struct inode *nfc_owner ();

extern int nfc_access ();
extern int nfc_read ();
extern int nfc_write ();
extern int nfc_exec ();
extern int nfc_eend ();
extern int nfc_close ();
extern int nfc_copen ();
extern int nfc_ioctl ();
extern int nfc_rdchk ();
extern int nfc_chdirec ();
extern int nfc_chsize ();
extern int nfc_exit ();
extern int nfc_fork ();
extern int nfc_link ();
extern int nfc_locking ();
extern int nfc_mknod ();
extern int nfc_mount ();
extern int nfc_sumount ();
extern int nfc_setattr ();
extern int nfc_stat ();
extern int nfc_sync ();
extern int nfc_utime ();
extern int nfc_unlink ();
extern int nfc_seek ();
/*
*  Definitions for level of network name translation
*/
extern	int nfs1;   /* dsa */

#define U_WRITE	0
#define U_READ	1

#endif /* _SYS_FS_XFSDSA_H */
