#ident	"@(#)dosinode.h	1.2	90/08/08"
#ifndef _SYS_FS_DOSINODE_H
#define _SYS_FS_DOSINODE_H
#ident	"@(#) dosinode.h 22.1 90/01/15 "
#ident "@(#)dosinode.h	1.2 89/09/29"
#ident	"@(#) dosinode.h 1.2 89/07/27 "

/*	Copyright (C) The Santa Cruz Operation, 1988, 1989.	*/

/*	This Module contains Proprietary Information of		*/
/*	The Santa Cruz Operation and should be treated		*/
/*	as Confidential.					*/

						/* BEGIN SCO_FS */

/*
 * file system dependent inode structure for MSDOS filesystems
 */

struct dosinode
{
	ushort			di_flags;	/* flags		*/
	ushort			di_attr;	/* file attributes	*/
	time_t			di_mtime;	/* modification time	*/
	ushort			di_start;	/* start cluster	*/
	struct	dosinode	*di_next;	/* free list ptr	*/
	int			*di_map;	/* pointer to blk # map	*/
	int			di_lastfat;	/* last fat entry used	*/
};

/*
 * di_flags
 */
#define	DOSI_FREE		0x00
#define	DOSI_INUSE		0x01

/*
 * file modes
 */
#define	DOS_R		(IREAD  | (IREAD>>3)  | (IREAD>>6) )
#define	DOS_W		(IWRITE | (IWRITE>>3) | (IWRITE>>6))
#define	DOS_X		(IEXEC  | (IEXEC>>3)  | (IEXEC>>6) )

#define	DOS_R_X		(DOS_R | DOS_X)
#define	DOS_RWX		(DOS_R | DOS_W | DOS_X)

extern struct dosinode	dosinode[];
extern int		dosninode;
						/* END SCO_FS */

#endif /* _SYS_FS_DOSINODE_H */
