#ident	"@(#)dosfilsys.h	1.2	90/08/08"
#ifndef _SYS_FS_DOSFILSYS_H
#define _SYS_FS_DOSFILSYS_H
#ident	"@(#) dosfilsys.h 22.1 90/01/15 "
#ident "@(#)dosfilsys.h	1.2 89/09/29"
#ident	"@(#) dosfilsys.h 1.3 89/07/27 "

/*	Copyright (C) The Santa Cruz Operation, 1988, 1989.	*/

/*	This Module contains Proprietary Information of		*/
/*	The Santa Cruz Operation and should be treated		*/
/*	as Confidential.					*/


						/* BEGIN SCO_FS */
/*
 * dos boot sector - first 512 bytes of MSDOS 2.x / 3.x partition
 */

struct dosbootsector
{
	unchar	jump[3];		/* jump round boot code		*/
	unchar	oem[8];			/* OEM identification		*/
	unchar	BytesPerSector[2];	/* # of bytes per sector	*/
	unchar	SectorsPerCluster[1];	/* # of sectors per cluster	*/
	unchar	ReservedSectors[2];	/* # of reserved sectors	*/
	unchar	NumberOfFATs[1];	/* # of FAT's			*/
	unchar	RootEntries[2];		/* # of entries in root dir	*/
	unchar	TotalSectors[2];	/* # of sectors in logical image*/
	unchar	MediaDescriptor[1];	/* media descriptor		*/
	unchar	SectorsPerFAT[2];	/* # of sectors in FAT		*/
	unchar	SectorsPerTrack[2];	/* # of sectors per track	*/
	unchar	Heads[2];		/* # of heads			*/
	unchar	HiddenSectors[4];	/* # of hidden sectors		*/
	unchar	BigTotalSectors[4];
	unchar	pad[376];
};

#define	MAXFAT	(8*sizeof(short))	/* MAX of 8 1K blocks for FAT */
/*
 * dosfilsys - internal data structure - the dos "superblock"
 */

struct dosfilsys
{
	unsigned	s_flags;
	unsigned	s_fat0;		/* start sector of FAT		*/
	unsigned	s_fat1;		/* start sector of copy of FAT	*/
	unsigned	s_fatsz;	/* size of FAT (sectors)	*/
	unsigned	s_root;		/* start sector of root dir	*/
	unsigned	s_rootsz;	/* size of root dir (sectors)	*/
	unsigned	s_data;		/* start sector of data		*/
	unsigned	s_clustsz;	/* size of cluster (sectors)	*/
	unsigned	s_sectors;	/* total # of sectors		*/
	unsigned	s_clustmax;	/* maximum addressable cluster	*/
	unsigned	s_csize;	/* cluster size (bytes)		*/
	unchar		s_media;	/* media type			*/
	unchar		s_type;		/* filesystem type		*/
	struct buf	*s_bufptr;	/* either NULL or ptr to buffer	*/
	ushort		*s_fatptr;	/* pointer to in core FAT	*/
	union s_secm {
		unchar	m[MAXFAT];	/* 12 array of dirty fat sectors */
#define	mod16	lf[0]			/* 16/32 this block been modified?*/
#define	last16	lf[1]			/* 16/32 last fat used		*/
		int	lf[2];
	} s_secm;
	unsigned char	s_tmpconv[3];	/* temporary buffer for FAT conv*/
	int		s_cnt;		/* counter for fat conversion	*/
	pid_t		s_pid;		/* PID for locking.		*/
	ushort		s_mode;		/* mode for mountpoint		*/
};

/*
 * values for s_flags
 */
#define	DOS_SFREE	0x00
#define	DOS_SINUSE	0x01
#define	DOS_FATLOCK	0x02		/* Lock the FAT when searching */

/*
 * values for s_type
 */
#define	DOS_FAT12	1		/* 12 bit FAT			*/
#define	DOS_FAT16	2		/* 16 bit FAT			*/
#define	DOS_FAT32	3		/* 32 bit FAT			*/

#define getfs(mp)	((struct dosfilsys *)mp->m_bufp)

extern struct	dosfilsys dosfilsys[];
extern int	dosnmount;
						/* END SCO_FS */

#endif /* _SYS_FS_DOSFILSYS_H */
