#ident	"@(#)dosdir.h	1.2	90/08/08"
#ifndef _SYS_FS_DOSDIR_H
#define _SYS_FS_DOSDIR_H
#ident	"@(#) dosdir.h 22.1 90/01/15 "
#ident "@(#)dosdir.h	1.2 89/09/29"
#ident	"@(#) dosdir.h 1.2 89/07/27 "

/*	Copyright (C) The Santa Cruz Operation, 1988, 1989.	*/

/*	This Module contains Proprietary Information of		*/
/*	The Santa Cruz Operation and should be treated		*/
/*	as Confidential.					*/

						/* BEGIN SCO_FS */

/*
 * MSDOS 2.x / 3.x directory entry
 */
#define	DOS_NAMSIZ	8
#define	DOS_EXTSIZ	3

struct dosdir
{
	unchar		d_name[DOS_NAMSIZ];	/* filename		*/
	unchar		d_extn[DOS_EXTSIZ];	/* extension		*/
	unchar		d_attr[1];		/* attributes		*/
	unchar		d_rsvd[10];		/* reserved		*/
	unchar		d_time[2];		/* time			*/
	unchar		d_date[2];		/* date			*/
	unchar		d_start[2];		/* first cluster #	*/
	unchar		d_size[4];		/* file size		*/
};

/*
 * special values for d_name[0]
 */
#define	DOS_UNUSED	0x00		/* entry has never been used	*/
#define	DOS_DELETED	0xe5		/* deleted entry		*/
#define	DOS_WAS_E5	0x05		/* name[0] is really 0xe5!!	*/

#define	DOT		'.'
#define	SP		' '

/*
 * flags in d_attr
 */
#define	DOS_READONLY	0x01		/* file is readonly		*/
#define	DOS_HIDDEN	0x02		/* file is a "hidden" file	*/
#define	DOS_SYSTEM	0x04		/* file is a "system" file	*/
#define	DOS_VOLID	0x08		/* entry contains volume-id	*/
#define	DOS_SUBDIR	0x10		/* file is a sub-directory	*/
#define	DOS_ARCHIVE	0x20		/* file has been modified	*/
						/* END SCO_FS */

#endif /* _SYS_FS_DOSDIR_H */
