#ident	"@(#)event.h	1.2	90/08/08"
#ifndef _SYS_EVENT_H
#define _SYS_EVENT_H
#ident  "@(#) event.h 22.1 90/01/15 "
#ident "@(#)event.h	1.2 89/09/29"
#ident  "@(#) event.h 1.9 89/07/27 "
/*
 *	Copyright (C) The Santa Cruz Operation, 1988, 1989.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and should be treated 
 *	as Confidential.
 */

/*
 * THIS FILE CONTAINS CODE WHICH IS DESIGNED TO BE
 * PORTABLE BETWEEN DIFFERENT MACHINE ARCHITECTURES
 * AND CONFIGURATIONS. IT SHOULD NOT REQUIRE ANY 
 * MODIFICATIONS WHEN ADAPTING XENIX TO NEW HARDWARE.  
 */

#if defined(i386) || defined (M_I86)
#define QPAGE 4096
#endif

/* This number chosen to make an event 16 bytes long */
#define		EV_STR_BUFSIZE	8

typedef struct {
	long	timestamp;
	short	tag;
	union {
		char	buttons;
		char	bufcnt;
	} u1;
	union {
		unsigned char buf[EV_STR_BUFSIZE];
		union {
			struct {
				unsigned long	x,y;
			} abs;
			struct {
				long	dx,dy;
			} rel;
		} loc;
	} un;
} EVENT;

/* Values for event tag */
#define	T_OTHER		0x0001
#define	T_BUTTON	0x0002
#define	T_STRING	0x0004
#define	T_ABS_LOCATOR	0x0008
#define	T_REL_LOCATOR	0x0010
#define	T_LOCATOR	(T_ABS_LOCATOR | T_REL_LOCATOR)

/* Shorthand notations */
#define	EV_TIME(x)	((x).timestamp)
#define	EV_TAG(x)	((x).tag)		/* device making event*/
#define	EV_BUFCNT(x)	((x).u1.bufcnt)		/* num bytes in buffr */
#define	EV_BUTTONS(x)	((x).u1.buttons)
#define	EV_BUF(x)	((x).un.buf)		/* pointer to buffer  */
#define	EV_DX(v)	((v).un.loc.rel.dx)
#define	EV_DY(v)	((v).un.loc.rel.dy)
#define	EV_X(v)		((v).un.loc.abs.x)
#define	EV_Y(v)		((v).un.loc.abs.y)

/* Bit definitions within the character reserved for button state */
#define	BUTTON1		0x01
#define	BUTTON2		0x02
#define	BUTTON3		0x04
#define	BUTTON4		0x08
#define	RT_BUTTON	BUTTON1
#define	MD_BUTTON	BUTTON2
#define	LT_BUTTON	BUTTON3

/* This number makes a queue one page (4K bytes) long */
#define		QSIZE		((QPAGE - 3 * sizeof(long))/sizeof(EVENT))

typedef struct {
	long	overrun;
	long	head;
	long	tail;
	EVENT	queue[QSIZE];
} QUEUE;

/* 
 * Locator events may be ratioed as they enter the queue.
 * The user supplies a multiplication factor, then the driver
 * right shifts by a constant amount.
 */

#define	LOC_RSHIFT	13

#define	R_ONEHALF	0x1000
#define	R_TIMES1	0x2000
#define	R_TIMES2	0x4000
#define	R_TIMES4	0x8000

/* The type of an event mask */
typedef	unsigned short	emask_t;

/* The type of a device mask */
typedef unsigned short	dmask_t;

/* The mouse line discipline */
#define	MLD	2

#ifdef INKERNEL

#define	EVLDSILOSZ	5

struct evldsilo {
	short	count;
	unsigned char buf[EVLDSILOSZ];
	short	eq_handle;
	short	ratio;
	void	(*addevent)();
	unsigned char oldbuttons;
	long	oldx, oldy;
};

struct evldchan {
	unsigned short	open;
	void	(*eventize)();		/* routine to make events */
	struct evldsilo	silo;
};

struct evdev {
	long	dev_id;		/* identifies HW gin device 0=invalid*/
	long	term_id;	/* identifies controlling tty */
	short	channel;	/* channel to which events are going */
};

/*
 * values for flags
 */
#define READ_COLLISION		TRCOLL
#define EXCEPT_COLLISION	TECOLL

struct ev_selstr {
	struct proc *read;
	/* Writing to the event driver is not defined or supported. */
	struct proc *except;
	char	flags;
};

struct evchan {
	long	term_id;	/* & of tp of controlling tty if any */
	unchar status;		/* UNUSED, OPEN, ACTIVE, SUSPENDED */
	QUEUE	*qp;		/* Kernel's pointer to the queue */
	caddr_t	uqp;		/* User's pointer to the queue */
#ifdef M_S_UNIX
	preg_t *physaddr;	/* ptr to region in Unix */
#else
	paddr_t	physaddr;	/* physical address in Xenix */
#endif
	emask_t	emask;
	struct ev_selstr selstr;
};

/* #ifdef MERGE386 */
struct mrg_evchan {
	struct proc *chan_owner;
	unsigned long mrg_chanflags;
	int (*mrg_funcp)();
	unsigned char *mrg_datap;
};
/* #endif  MERGE386 */

#endif
/*
 * event driver ioctls
 */
#define	EQIOC		('Q' << 8)
#define	EQIO_GETQP	(EQIOC | 1)
#define	EQIO_SETEMASK	(EQIOC | 2)
#define	EQIO_GETEMASK	(EQIOC | 3)
#define	EQIO_SUSPEND	(EQIOC | 4)
#define	EQIO_RESUME	(EQIOC | 5)
#define	EQIO_BLOCK	(EQIOC | 6)

/* 
 * line discipline specific ioctls to the mouse line discipline 
 */
#define	EVLD_IOC	(LDIOC)
#define	LDEV_SETTYPE	(EVLD_IOC | 13)		/* set mouse type	*/
#define	LDEV_GETEV	(EVLD_IOC | 14)		/* get an event		*/
#define	LDEV_ATTACHQ	(EVLD_IOC | 15)		/* activate mouse	*/
#define	LDEV_SETRATIO	(EVLD_IOC | 16)		/* set a device ratio	*/

#endif	/* _SYS_EVENT_H */
