/*
 *	@(#) ecc.h 1.1 88/05/18 
 *
 *	Copyright (C) The Santa Cruz Operation, 1987, 1988.
 *	Copyright (C) Microsoft Corporation, 1987.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation, Microsoft Corporation
 *	and AT&T, and should be treated as Confidential.
 */

#define MAXSINGLE 10
#define MAXTMPBAD 10

#define MAXBADPGS 40 

#define EDAC      ('E'<<8)
#define EDACGET   (EDAC|1)
#define EDACRESET (EDAC|2)

/*
 * Structure returned by the edac driver's EDACGET ioctl(). 
 * Also cleared by the EDACRESET ioctl().
 */
struct softerr {
	long s_nsofterrs;
	struct { 
		long s_pfn;
		long s_errcount;
	} s[MAXSINGLE];
};

/*
 * The structure that the driver reads and writes.  Writing
 * out a new bad page list is a privileged (superuser only) operation.
 * The driver computes the checksum. 
 */

struct badmem {
	unsigned long bp_chksum;
	unsigned long bp_maxbad;
	unsigned long bp_badpage[MAXBADPGS];
};
