#ident	"@(#)dio.h	1.2	90/08/08"
#ifndef _SYS_DIO_H
#define _SYS_DIO_H
#ident "@(#) dio.h 22.1 90/01/15 "
#ident "@(#)dio.h	1.2 89/09/29"
#ident "@(#) dio.h 1.7 89/07/27 "
/*
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 *	Portions Copyright 1980-1989 Microsoft Corporation
 *   Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*
 *	Copyright (C) The Santa Cruz Operation, 1984-1989.
 *	Copyright (C) Microsoft Corporation, 1984-1989.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation, Microsoft Corporation
 *	and AT&T, and should be treated as Confidential.
 */

/*
 * header file for sco standard bad track scheme
 */

/*
 * minor device number macros
 */
#define dmask(x)           ((1 << (x)) - 1)
#define	dphys(ptr,x)	   (((unsigned)(x) >> ( 8 - (ptr)->physbits)) & \
				  dmask((ptr)->physbits))
#define	dlog(ptr,x)	   (((unsigned)(x) >> (ptr)->partbits) & \
                                  dmask((ptr)->logbits))
#define	dpart(ptr,x)	    ((unsigned)(x) & \
                                  dmask((ptr)->partbits)) 
#define	dmkdev(ptr,d,l,p)  (((unsigned)(d) << (8 - (ptr)->physbits)) | \
                            ((unsigned)(l) << (ptr)->partbits) | \
                            ((unsigned)(p)))

/*
 * ioctl interface
 */
#define	DIO		('D'<<8)
#define	DIOGETP		(DIO|1)		/* get disk parameters */
#define	DIOSETP		(DIO|2)		/* set disk parameters */
#define	DIORPART	(DIO|3)		/* read partition table */
#define	DIOWPART	(DIO|4)		/* write partition table */
#define	DIORBTRK	(DIO|5)		/* read bad track table - fails in 2.2*/
#define	DIOWBTRK	(DIO|6)		/* write bad track table -fails in 2.2*/
#define DIOBITP         (DIO|7)         /* get bit parameters */
#define DIORVDT         (DIO|8)         /* read virt. drive table */
#define DIOWVDT         (DIO|9)         /* write virt. drive table */
#define	DIOSDISK	(DIO|10)	/* Size disk characeristics	*/
#define	DIORDISK	(DIO|11)	/* Read disk characteristics	*/
#define	DIOWDISK	(DIO|12)	/* Write disk characteristics	*/
#define	DIOSBTRK	(DIO|13)	/* Set badtracks/virt. drive */
#define	DIORBTRK22	(DIO|14)	/* read bad track table - for 2.2  */
#define	DIOWBTRK22	(DIO|15)	/* write bad track table - for 2.2 */
#define	DIODKTYPE	(DIO|16)	/* which disk type are we?	*/
#define	DIOFORCE22	(DIO|17)	/* force driver into 2.2 mode	*/

/* 
 Definitions for space used by system routines in the hard disk area.  Note that
 they are in sector(512 byte) quantities.  The size of the badtrack table is not
 defined here because it can vary - it grew from 2 to 8 with Release 2.2.
 */
	
#define	BOOTZERO	2	/* Really only 1, but 1 more is reserved */
#define	DIVVYTBL	2	/* Size of divvy table			 */
#define	BOOTONE		40	/* Maximum size of boot1 code		 */
#define	BTABMAX		8	/* Maximum size of badtrack table	 */
				/* Number of sectors at start of virtual */
				/* drive that must be good (error free)  */
#define	GDSECS		(BOOTZERO+DIVVYTBL+BOOTONE+BTABMAX)

/*
 * table sizes
 */

#define MAXPARTS   16                       /* max partitions possible*/
#define MAXALTS    1023                     /* max alternate tracks possible */
#define MAXVDRIVES 16                       /* max virtual drives possible */

#define NPARTS(ptr) (1 << ((ptr)->partbits))/* this dev's # of partitions   */
#define NVIRTS(ptr) (1 << ((ptr)->logbits ))/* this dev's # of virt. drives */
#define NPHYS(ptr)  (1 << ((ptr)->physbits))/* this dev's # of phys drives  */

/*
 * magic numbers
 */
#define	PAMAGIC	0x1234	/* magic number for partition table */
#define	BAMAGIC	0x4321	/* magic number for bad track table */
#define	VAMAGIC	0x1342	/* magic number for virtual drive table */

#if defined(M_I386) || defined(i386)
#pragma pack(2)
#endif

/*
 * table format for DIOGETP, DIOSETP
 */
struct dparam {
	unsigned short d_cylin;		/* cylinders per drive */
	unsigned short d_heads;		/* heads per drive */
	unsigned short d_sectors;	/* sectors per cylinder */
	unsigned short d_bytes;		/* bytes per sector */
	unsigned short d_reserved;      /* sectors reserved for system use */
					/* at beginning of disk */
};


/*
 * table format for DIORPART, DIOWPART
 * partitions of zero size are considered non-existant
 */
struct partable {
	unsigned short p_magic;		/* magic number validity indicator */
	struct parts {
		long p_off;		/* offset of partition */
		long p_siz;		/* size of partition */
	} p[MAXPARTS];
};

#if defined(M_I386) || defined(i386)
#pragma pack()
#endif

/*
 * table format for DIORBTRK, DIOWBTRK
 * alternate list stored in sorted order by b_trk terminated
 * by a -1 in b_trk
 */
 struct badtab {
	unsigned short b_magic;
	unsigned short b_maxbad; 
	struct badtrks {
		unsigned short b_trk;
		unsigned short b_alt;
	} b[MAXALTS];
};

#if defined(M_I386) || defined(i386)
#pragma pack(2)
#endif

/* table format for DIOBITP
 * Get makeup of minor device number, which is how many bits of the
 * number are the partition number, how many are the virtual drive,
 * and how many are the physical drive
 */
struct dbitparams {
	short partbits;
	short logbits;
	short physbits;
};

#if defined(M_I386) || defined(i386)
#pragma pack()
#endif

/* table format for DIORVDT, DIOWVDT
 * Get/set the contents of the virtual drive table
 * which lists what operating system can be found
 * in each virtual drive, and the sizes of each.
 */

#define NOTACTIVE 0x00
#define ACTIVE    0x80

#define NO_OS        0
#define DOS          1
#define DOSL         4		/* different number for "large" DOS */
#define XENIX        2
#define UNIX	     0x63
#define CCPM         0xDB
#define AVIRT	     5		/* active virtual drive (bootable) */
#define DOSVIRT	     6		/* DOS virtual drive */

struct vdtab {
	unsigned short v_magic;
	unsigned short v_nvds;
	struct vdisk {
		unsigned short v_active;
		unsigned short v_os;
		long v_off;
		long v_size;
		long v_reserved;       /* sectors reserved for system use */
	} v_vdisk[MAXVDRIVES];
};


#endif	/* _SYS_DIO_H */
