#ident	"@(#)devbuf.h	1.2	90/08/08"
#ifndef _SYS_DEVBUF_H
#define _SYS_DEVBUF_H
#ident "@(#) devbuf.h 22.1 90/01/15 "
#ident "@(#)devbuf.h	1.2 89/09/29"
#ident "@(#) devbuf.h 1.7 89/07/27 "
/*
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 *	Portions Copyright 1980-1989 Microsoft Corporation
 *   Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*
 *	Copyright (C) The Santa Cruz Operation, 1985, 1986, 1987, 1988, 1989.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and should be treated as Confidential.
 *
 */

#ifdef i386

/*	
 * 	devbuf - device buffer managment routines
 *
 *	These routines provide physically contiguous memory for tape drives
 *	and other devices that need huge amounts of memory for buffers.
 *
 */

struct devbuf {
	paddr_t		bufptr;		/* pointer to start of buffer	*/
	paddr_t		bufend;		/* pointer to end of buffer	*/
	long 		size;		/* size of buffer 		*/
	paddr_t		head;		/* put buffer data here		*/
	paddr_t		tail;		/* get buffer data here		*/
};

/*  
 * compute the amount of data in the buffer
 */
#define	db_amtdata(b)	\
	(((long)b.head - (long)b.tail) >= 0 ? \
		(long)b.head - (long)b.tail : \
		(long)b.size - ((long)b.tail - (long)b.head))

/*  
 * compute the amount of free space in the buffer
 */

#define	db_amtfree(b)	\
	(((long)b.head - (long)b.tail) >= 0 ? \
		(long)b.size - ((long)b.head - (long)b.tail) - 1 : \
		(long)b.tail - (long)b.head - 1)

/*  
 * increment the head/tail pointer
 */

#define	db_inc(b,p,x)				\
if (1) {					\
	register long i;			\
	i = b.p + x ;				\
	if (i >= b.bufend) 			\
		i = b.bufptr + i - b.bufend;	\
	b.p = i;				\
} else

#endif

#endif	/* _SYS_DEVBUF_H */
