#ident	"@(#)cimpsw.h	1.2	90/08/08"
#ifndef _SYS_CI_CIMPSW_H
#define _SYS_CI_CIMPSW_H
#ident "@(#) cimpsw.h 1.1 90/05/30 "
/*
 *      Copyright (C) Corollary, Inc., 1986, 1987, 1988, 1989, 1990.
 *      All Rights Reserved.
 *      This Module contains Proprietary Information of
 *      Corollary, Inc., and should be treated as Confidential.
 */

/*
 *	Corollary multiprocessor system switch structure definition
 */
struct mpsw {
	int	(*pres)();		/* vendor identification routine      */
	void	(*setup)();		/* vendor setup routine		      */
	void	(*postxxinit)();	/* vendor post driver init routine    */
	void	(*boot)();		/* vendor hardware boot routine       */
	void	(*postboot)();		/* vendor post ATM boot routine       */
	void	(*xxinit)();		/* vendor hardware init routine       */
	void	(*enable)();		/* vendor processor enable routine    */
	void	(*ATMup)();		/* vendor ATM processor init routine  */
	int	(*intr)();		/* vendor specific interrupt handler  */
	void	(*intrdone)();		/* vendor specific postintr handler   */
	void	(*ATMclk)();		/* vendor specific ATM clock routine  */
	void	(*reboot)();		/* routine called prior to reboot     */
	void	(*reset)();		/* routine called to reset a processor*/
	void	(*ledon)();		/* vendor LED on routine	      */
	void	(*ledoff)();		/* vendor LED off routine	      */
	void	(*setbaseintr)();	/* vendor set base interrupt routine  */
	void	(*clrbaseintr)();	/* vendor clear base interrupt routine*/
	void	(*setATMintr)();	/* vendor set ATM interrupt routine   */
	void	(*clrATMintr)();	/* vendor clear ATM interrupt routine */
	int	(*nmiclear)();		/* vendor NMI clear routine	      */
	void	(*startup)();		/* early startup routine 	      */
	int	(*lockb)();		/* lock routine			      */
	void	(*unlockb)();		/* unlock routine		      */
};
extern struct mpsw	mpsw[];
extern struct mpsw 	*mpswp;
#endif /* _SYS_CI_CIMPSW_H */
