#ifndef _SYS_BUF_H
#define _SYS_BUF_H
#ident "@(#)buf.h	1.8 91/07/12"
#ident "@(#) buf.h 22.6 90/03/19 "
/*
 *	Portions Copyright 1983-1990 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 *
 *      Portions Copyright (C) Corollary, Inc., 1986, 1987, 1988, 1989.
 *      All Rights Reserved.
 *      This Module contains Proprietary Information of
 *      Corollary, Inc., and should be treated as Confidential.
 */

/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	Copyright (c) 1987, 1988 Microsoft Corporation	*/
/*	  All Rights Reserved	*/

/*	This Module contains Proprietary Information of Microsoft  */
/*	Corporation and should be treated as Confidential.	   */

/*	
 *	Portions Copyright (C) Acer-Counterpoint, 1988.
 */

#include <sys/ci/cilock.h>

/*
 *	Each buffer in the pool is usually doubly linked into 2 lists:
 *	the device with which it is currently associated (always)
 *	and also on a list of blocks available for allocation
 *	for other use (usually).
 *	The latter list is kept in last-used order, and the two
 *	lists are doubly linked to make it easy to remove
 *	a buffer from one list when it was found by
 *	looking through the other.
 *	A buffer is on the available list, and is liable
 *	to be reassigned to another disk block, if and only
 *	if it is not marked BUSY.  When a buffer is busy, the
 *	available-list pointers can be used for other purposes.
 *	Most drivers use the forward ptr as a link in their I/O active queue.
 *	A buffer header contains all the information required to perform I/O.
 *	Most of the routines which manipulate these things are in bio.c.
 *
 *      WARNING:  do not change size of the buf structure (sys/buf.h) without 
 *	making a corresponding size change in the rbuf structure (sys/rbuf.h), 
 *  	and vice versa).  The two structures define the two possible formats 
 *	of the buffer header (the format used depends on whether the buffer 
 *	contains local data or RFS data).  
 *
 *      This overlay of the two structures is an interim solution
 *	that is expected to change in a future release.  Users
 *	should be aware that the rbuf structure will probably go
 *	away at that time.
 */

typedef struct	buf
{
	int	b_flags;		/* see defines below */
	struct	buf *b_forw;		/* headed by d_tab of conf.c */
	struct	buf *b_back;		/*  "  */
	struct	buf *av_forw;		/* position on free list, */
	struct	buf *av_back;		/*     if not BUSY*/
	dev_t	b_dev;			/* major+minor device name */
	struct	lockb b_cilock;		/* MPX buf struct synchronization */
	unsigned b_bcount;		/* transfer count */
	union {
	    caddr_t b_addr;		/* low order core address */
	    int	*b_words;		/* words for clearing */
	    daddr_t *b_daddr;		/* disk blocks */
#ifdef FFS
	    struct filsys *b_filsys;	/* superblocks */
#endif
	} b_un;

#define paddr(X)	(paddr_t)(X->b_un.b_addr)

	daddr_t	b_blkno;		/* block # on device */
	char	b_error;		/* returned after I/O */
	char	b_res;			/* XENIX Compatibility  */
	ushort  b_cylin;		/* XENIX Compatibility  */
	unsigned int b_resid;		/* bytes not transferred after error */
	daddr_t b_sector;               /* physical sector of disk request */
	time_t	b_start;		/* request start time */
	struct  proc  *b_proc;		/* process doing physical or swap I/O */
	unsigned long	b_reltime;      /* previous release time */

#ifdef FFS
	int	b_s2;			/* temporary space */
	int	b_s3;			/* temporary space */

#define b_umd	b_s2
#define b_fbit	b_s2
#define b_pt	b_s3
#endif

	/*
	 * Need this field to hold the B_WANTED flag in order to avoid a
	 * race in the updating of b_flags. A process with a buffer locked
	 * assumes it can do whatever it likes with b_flags, while a
	 * process wanting a busy buffer sets the B_WANTED bit without
	 * having the buffer locked. Moving it to a separate word avoids
	 * problems with simultaneous updates. (Leaving it where it is
	 * for bfreelist is probably OK.
	 */
	int	b_want;			/* Stores B_WANTED to avoid race */
} buf_t;

extern	struct	buf	*buf;		/* The buffer pool itself */

#ifdef FFS
extern	struct	buf	*mpbuf, *mpheadbuf;
extern	struct	pfree	mpfreelist, mpheadlist;
extern	int		mpfreecnt, mpheadcnt;
#endif

extern	struct	buf	bfreelist;	/* head of available list */

struct	pfree	{
	int	b_flags;
	struct	buf	*av_forw;
};
extern	struct	pfree	pfreelist;
extern	int		pfreecnt;
extern	struct	buf	*pbuf;

extern	char		*buffers;

#ifdef FFS
extern  char 		*mpbuffers;
#endif

extern  int	s52khash;		/* 2k buffer structures */
extern struct buf s52kbuf[];
extern struct buf s52kflist;
extern char	*s52kbuffers[];

extern struct	hbuf	s52khbuf[];

/*
 *	These flags are kept in b_flags.
 */
#define B_WRITE   0x0000	/* non-read pseudo-flag */
#define B_READ    0x0001	/* read when I/O occurs */
#define B_DONE    0x0002	/* transaction finished */
#define B_ERROR   0x0004	/* transaction aborted */
#define B_BUSY    0x0008	/* not on av_forw/back list */
#define B_PHYS    0x0010	/* Physical IO potentially using UNIBUS map */
#define B_MAP     0x0020	/* This block has the UNIBUS map allocated */
#define B_WANTED  0x0040	/* issue wakeup when BUSY goes off */
#define B_AGE     0x0080	/* delayed write for correct aging */
#define B_ASYNC   0x0100	/* don't wait for I/O completion */
#define B_DELWRI  0x0200	/* delayed write - wait until buffer needed */
#define B_OPEN    0x0400	/* open routine called */
#define B_STALE   0x0800
#define B_VERIFY  0x1000
#define B_FORMAT  0x2000
#define B_REMOTE  0x4000	/* buffer contains remote (RFS) data */
#define B_S52K	  0x8000	/* 2k buffer flag */
#define B_PRIVLG  0xf000        /* privileged operation (internal driver use) */

#ifdef FFS
#define B_SEQ	  0x020000	/* device is a sequential device */
#define B_CLUSTER 0x040000	/* Marks ffs buffer as used for clustering */
#define B_HASMEM  0x080000	/* Marks ffs buffer's paddr as being valid */
				/* (as opposed to scatter-gather style) */
#endif

#define B_SGLIST   0x200000	/* this buffer contains complete sglist */
#define B_NONERR   0x400000	/* write to a mirror disk was successfull */

#define NSYNCEL	20
struct syncel {
	dev_t dev;
	daddr_t blk;
};

/*
 *	Fast access to buffers in cache by hashing.
 */

#define bhash(d,b)	((struct buf *)&hbuf[((int)d+(int)(b>>1))&v.v_hmask])

struct	hbuf
{
	int	b_flags;
	struct	buf	*b_forw;
	struct	buf	*b_back;
	int	b_pad;			/* round size to 2^n */
};

extern	struct	hbuf	hbuf[];

/*
 * Pick up the device's error number and pass it to the user;
 * if there is an error but the number is 0 set a generalized code
 */
#define geterror(bp) \
{\
\
	if ((bp)->b_flags&B_ERROR)\
		if ((u.u_error = (bp)->b_error)==0)\
			u.u_error = EIO;\
}

#ifdef i386
#define	bimap(bp)	((caddr_t)(paddr(bp)))
#endif

#define bigetl(bp,cp) (*(long *)((paddr(bp))+cp))
#endif	/* _SYS_BUF_H */
