#ident "@(#)bootinfo.h	1.3 90/08/07"
#ifndef _SYS_BOOTINFO_H
#define _SYS_BOOTINFO_H
#ident "@(#) bootinfo.h 22.2 90/03/14 "
/*
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 *	Portions Copyright 1980-1989 Microsoft Corporation
 *   Portions Copyright 1983-1990 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */

/*
 *	Definition of bootinfo structure.  This is used to pass
 *	information between the bootstrap and the kernel.
 */

#define B_MAXARGS 	  14
#define BOOTINFOMAGIC	  0xFEEDBAC

#define B_AT	0x00000001	/* AT or AT386  in bootflags cf. sys/arch.h */
#define B_MC	0x00000002	/* MicroChannel in bootflags cf. sys/arch.h */

struct bootmem {
	paddr_t		base;
	ulong		extent;
	ulong		flags;
};

struct bootinfo {
	ulong	checksum;
	ulong	bootflags;		/* miscellaneous flags */
	ulong	basemem;
	ulong	extmem;

	long	memavailcnt;
	struct	bootmem	memavail[B_MAXARGS];
	ulong	bootdev;
 	ulong	pad1[2];
	
	long	memusedcnt;
	struct	bootmem	memused[B_MAXARGS];
	ulong	magic;
 	ulong	pad2[2];

	long	bootstrlen;
	char    bootstr[1];
};


/* flags for struct mem flags */

#define B_MEM_RSRVD	0x01	/* Reserved area */
#define B_MEM_KTEXT	0x02
#define	B_MEM_KDATA	0x04
#define	B_MEM_KBSS	0x08
#define B_MEM_SPECIAL	0x100	/* For shadow ram ranges & other special mem */
#define B_MEM_DOWN	0x200	/* Size this extent from the top down */
#define B_MEM_CANTDMA	0x400	/* True for all memory above 16M */
#define B_MEM_EISA	0x800	/* Location where eisa_info is stored */

#define BOOTINFO_LOC	0x800L
#define KPTBL_LOC	0x1000L  /* Reserved for kernel page table */
#define KPDIR_LOC	0x2000L  /* Reserved for kernel page dir */
#define KLINMAP_LOC	0x3000L  /* Reserved for linear map */
#define	BOOT_LOC	0x4000L  /* Start of boot */

extern struct bootinfo bootinfo;

struct mfmap {
	paddr_t		base;
	ulong		extent;
	struct pfdat 	*pf;
};

extern int mfmax;
extern struct mfmap mfmap[];

#endif	/* _SYS_BOOTINFO_H */
