#ident	"@(#)audit.h	1.3	90/08/08"
#ifndef _SYS_AUDIT_H
#define _SYS_AUDIT_H
#ident "@(#) audit.h 22.1 90/01/15 "
#ident "@(#)audit.h	1.2 89/09/29"
#ident "@(#) audit.h 1.10 89/07/27 "
#ifndef __AUDIT__
#define __AUDIT__


/*	Copyright (c) 1987 SecureWare, Inc.
 *	
 * @)#(audit.h	2.2 16:10:33 1/30/89 SecureWare
 *
 *	This is proprietary source code of SecureWare, Inc.
 *	All rights reserved.
 */


/*
 *	Audit Subsystem header file. Includes constants and structures
 *	required by the audit subsystem and the audit device.
 */

/* Audit Subsystem Macros */

#define	emask_calc(cont,disp)	((((cont) & (disp)) | aud_cont.sys_mask[0]) & \
					( ~((cont) ^ (disp))))

/* Audit Subsystem typedefs */

typedef union {
	char	*ptr;		/* string pointer */
	uint	count;		/* string lngth */
} ptr_t;

typedef struct dac {
	ushort	uid;		/* user id */
	ushort	gid;		/* group id */
	ushort	mode;		/* file mode */
} dac_t;


#ifdef M_XENIX

	/* 	
		Syscall info for Xenix compat. calls 
	*/	

#define CXENIX_SYSCALL		40	/* check this in sysent.c */
#define XENIX_SYSCALL_BASE	90	/* bias in syscall_audit  */
#endif

	/*	Audit Subsystem Constants		*/

/* General Subsystem Constant Definitions */

#define PRIAUDIT	(PZERO - 1)	/* subsystem sleep priority */

#define	AUDIT_MAXDIRS	12		/* maximum alternate directory paths */
#define	AUDIT_MAXIPS	12		/* maximum active collection files */
#define	AUDIT_KPATHSIZE	128		/* kernel pathname size maximum */
#define	AUDIT_PATHSIZE	256		/* user pathname size maximum */
#define	AUDIT_SYSNMSIZE	8		/* system name size maximum */
#define	AUDIT_DIGITS	5		/* digits in sequence, session string */
#define AUDIT_EXECARG_MAX	256	/* maximum size of audited exec args */
#define AUDIT_PATH_ALLOC	1024	/* exec path maximum size */

/* Constants for Free Space Left on Current Audit Device */

#define AUDIT_FREESP_WARN	10	/* 10%, configurable */
#define AUDIT_FREESP_TERM	3	/* 3%, configurable */

/* Constants for Audit Minor Devices */

#define	AUDIT_READ_DEV	0		/* exclusive read device */
#define	AUDIT_WRITE_DEV	1		/* subsystem record write device */

/* Arguments for Collection File Creation */

#define	AUDIT_CF_NEW	1		/* create using alternate directory */
#define	AUDIT_CF_SWITCH	2		/* create new file sequence number */

/* Subsystem Defined Directory and File Names */

#define	AUDIT_TMPDIR	"/tcb/audittmp/"	/* temporary auditing */
#define	AUDIT_LOGDIR	"/tcb/files/audit/"	/* logfile directory */
#define	AUDIT_RDEVICE	"/dev/auditr"		/* audit read device */
#define	AUDIT_WDEVICE	"/dev/auditw"		/* audit write device */
#define	AUDIT_RECOVFILE	"/tcb/files/audit/audit_recovery"  /* recovery file */
#define	AUDIT_PARMSFILE	"/tcb/files/audit/audit_parms"     /* parameter file */
#define	AUDIT_DMNINFO	"/tcb/files/audit/audit_dmninfo"  /* daemon info file */
#define	AUDIT_SELFILE	"/tcb/files/audit/audit_select"  /* default sel file */

#define AUDIT_LOG_FILENAME	"CAFLOG.xxxxx"	/* compacted file name string */
#define	AUDIT_REDUCE_PARM_DIR	"/tcb/files/auditrparms/"	/* select parameter file directory */

/* Flags for Collection File Close Routine */

#define	AUDIT_CF_KEEP	1		/* retain file */
#define	AUDIT_CF_DELETE	2		/* delete the file on close */

/* Flags for Collection File Write Routine */

#define	AUDIT_CF_WRITE		1	/* normal record write */
#define	AUDIT_CF_TIMEOUT	2	/* called by timeout function */


/* Event Types */

#define	ET_NOEVENT		0	/* not an audited event */
#define	ET_BOOT_DOWN		1	/* startup/shutdown */
#define	ET_LOGIN		2	/* login events */
#define	ET_PROCESS		3	/* process create/delete */
#define	ET_OBJECT_AVAIL		4	/* make available */
#define	ET_OBJECT_MAP		5	/* map to subject */
#define	ET_OBJECT_MOD		6	/* modify object */
#define	ET_OBJECT_UNAV		7	/* object unavailable */
#define	ET_OBJECT_CREAT		8	/* create object */
#define	ET_OBJECT_DEL		9	/* delete object */
#define	ET_DAC_CHANGE		10	/* change modes */
#define	ET_ACCESS_DENIAL	11	/* access denied */
#define	ET_SYS_ADMIN		12	/* system admin actions */
#define	ET_INSUFF_PRIV		13	/* insufficient privilege */
#define	ET_RES_DENIAL		14	/* resource denial */
#define	ET_IPC			15	/* inter-process comm */
#define	ET_PROCESS_MOD		16	/* change process control fields */
#define	ET_AUDIT		17	/* audit subsystem events */
#define	ET_DATABASE		18	/* database subsystem events */
#define	ET_SUBSYSTEM		19	/* special subsystem events */
#define ET_PRIVILEGE		20	/* use of privilege event */


/* Define the maximum number of audit event types and the maximum number
 * of mask_t array entries required to accommodate.			*/

#define	AUDIT_MAX_EVENT		20	/* largest event number */


#define	AUDIT_MASK_SIZE		1	/* only 1 long required in mask_t */

/*
 *	Record Type constants used to signify the specific record
 *	type and record content. This value is determined from the
 *	syscall_audit table on system call auditing and by the
 *	application for Self auditing. The record type is indicated
 *	in the audit record header.
 */

/* Kernel System Call Record Types */

#define	RT_NORECORD		0	/* not an audit record */
#define	RT_SYSCALL		1	/* system call, no args */
#define	RT_SYSCALL_1		2	/* system call, 1 argument */
#define	RT_SYSCALL_2		3	/* system call, 2 arguments */
#define	RT_SECURITY		4	/* security parameter syscall */
#define	RT_ID_CHANGE		5	/* process id change record */
#define	RT_DAC_CHANGE		6	/* object DAC change */
#define	RT_BOOT_DOWN		7	/* startup/shutdown */

/* Special Action Record Types */

#define	RT_COLLFILE_SWITCH	10	/* collection file switch */
#define	RT_COMPFILE_SWITCH	11	/* compacted output file switch */

/* Application Audit Record Types */

#define RT_APPLICATION		20	/* first application RT define */

#define	RT_LOGIN		20	/* new process login record */
#define	RT_PASSWORD		21	/* password record */
#define	RT_LOCK			22	/* terminal/user lock record */
#define	RT_AUDIT		24	/* audit subsystem record */
#define	RT_DATABASE		25	/* system database records */
#define	RT_SUBSYSTEM		26	/* subsystem activity record */

/* Object Types */

#define	OT_REGULAR		1	/* regular file */
#define	OT_DIRECTORY		2	/* directory */
#define	OT_DEVICE		3	/* block, char device */
#define	OT_PIPE			4	/* named, unnamed pipe */
#define	OT_PROCESS		5	/* self explanatory */
#define	OT_MEMORY		6	/*	""	*/
#define	OT_STREAM		7	/* V.3 stream */
#define	OT_SOCKET		8	/* Berkeley socket */
#define	OT_SHARED_MEMORY	9
#define	OT_SEMAPHORE		10
#define	OT_MESSAGE_QUEUE	11
#define OT_FILE_DESCR		12	/* file descriptor */

/*  Types of Authentication database objects */

#define	OT_PWD			12	/* /etc/passwd */
#define	OT_GRP			13	/* /etc/group */
#define	OT_PRPWD		14	/* Protected Password Database */
#define	OT_TERM_CNTL		15	/* Terminal Control Database */
#define	OT_FILE_CNTL		16	/* File Control Database */
#define	OT_CMD_CNTL		17	/* Command Control Database */
#define	OT_DFLT_CNTL		18	/* System Default Database */
#define	OT_SUBSYS		19	/* Subsystem Database */
#define OT_DEV_ASG		20	/* Device Assignment Database */


/*  Subsystem types */

#define	ST_AUTH			0	/* Use some authentication privs */
#define	ST_BACKUP		1	/* See file system data */
#define	ST_MEM			2	/* Look at kernel memory aspects */
#define	ST_TERMINAL		3	/* Unrestricted access to terminal */
#define	ST_LP			4	/* Be lp administrator */
#define	ST_UUCP			5	/* Turn on/off uucp network */
#define	ST_CRON			6	/* Cron event */
#define ST_SYSADMIN		7	/* System administrator subsystem */
#define ST_AUDIT		8	/* Audit subsystem */
extern int ST_MAX_CPRIV;		/* set by subsystems(3) routines */

/* Specific Events */

		/*	Kernel Startup/Shutdown Events	*/

#define	ES_KERNEL_STARTUP	1	/* boot record */
#define	ES_KERNEL_SHUTDOWN	2	/* shutdown record */

		/*	Login/Logoff Events	*/

#define	ES_LOGIN		1	/* successful login */
#define	ES_LOGIN_FAILED		2	/* failed login */
#define	ES_LOGOFF		3	/* logoff */

		/* 	Password Events 	*/

#define	ES_PW_CHANGE		1	/* pw change */
#define	ES_PW_CHANGE_FAILED	2	/* pw change failed */
#define	ES_PW_CHANGE_NOPRIV	3	/* no priv for pw change */

		/* 	Locking Events 		*/

#define	ES_USER_LOCK		1	/* login failure for locked user */
#define	ES_TERM_LOCK		2	/* login failure for locked terminal*/
#define ES_SET_USER_LOCK	3	/* lock user account */
#define ES_SET_USER_UNLOCK	4	/* unlock user account */
#define ES_SET_TERM_LOCK	5	/* lock terminal */
#define ES_SET_TERM_UNLOCK	6	/* unlock terminal */

		/* 	Audit Subsystem Events */

#define ES_AUD_ENABLE	1	/* audit enabled */
#define	ES_AUD_DISABLE	2	/* disable auditing */
#define	ES_AUD_MODIFY	3	/* subsystem parameter modified */
#define	ES_AUD_REPORT	4	/* audit report generation */
#define	ES_AUD_ARCHIVE	5	/* compacted audit file archival */
#define	ES_AUD_REC_INIT 6	/* audit recovery start */
#define	ES_AUD_REC_END	7	/* audit recovery termination */
#define	ES_AUD_DMN_INIT	8	/* compaction daemon start */
#define	ES_AUD_DMN_END	9	/* compaction daemon termination */
#define	ES_AUD_SHUTDOWN	10	/* audit shutdown notification */
#define	ES_AUD_ERROR	11	/* audit error condition */

	/*  Codes used for the RT_DATABASE audit record */

#define	ES_DB_INTEGRITY		1	/* Auth database integrity */
#define	ES_FS_INTEGRITY		2	/* File system discr integrity */
#define	ES_DB_RESOURCE		3	/* Auth database resource denial */
#define	ES_SEC_FAILURE		4	/* Security action failed in auth DB */



/*
 *	Audit Subsystem Privileged Application interface through
 *	the ioctl(2) command to the audit device. The following
 *	function codes are supported. There are two structures
 *	defined for use by the applications; only the INIT function
 *	uses the audit_init structure.
 */

/* Audit ioctl(2) function codes */


/*
 *	The BSD and AUX based driver ioctls require a special encoding.
 *	This encoding technique is not used on audit for the System V
 *	version of the driver. The definition of this macro will allow
 *	in the System V case the use of the same definition as BSD and AUX.
 */

#ifndef _IO

#define _IO(c,n)	n		/* defines macro as ioctl # */

#endif	/* _IO */


#define	AUDIT_ENABLE	_IO(A,1)	/* initialize and enable auditing */
#define	AUDIT_SHUTDOWN	_IO(A,2)	/* system shutdown */
#define	AUDIT_DISABLE	_IO(A,3)	/* disable audit subsystem */
#define	AUDIT_SYSMASK	_IO(A,4)	/* system audit mask */
#define	AUDIT_USERMASK	_IO(A,5)	/* user masks */
#define	AUDIT_FLUSH	_IO(A,6)	/* coll. file write control */
#define	AUDIT_DAEMON	_IO(A,7)	/* daemon read control */
#define	AUDIT_ACK	_IO(A,8)	/* daemon acknowledge */
#define	AUDIT_MOUNTED	_IO(A,9)	/* filesystems mounted */
#define	AUDIT_STATS	_IO(A,10)	/* get subsystem statistics */
#define	AUDIT_IDS	_IO(A,11)	/* uid/gid selective collection */

/* ioctl(2) structures */

struct audit_init {
	uint	buf_length;	/* lngth of data including header */
	mask_t	audit_flags[1];	/* audit control flags */
	mask_t	event_mask[AUDIT_MASK_SIZE];	/* system event mask */
	uint	read_count;	/* daemon read count to satisfy */
	uint	write_count;	/* write count for coll. file flush */
	long	write_time;	/* write flush time in seconds */
	long	switch_count;	/* collection file size maximum */
	long	caf_maxsize;	/* compacted audit file max size */
	uint	dir_count;	/* directory count */
	uint	uid_count;	/* uid selection count */
	uint	gid_count;	/* gid selection count */
	ulong	dir_offset;	/* fseek of directory names */
	ulong	uid_offset;	/* fseek of uids to select */
	ulong	gid_offset;	/* fseek of gids to select */
	uint	buff_count;	/* number of collection file buffers */
	ulong	session;	/* system boot session number */
	short	audit_uid;	/* audit user uid */
	short	audit_gid;	/* audit group gid */
};

#define	AUDITINIT_SIZE	(sizeof(struct audit_init))

/* AUDIT Control Flag Definitions */


#define AUDIT_FLAG_MAX		2

#define AUDIT_COMPACT_FLAG	0	/* 0=no compact, 1=compact */
#define	AUDIT_PANIC_FLAG	1	/* 0=shutdown, 1=panic */


/* Audit ioctl(2) structure for modifying User masks, System mask,
 * Daemon read parameters, Subsystem write parameters.		*/

struct audit_ioctl {
	uint	read_count;	/* daemon read count to satisfy */
	uint	write_count;	/* write count for coll. file flush */
	long	write_time;	/* write flush time in seconds */
	mask_t	user_control[AUDIT_MASK_SIZE]; /* user control event mask */
	mask_t	user_disp[AUDIT_MASK_SIZE];    /* user disposition event mask */
	mask_t	system_mask[AUDIT_MASK_SIZE];  /* system event mask */
};

#define	AUDITIOCTL_SIZE	(sizeof(struct audit_ioctl))


struct audit_stats {
	uint	session;	/* current session number */
	uint	sequence;	/* current sequence number */
	ulong	total_bytes;	/* total bytes written */
	ulong	total_recs;	/* total records written */
	ulong	syscall_recs;	/* system call audit record count */
	ulong	syscall_norecs;	/* system call audit record count */
	ulong	appl_recs;	/* application audit record count */
	ulong	read_count;	/* number of device reads */
	ulong	write_count;	/* number of device writes */
	ulong	coll_files;	/* number of collection files */
	ulong	buffers_used;	/* maximum audit buffer depth */
	ulong	buffer_sleep;	/* count of audit space sleeps */
};

#define	AUDITSTATS_SIZE	(sizeof(struct audit_stats))


/*
 *	Constant Definitions and Structure Definitions for the generation
 *	of system call audit data. These tables may be system dependent
 *	if a system re-orders the standard syscall entry table from AT&T.
 */

/*	System Call Event Enable Constants	*/

#define	evmsk(event)	(1L << (event))

#define	AM_EXIT		(evmsk(ET_PROCESS))
#define	AM_FORK		(evmsk(ET_PROCESS) | evmsk(ET_RES_DENIAL))
#define	AM_READ		(evmsk(ET_OBJECT_MAP))
#define	AM_WRITE	(evmsk(ET_OBJECT_MOD) | evmsk(ET_RES_DENIAL))
#define	AM_OPEN		(evmsk(ET_OBJECT_AVAIL) | evmsk(ET_OBJECT_CREAT) | \
			 evmsk(ET_OBJECT_MOD) | evmsk(ET_RES_DENIAL) | \
			 evmsk(ET_ACCESS_DENIAL))
#define	AM_CLOSE	(evmsk(ET_OBJECT_UNAV))
#define	AM_CREAT	(evmsk(ET_OBJECT_CREAT) | evmsk(ET_OBJECT_MOD) | \
			 evmsk(ET_RES_DENIAL) | evmsk(ET_ACCESS_DENIAL))
#define	AM_LINK		(evmsk(ET_OBJECT_CREAT) | evmsk(ET_RES_DENIAL) | \
			 evmsk(ET_INSUFF_PRIV) | evmsk(ET_ACCESS_DENIAL))
#define	AM_UNLINK	(evmsk(ET_OBJECT_DEL) | evmsk(ET_ACCESS_DENIAL) | \
			 evmsk(ET_INSUFF_PRIV))
#define	AM_EXEC		(evmsk(ET_OBJECT_MAP) | evmsk(ET_ACCESS_DENIAL))
#define	AM_CHDIR	(evmsk(ET_PROCESS_MOD) | evmsk(ET_ACCESS_DENIAL))
#define	AM_MKNOD	(evmsk(ET_OBJECT_CREAT) | evmsk(ET_INSUFF_PRIV))
#define	AM_CHMOD	(evmsk(ET_DAC_CHANGE) | evmsk(ET_ACCESS_DENIAL) | \
			 evmsk(ET_INSUFF_PRIV))
#define	AM_CHOWN	(evmsk(ET_DAC_CHANGE) | evmsk(ET_ACCESS_DENIAL) | \
			 evmsk(ET_INSUFF_PRIV))
#define	AM_BREAK	(evmsk(ET_RES_DENIAL))
#define	AM_STAT		(evmsk(ET_OBJECT_MAP) | evmsk(ET_ACCESS_DENIAL))
#define	AM_MOUNT	(evmsk(ET_OBJECT_AVAIL) | evmsk(ET_INSUFF_PRIV) | \
			 evmsk(ET_RES_DENIAL))
#define	AM_UMOUNT	(evmsk(ET_OBJECT_UNAV) | evmsk(ET_INSUFF_PRIV))
#define	AM_SETUID	(evmsk(ET_PROCESS_MOD) | evmsk(ET_ACCESS_DENIAL))
#define	AM_STIME	(evmsk(ET_INSUFF_PRIV))
#define	AM_ACCESS	(evmsk(ET_ACCESS_DENIAL))
#define	AM_KILL		(evmsk(ET_IPC) | evmsk(ET_ACCESS_DENIAL) | \
			 evmsk(ET_INSUFF_PRIV))
#define	AM_SETPGRP	(evmsk(ET_PROCESS_MOD))
#define	AM_DUP		(evmsk(ET_OBJECT_AVAIL) | evmsk(ET_RES_DENIAL))
#define AM_PIPE		(evmsk(ET_OBJECT_AVAIL) | evmsk(ET_RES_DENIAL))
#define	AM_SETGID	(evmsk(ET_PROCESS_MOD) | evmsk(ET_INSUFF_PRIV))
#define	AM_MSG		(evmsk(ET_IPC) | evmsk(ET_OBJECT_MAP) | \
			 evmsk(ET_OBJECT_CREAT) | evmsk(ET_DAC_CHANGE) | \
			 evmsk(ET_OBJECT_DEL) | evmsk(ET_OBJECT_AVAIL) | \
			 evmsk(ET_ACCESS_DENIAL) | evmsk(ET_INSUFF_PRIV))
#define	AM_SHM		(evmsk(ET_IPC) | evmsk(ET_OBJECT_MAP) | \
			 evmsk(ET_OBJECT_CREAT) | evmsk(ET_DAC_CHANGE) | \
			 evmsk(ET_OBJECT_DEL) | evmsk(ET_OBJECT_AVAIL) | \
			 evmsk(ET_ACCESS_DENIAL) | evmsk(ET_INSUFF_PRIV))
#define	AM_SEM		(evmsk(ET_IPC) | evmsk(ET_OBJECT_MAP) | \
			 evmsk(ET_OBJECT_CREAT) | evmsk(ET_DAC_CHANGE) | \
			 evmsk(ET_OBJECT_DEL) | evmsk(ET_OBJECT_AVAIL) | \
			 evmsk(ET_ACCESS_DENIAL) | evmsk(ET_INSUFF_PRIV))
#define AM_IOCTL	(evmsk(ET_BOOT_DOWN) | evmsk(ET_SYS_ADMIN))
#define	AM_FCNTL	(evmsk(ET_OBJECT_AVAIL) | evmsk(ET_RES_DENIAL))
#define	AM_EXECE	(evmsk(ET_OBJECT_MAP) | evmsk(ET_ACCESS_DENIAL))
#define	AM_CHROOT	(evmsk(ET_PROCESS_MOD) | evmsk(ET_INSUFF_PRIV))
#define	AM_RMDIR	(evmsk(ET_OBJECT_DEL))
#define	AM_MKDIR	(evmsk(ET_OBJECT_CREAT))
#define	AM_GETDENTS	(evmsk(ET_OBJECT_MAP))
#define AM_STATFS	(evmsk(ET_OBJECT_MAP))
#define AM_FSTATFS	(evmsk(ET_OBJECT_MAP))
#define	AM_SECURITY	(evmsk(ET_PROCESS))

#ifdef M_XENIX
#define AM_CHSIZE	(evmsk(ET_OBJECT_MOD))		/* xenix calls */
#define	AM_PROCTL	(evmsk(ET_PROCESS_MOD) | evmsk(ET_SYS_ADMIN))
#define AM_EXECSEG	(evmsk(ET_OBJECT_MOD) | evmsk(ET_PROCESS_MOD))
#define AM_UNEXECSEG	(evmsk(ET_OBJECT_MOD) | evmsk(ET_PROCESS_MOD))
#endif


	/*	Audit Subsystem Syscall Audit Structure	*/

struct syscall_audit {
	int	mandatory;	/* mandatory auditing */
	mask_t	event_mask[AUDIT_MASK_SIZE];	/* system events audited */
	uint	event_type;	/* default event type */
	uint	record_type;	/* default record type */
};

	/*	Audit Subsystem Control Structure	*/

struct audit_control {
	char	init;		/* subsystem initialized */
	char	auditing;	/* enabled=1, disabled=0 */
	char	mounted;	/* filesystems mounted */
	char	lock;		/* audit subsystem lock */
	char	read_nosleep;	/* read process shouldn't sleep */
	char	not_warned;	/* low free block warning flag */
	char	termed;		/* terminated due to error */
	char	panic;		/* panic on error if flag set */
	char	cf_open;	/* collection file open in progress */
	char	in_timeout;	/* cf_timeout in progress */
	char	resvd[2];	/* RFU */
	uint	session;	/* system boot session number */
	uint	sequence;	/* collection file sequence number */
	ulong	event_id;	/* event sequence number */
	short	cf_uid;		/* audit user id */
	short	cf_gid;		/* audit group id */

/* Used to retain boot information */

	ino_t	kinode;		/* kernel boot inode */
	char	kpath[AUDIT_KPATHSIZE];	/* kernel path name */

/* Subsystem tunable parameters	*/

	mask_t	sys_mask[AUDIT_MASK_SIZE];	/* system event mask */
	ulong	switch_count;	/* collection file switch threshold */
	uint	read_count;	/* daemon flush read count */
	uint	write_count;	/* subsystem flush count */
	uint	write_time;	/* subsystem write interval (HZ) */
	char	*dirs[AUDIT_MAXDIRS];	/* directory buffer pointers */
	uint	dir_count;	/* directory list count */
	uint	uid_count;	/* user id select count */
	uint	gid_count;	/* group id select count */
	uint	dir_index;	/* next directory pointer index */
	char	*dir_pool;	/* pointer to directory path names */
	char	*curr_dir;	/* pointer to directory path */
	char	*id_pool;	/* pointer to id buffer pool */
	uint	idpool_size;	/* size of id buffer pool */
	ushort	*uids;		/* uid array */
	ushort	*gids;		/* gid array */

/* Collection file buffer pool variables	*/

	uint	buff_size;	/* size of collection buffer */
	uint	last_flush;	/* write count since last buffer write */
	uint	total_count;	/* total bytes in buffers */
	uint	buff_offset;	/* current offset into buffers */
	uint	buff_count;	/* number of allocated buffers */
	uint	buff_io;	/* current I/O buffer id */
	uint	block_number;	/* current file block number (BSIZE blocks) */
	char	*buff_addr;	/* address of buffer pool */

/* Variables to track the exclusive read process	*/

	struct proc *d_procp;	/* daemon proc pointer */
	ushort	d_pid;		/* daemon process id */
	ulong	lock_count;	/* audit lock count */
	ulong	unlock_count;	/* audit unlock count */
	ushort	lock_pid;	/* audit subsystem lock pid */
	ushort	plockr_pid;	/* read inode plock pid */
	ushort	plockw_pid;	/* write inode plock pid */

/* Collection file read and write variables	*/

	struct filsys *fs;	/* Superblock ptr of audit device */
	struct inode *cfip[AUDIT_MAXIPS]; /* collection file inode pointers */
	struct inode *rcfip;	/* readers inode pointer */
	struct inode *wcfip;	/* writers inode pointer */
	uint	warn_blocks;	/* free block warning count */
	uint	stop_blocks;	/* free block stop-switch count */
	long	rcf_offset;	/* readers file offset */
	long	wcf_offset;	/* writers file offset */
	uint	read_index;	/* readers index into cfip[] */
	uint	write_index;	/* writers index into cfip[] */

/* Audit record generation storage */

	uint	path1_size;	/* size of path name */
	uint	path2_size;	/* size of path name */
	char	path1[AUDIT_PATHSIZE];	/* path name from user space */
	char	path2[AUDIT_PATHSIZE];	/* path name from user space */
};

extern struct audit_control aud_cont;

/*
 *	Structure definitions for the various record types generated by
 *	the kernel and application programs that are auditing themselves.
 */

struct audit_header {
	ushort	rec_length;	/* record lngth plus header */
	time_t	tstamp;		/* date/time stamp */
	ulong	event_id;	/* event sequence id */
	ushort	event_type;	/* event type */
	ushort	record_type;	/* audit record type */
	ushort	obj_type;	/* object type */
	ushort	pid;		/* process id */
};

struct syscall_record {		/* RT_SYSCALL */
	struct audit_header aud_hdr;
	short	syscall;	/* system call number */
	long	u_arg[4];	/* user syscall arguments */
	short	rval1;		/* syscall return values */
	short	rval2;
	char	u_error;	/* u.u_error return value */
	short	privilege;	/* privilege identifier */
	ushort	access;		/* policy access code */
	mask_t	priv[SEC_SPRIVVEC_SIZE];	/* privilege use vector */
};

#define	SYSREC_SIZE	(sizeof(struct syscall_record))


/* Audit Subsystem System Call Audit Record Flags */

#define	AUD_SELFAUDIT	0x1	/* Selfaudit process audit record */


struct syscall_record1 {	/* RT_SYSCALL_1 */
	struct syscall_record syscall_rec;
	ptr_t	text1;		/* path name pointer */
};

#define	hdr	aud_hdr
#define	sc	syscall_rec

#define	SYSREC1_SIZE	(sizeof(struct syscall_record1))

struct syscall_record2 {	/* RT_SYSCALL_2 */
	struct syscall_record syscall_rec;
	ptr_t	text1;		/* first path name */
	ptr_t	text2;		/* second path name */
};

#define	SYSREC2_SIZE	(sizeof(struct syscall_record2))

struct security_record {	/* RT_SECURITY */
	struct syscall_record syscall_rec;
	ushort	function;			/* security syscall function */
	ushort	luid;				/* login user id */
	ushort	privtype;			/* privilege type */
	ushort	objtype;			/* object type */
	uint	objid;				/* object id */
	mask_t	priv[SEC_SPRIVVEC_SIZE];	/* privilege vector */
};

#define	SECREC_SIZE	(sizeof(struct security_record))

struct id_record {	/* RT_ID_CHANGE */
	struct syscall_record syscall_rec;
	ushort	euid;		/* effective uid */
	ushort	egid;		/* effective group id */
	ushort	ruid;		/* real uid */
	ushort	rgid;		/* real gid */
};

#define	IDREC_SIZE	(sizeof(struct id_record))

struct dac_record {	/* RT_DAC_CHANGE */
	struct syscall_record syscall_rec;
	dac_t	old;		/* old DAC values */
	dac_t	new;		/* new DAC values */
	ptr_t	text1;		/* file pathname */
};

#define	DACREC_SIZE	(sizeof(struct dac_record))

struct boot_record {	/* RT_BOOT_DOWN */
	struct syscall_record syscall_rec;
	ino_t	kinode;		/* kernel boot inode */
	ushort	code;		/* event code */
	char	sysname[AUDIT_SYSNMSIZE];	/* system name */
	ptr_t	kpath;		/* kernel path pointer */
};

#define	BOOTREC_SIZE	(sizeof(struct boot_record))

/*
	Application audit record definitions.
*/

struct login_audit {
	struct audit_header aud_hdr;
	char	username[8];	/* login name */
	ushort	code;		/* function code */
	ushort	luid;		/* login userid */
	ushort	rgid;		/* real gid */
	dev_t	ttyd;		/* controlling terminal */
	ptr_t	cdir;		/* current directory */
	ptr_t	terminal;	/* stdin terminal name */
};

#define	LOGINAUDIT_SIZE	(sizeof(struct login_audit))

struct passwd_audit {	/* RT_PASSWORD */
	struct audit_header aud_hdr;
	char	username[8];	/* login user name */
	ushort	code;		/* function code */
};

#define	PASSWDAUDIT_SIZE	(sizeof(struct passwd_audit))

struct lock_audit {		/* RT_LOCK */
	struct audit_header aud_hdr;
	char	username[12];	/* login username or terminal */
	ushort	code;		/* lock function code */
	ushort	trys;		/* failed attempts */
};

#define	LOCKAUDIT_SIZE	(sizeof(struct lock_audit))

struct audit_actions {		/* RT_AUDIT */
	struct audit_header aud_hdr;
	ushort	code;		/* audit function code */
	ptr_t	text1;		/* initial collection file name */
};

#define	AUDITACTIONS_SIZE	(sizeof(struct audit_actions))


struct database_activity {		/* RT_DATABASE */
	/* Fixed entries */
	struct audit_header aud_hdr;
	ptr_t	command;	/* command name */
	ushort	code;		/* Type of database audit activity. */
	/* Variable entries -- their use is dependent on the code */
	ushort	object;		/* System object type or database object type */
	long	expected_val;	/* Expected value of parameter */
	long	present_val;	/* Present real value of parameter */
	ptr_t	action;		/* security action that failed */
	ptr_t	result;		/* result of failure to global action tried */
};

#define	DATABASEACTIVITY_SIZE	(sizeof(struct database_activity))


struct subsystem_activity {		/* RT_SUBSYSTEM */
	struct audit_header aud_hdr;
	ptr_t	command;	/* command name (subsystems can have > 1) */
	ushort	code;		/* Subsystem type */
	ptr_t	action;		/* action that failed */
	ptr_t	result;		/* result of failure to subsys/cmd */
};

#define	SUBSYSTEMACTIVITY_SIZE	(sizeof(struct subsystem_activity))



/*
 *	Special Record Type structure definitions.
 */

struct fileswitch_record {	/* RT_COLLFILE_SWITCH, RT_COMPFILE_SWITCH */
	struct audit_header aud_hdr;
	ptr_t	filename;	/* new path name */
};

#define	FILESWITCHREC_SIZE	(sizeof(struct fileswitch_record))


/*
 *	Constants and Structure Definitions for Recovery Mechanism
 */

#define	AUDIT_BUSY	0x0	/* state = Abnormal shutdown */
#define	AUDIT_NORMAL	0x1	/* state = CLEAN shutdown */

struct recovery_info {
	char	state;		/* state of last shutdown */
	char	coll_file[AUDIT_PATHSIZE];  /* collection file name */
	char	comp_file[AUDIT_PATHSIZE];  /* compacted file name */
	char	log_file[AUDIT_PATHSIZE];   /* log file name */
	ulong	lseek;		/* seek address of buffer */
	ulong	offset;		/* offset into buffer after un-compaction */
};

#define	RECOVERYINFO_SIZE	(sizeof(struct recovery_info))


/*	Audit Log File Header Structure		*/

#define	COMPACTED	1		/* compacted */
#define	UNCOMPACTED	2		/* not compacted */


struct log_header {
	char	id[8];		/* "AUDITLOG" */
	char	sys[8];		/* system name */
	ulong	flag;		/* information on session */
	ulong	read_size;	/* maximum read buffer size */
	ulong	session;	/* log session number */
	ulong	comp_files;	/* number of compacted file entries */
	ulong	coll_files;	/* number of collection file switches */
	ulong	caf_maxsize;	/* maximum compaction file size */
	time_t	start;		/* time stamp of log file start */
	time_t	stop;		/* time stamp of log file end */
	ulong	records;	/* number of audit records */
	ulong	total;		/* amount of uncompacted data */
	ulong	compacted;	/* amount of compacted data */
	ulong	audit_messages;	/* audit application msgrcv() calls */
};

#define	AUDIT_LOGID	"AUDITLOG"


/*	Audit Daemon Information Structure	*/

struct dmninfo {
	ulong	pid;		/* daemon process id */
	ulong	msgqid;		/* application audit message queue id */
};

/*	Selective Audit Collection/Reduction Structure	*/

struct audit_select {
	ulong	sel_size;		/* size of selectivity data */
	ushort	uid_count;	/* number of user id ushort entries */
	ushort	gid_count;	/* number of group id ushort entries */
	ushort	object_count;	/* number of variable length object names */
	mask_t	event_mask[AUDIT_MASK_SIZE];  /* mask of selected event types */
	ulong	uid_offset;	/* offset to "ushort uids[uid_count]" */
	ulong	gid_offset;	/* offset to "ushort gids[gid_count]" */
	ulong	object_offset;	/* offset to "char **objects" */
	time_t	start;		/* select after this time */
	time_t	stop;		/* select before this time */
};

#define	AUDITSELECT_SIZE	(sizeof(struct audit_select))

#endif
#endif	/* _SYS_AUDIT_H */
