#ident	"@(#)arch.h	1.2	90/08/08"
#ifndef _SYS_ARCH_H
#define _SYS_ARCH_H

#ident "@(#) arch.h 22.1 90/03/14 "
/*
 *	Copyright (C) The Santa Cruz Operation, 1990.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and should be treated as Confidential.
 */

/*
 * Bits set in the definition of ARCH (supplied to the C-pre-processor),
 * which defines the architectures to be supported by the built object:
 * if AT and MC bits are both set, both AT and MC are to be supported.
 *      ==
 * Bits set in the os/bs.c "variable" arch (set according to bootflags),
 * which defines the architecture on which the kernel is running:
 * AT and MC bits cannot be set together, but in future extensions
 * bits may be added which could be set together with others.
 *
 * Note that whenever new bits are added, the validity of pre-processor and
 * runtime conditionals must be checked in all files which include arch.h.
 */

#define AT	0x00000001	/* Industry Standard Architecture */
#define MC	0x00000002	/* Micro Channel Architecture */

#ifdef ARCH

	/*
	 * Definitions for compatibility with UNIX files
	 * containing #ifdef AT386 or #ifdef MC386
	 */

#	if (ARCH & AT)
#		define AT386	1
#	endif /* ARCH & AT */

#	if (ARCH & MC)
#		define MC386	1
#	endif /* ARCH & MC */

#else /* !ARCH */

	/*
	 * Definitions for back-porting io drivers to XENIX,
	 * where Q_AT and possibly Q_PS will be defined
	 */
#	ifdef Q_PS
#		define ARCH MC
#	else /* !Q_PS */
#		ifdef Q_AT
#			define ARCH AT
#		endif /* Q_AT */
#	endif /* !Q_PS */

	/*
	 * Definitions for building UNIX as before,
	 * with -DAT386 and/or -DMC386 instead of -DARCH=??
	 */
#	ifdef MC386
#		ifdef AT386
#			define ARCH (AT|MC)
#		else /* !AT386 */
#			define ARCH MC
#		endif /* !AT386 */
#	else /* !MC386 */
#		ifdef AT386
#			define ARCH AT
#		endif /* AT386 */
#	endif /* !MC386 */

#endif /* !ARCH */

/*
 * Generate compilation error if no architecture defined
 */
#if ARCH == 0
Error_No_Architecture_Defined
#endif /* ARCH == 0 */

/*
 * If building for a single architecture only,
 * replace variable arch by appropriate definition,
 * so that optimizer generates more compact code
 */
#if (ARCH == AT || ARCH == MC)
#define arch ARCH
#endif /* ARCH == AT || ARCH == MC */

/*
 * But if building for more than one architecture,
 * declare external "variable" arch for tests
 */
#ifndef arch
extern unsigned long arch;
#endif /* !arch */

/*
 * Code to be compiled both for single architectures,
 * and again to support more than one architecture,
 * may for example take the following form:
 *

#	if (ARCH & MC)		** if this build supports MCA **
	if (arch & MC)		** if kernel is running on MCA **
		printf("microchannel architecture\n");
#	endif

#	if (ARCH & ~MC)		** if build supports other than MCA **
	if (!(arch & MC))	** if kernel is not running on MCA **
		printf("not microchannel architecture\n");
#	endif

 *
 */

#endif	/* _SYS_ARCH_H */
