#ident	"@(#)a596.h	1.2	90/08/08"
/* @(#)a596.h	1.4 90/04/13 */ 

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef NULL
#define NULL 0
#endif

/*
* Constants and structs specific to this driver
*/

#define	A596MID	596		/* A596 Module ID */

/* multicast address list */

struct mc_list {
	int	mc_count;
	struct lli_sap *mc_sap_p[MC_CNT];
	struct eaddr mc_id[MC_CNT];
};

/* Statistics structure */

struct a596stats {
	uint allocfails;
	uint badintr;
	uint colls;
	uint crcerrs;
	uint opackets;
	uint etint;
	uint etqueue;
	uint fifoorun;
	uint fifourun;
	uint fralignerrs;
	uint heartbeat;
	uint late_coll;
	uint missintr;
	uint no_crs;
	uint no_cts;
	uint restarts;
	uint rxct;
	uint rxcollerrs;
	uint rxerrs;
	uint rxrscerrs;
	uint sfrpkts;
	uint txct;
	uint txcollerrs;
	uint txdefer;
	uint txerrs;
};

/*
*	a596device - device descriptor
*
* This structure describes the ACPA/AT device.  One exists for each board
* in the system.
*/

struct a596device {
	int	unit;		/* Unit number */
	int 	io_addr;	/* I/O space base address */
	int	ivect;		/* interrupt vector */
	int	dma_chan;	/* dma channel */
	int	cmd_timer;	/* -1 no cmd, 0 reset, >0 running */
	int	bad_intr_cnt;	/* Count the bad interrupts, then reset */
	int	open_count;	/* ++ each open and -- each close */
	struct {
	 unsigned present : 1;
	 unsigned thicknet : 1;
	} config;		/* configuration options */
	struct {
	 unsigned up : 1;
	 unsigned functional : 1;
	 unsigned cu_busy : 1;
	} status;			/* operational status */
	struct lli_sap	*lli_sap_p;	/* list of Ethernet bound streams */

	struct lli_sap	*xmt_head;
	struct lli_sap	*xmt_tail;
	mblk_t		*xmt_mp;
	struct scp	*scp_p;
	struct iscp	*iscp_p;
	struct scb	*scb_p;
	char		*rtn_p;
	union cb	*cb_p;
	struct tbd	*tbd_p;
	struct tbuf	*tbuf_p;
	struct rfd	*rfd_p;
	struct rbd	*rbd_p;
	struct rbuf	*rbuf_p;
	int	n_rbufs;

	struct rfd	*begin_rfd;	/* keeps tabs of fd */
	struct rfd	*end_rfd;
	struct rbd	*end_rbd;	/* ditto, see rcv_ & xmt_packet */

	struct eaddr	eaddr;	/* enet host id */
	struct mc_list	mc_list;	/* multicast addresses */
	uint	cmd_port;		/* ACPA command port value */ 

	struct ifstats		ifs;	/* Berkeley style interface stats */
	struct a596stats	a596stats;	/* local interface stats */
};

/*
* 
*/

struct lli_sap {
	struct lli_sap	*next_p;
	struct lli_sap	*xmt_queue;
	queue_t	*read_q;
	struct a596device	*dev_p;
	long	current_state;
	long	subnet_type;
	long	dlsap;
	short	unit;
	ushort	min_dev;
}; 
