#ident "@(#)space.c	2.3 91/01/31"
/*
*	@(#) space.c 22.3 90/04/02 
*
*	Copyright (C) The Santa Cruz Operation, 1984-1988, 1989, 1990.
*	This Module contains Proprietary Information of
*	The Santa Cruz Operation, and should be treated as Confidential.
*/

#include "tune.h"
#define  SPACE_C	/* we're in space.c */
#include "space.h"

#if !BOOTLOADSYM
/*
*	not used if boot-loaded, and will cause multiple-redefined's
*	if loaded.
*/	
char	db_symboltable[SYMTSZ]	= {0};
int	db_symboltablesize	= sizeof(db_symboltable);
int	db_nsymbols		= 0;
char	db_stuntable[STTBSZ]	= {0};
int	db_stuntablesize	= sizeof(db_stuntable);
#endif

/*
*	History buffers
*/
struct ilin ibufs[MAXHIST];
int maxhist	= MAXHIST;
/* next two lines MUST go together, struct list history first: */
struct list history = { LF_CANERR|LF_WRAPS, 0 };
#if (MAXHIST > 1)
struct ilin *__hist_bufps[MAXHIST-1] = { 0 };
#endif

/*
*	Debugger variables
*/
struct dbvar dbvar[NDBVAR];
int ndbvar	 = NDBVAR;

/*
*	Breakpoints
*/
struct bkp bkp[MXNBP];
int mxnbp    = MXNBP;

/*
*	Breakpoint command buffers
*
*	we don't allocate the maximum possible amount cuz
*	it's unlikely that every breakpoint try to use the 
*	full amount available.
*/
#define		NBIBUFS		((MXNBP+4)*NLPBP/4)
struct ilin bibufs[NBIBUFS];
int nbibufs	 = NBIBUFS;

/*
*	Would be kind of nice to know when the kernel
*	was configured
*/
#if defined(__TIME__) && defined(__DATE__)
char	*configuredat = __TIME__ ", " __DATE__ ;
#endif

/*
*	Debugger stack
*/
char dbstk[DBSTKSZ];
int dbstks = DBSTKSZ;

int	scodb_debugkey	= DBKEY;
int	scodb_maindebug	= MAINDB;










/*
*************************************************************************
*									*
*	Semi-changeable structures -					*
*		be very careful in modifying, SCODB is not responsible	*
*		for you messing up in here!				*
*************************************************************************
*/








/*
*	These strings should have proper effect for whatever the
*	display unit is.
*
*	SCODB's editing facilities require the following capability
*	strings:
*		string			TERMINFO	TERMCAP
*	     ----------------------------------------------------
*		c_move_up		cuu1		up
*		c_move_down		cud1		do
*		c_move_right		cuf1		nd
*		c_move_left		cub1		le
*		c_delete_line		dl1		dl
*		c_delete_char		dch1		dc
*		c_insert_char		ich1		ic
*		c_insert_line		il1		al
*		c_clear_to_eol		el		ce
*
*	Note that \033 is ASCII ESC (escape).
*	The proper escape codes for ANSI displays are:
*		c_move_up	\033[A
*		c_move_down	\033[B
*		c_move_right	\033[C
*		c_move_left	\b
*		c_delete_line	\033[M
*		c_delete_char	\033[P
*		c_insert_char	\033[@
*		c_insert_line	\033[L
*		c_clear_to_eol	\033[K
*/
char	*c_move_up	=	"\033[A";
char	*c_move_down	=	"\033[B";
char	*c_move_right	=	"\033[C";
char	*c_move_left	=	"\b"	;
char	*c_delete_line	=	"\033[M";
char	*c_delete_char	=	"\033[P";
char	*c_insert_char	=	"\033[@";
char	*c_insert_line	=	"\033[L";
char	*c_clear_to_eol	=	"\033[K";

/*
*	Structure/address associations
*		needs at least one so that "struct" can have a temporary
*
*	Example of initialization at compile-time (note that
*	size is not messed with here!):
*
*		extern int bdevsw;	... type not important ...
*		extern int cdevsw;	... type not important ...
*		extern int u;		... type not important ...
*		struct sstun sstun[NSSTUN+1] = {
*			{ (long)&bdevsw,	"bdevsw" },
*			{ (long)&cdevsw,	"cdevsw" },
*			{ (long)&u,		"u" },
*		};
*/
int nsstun	 = NSSTUN;
struct sstun sstun[NSSTUN+1];

/*
*	Aliases
*
*	Example of initialization at compile-time (note that
*	size is not messed with here!):
*		struct alias alias[NALIAS] = {
*			{ "str",	"struct &!1 is !1	" },
*			{ "inb",	"func &inb		" },
*			{ "ps",		"func &ps		" },
*		};
*/
int scodb_nalias = NALIAS;
struct alias alias[NALIAS];
