#ident "@(#)space.c	1.1 90/08/08"

#include <sys/types.h>
#include <sys/stream.h>
#include "sys/socket.h"
#include "sys/net/if.h"
#include "sys/82596.h"
#include "sys/a596.h"
#include "config.h"

#define A596_MAX_LINK	0x20

int a596_units = {A596_CNTLS};
int a596_link_cnt = {A596_MAX_LINK};

struct lli_sap lli_sap[A596_MAX_LINK];

struct a596device a596device[A596_CNTLS];

/* DMA channel per board */
uint a596_chan[A596_CNTLS] = {A596_CHAN};

/* interrupt level per board */
uint a596_ivect[A596_CNTLS] = {A596_0_VECT};

/* io and physical addresses per board */
uint a596_sioa[A596_CNTLS] = {A596_0_SIOA};
uint a596_eioa[A596_CNTLS] = {A596_0_EIOA};
uint a596_scma[A596_CNTLS] = {A596_0_SCMA};
uint a596_ecma[A596_CNTLS] = {A596_0_ECMA};

/* bus throttle timers */
ushort a596t_on = {0x400};  /* default = 64 us */
ushort a596t_off = {0x8};  /* default = .5 us */

/* Debug Variables */

int a596_debug = {FALSE};
int a596_strlog = {FALSE};
