/* 
 *      Copyright (C) The Santa Cruz Operation, 1987, 1988, 1989.
 * 
 *      This Module contains Proprietary Information of the Santa
 *      Cruz Operation and should be treated as confidential. 
 *
 */

#include "space.h"


extern int monoinit();
extern int monoinitscreen();
extern void monoscroll();
extern void monocopy();
extern void monoclear();
extern void monopchar();
extern void monoscurs();
extern void monosgr();
extern int monoioctl();
extern int monoadapctl();
extern int monoshut();
extern int monorestart();



extern int cgainit();
extern int cgainitscreen();
extern void cgascroll();
extern void cgacopy();
extern void cgaclear();
extern void cgapchar();
extern void cgascurs();
extern void cgasgr();
extern int cgaioctl();
extern int cgaadapctl();
extern int cgashut();
extern int cgarestart();



extern int vgainit();
extern int vgacmos();
extern int vgainitscreen();
extern void vgascroll();
extern void vgacopy();
extern void vgaclear();
extern void vgapchar();
extern void vgascurs();
extern void vgasgr();
extern int vgaioctl();
extern int vgaadapctl();
extern int vgashut();
extern int vgarestart();



extern int egainit();
extern int egacmos();
extern int egainitscreen();
extern void egascroll();
extern void egacopy();
extern void egaclear();
extern void egapchar();
extern void egascurs();
extern void egasgr();
extern int egaioctl();
extern int egaadapctl();
extern int egashut();
extern int egarestart();

extern int nulldev();

struct adapter cn_adapsw[MAXADAPTERS] = {
	{
	"mono", MONO, 0, 0, 0,
	monoinit,
	nulldev,
	monoinitscreen,
	monoscroll,
	monocopy,
	monoclear,
	monopchar,
	monoscurs,
	monosgr,
	monoioctl,
	monoadapctl,
	0, 0x00000000, 0x00000000, 0,
	monoshut,
	monorestart
	},

	{
	"cga", CGA, 0, 0, 0,
	cgainit,
	nulldev,
	cgainitscreen,
	cgascroll,
	cgacopy,
	cgaclear,
	cgapchar,
	cgascurs,
	cgasgr,
	cgaioctl,
	cgaadapctl,
	0, 0x00000000, 0x00000000, 0,
	cgashut,
	cgarestart
	},

	{
	"vga", VGA, 0, 0, 0,
	vgainit,
	vgacmos,
	vgainitscreen,
	vgascroll,
	vgacopy,
	vgaclear,
	vgapchar,
	vgascurs,
	vgasgr,
	vgaioctl,
	vgaadapctl,
	0, 0x00000000, 0x00000000, 0,
	vgashut,
	vgarestart
	},

	{
	"ega", EGA, 0, 0, 0,
	egainit,
	egacmos,
	egainitscreen,
	egascroll,
	egacopy,
	egaclear,
	egapchar,
	egascurs,
	egasgr,
	egaioctl,
	egaadapctl,
	0, 0x00000000, 0x00000000, 0,
	egashut,
	egarestart
	},

	{
	(char *)0
	}
};
