/*
 * Sector sparing information.
 *    Bad sectors are mapped to another sector in a reserved
 *    area of the disk.
 */

struct mapsec {
	int	bad_cyl;	/* Cylinder number of bad sector */
	char	bad_hed;	/* Head number of bad sector */
	char	bad_sec;	/* Sector number of bad sector */
	int	bad_good;	/* Offset into mapping area of good sector */
};

#define	BADMAP	4		/* Location in cylinder zero sector mapping */
#define	MAXBAD	(12*8*2)	/* Maximum number of bad sectors on disk */
				/*   This is probably overly generous */
#define	BADSIZ	(MAXBAD * sizeof(struct mapsec))
				/* Total size (in bytes) of sector map */
