/*
	read files from /dev/tar using common character compression
*/

#define	SUBR	0	/* if set, this is called by tactar */

#include <stdio.h>

#define BUFSIZE 10240
#define TARSIZE 1147900
#define CMPCHR '\233'

char	buf1[BUFSIZE*3],buf2[BUFSIZE];

#if	( SUBR == 0 )
main(argc,argv)
int	argc;
char	*argv[];
#else
trst()
#endif

{
	char	*cp;
	register FILE	*fdi;
	register FILE	*fpo;

#if ( SUBR == 0 )
	cp = argv[0];
	if ((fdi = fopen("/dev/tar","r")) == NULL) {
		fprintf(stderr,"%s: Can't open /dev/tar\n",cp);
		exit (-1);
		}
#endif

	for (;;) {
		if (fread(buf1,1,1,fdi) < 1) {
			fprintf(stderr,"Can't read /dev/tar\n");
			exit(-1);
			}

		if (buf1[0] == 'E') {
			fclose(fdi);
			exit(0);
			}
		if (buf1[0] == 'N') {
			readtar(fdi,argc,argv);
			continue;
			}
		fprintf(stderr,"Incorrect format!\n");
		exit(-1);
		}
	}


readtar(fd,argc,argv)
FILE	*fd;
int	argc;
char	*argv[];
{
	char	name[256];
	register unsigned n,y;
	unsigned x;
	FILE	*fpo;
	int	skipsw,fdt;

	if (fread(&x,sizeof(unsigned),1,fd) < 1) {
		fprintf(stderr,"Can't read size of name from /dev/tar\n");
		exit(-1);
		}

	if (fread(name,1,x,fd) < x) {
		fprintf(stderr,"Can't read name of file from /dev/tar\n");
		exit(-1);
		}

	name[x] = '\0';

	if (argc > 1) {
		for(x=1, skipsw=1; x<argc; ++x) {
			if(strcmp(argv[x],name) == 0) {
				skipsw = 0;
				break;
				}
			}
		} 
	else
		skipsw = 0;	/* restore every thing */

	if (skipsw == 0) {
		if ((fpo = fopen(name,"w")) == NULL) {
			fprintf(stderr,"Can't open %s\n",name);
			exit (-1);
			}
		}

	for (;;) {
		if (fread(buf1,1,1,fd) < 1) {
			fprintf(stderr,"Can't read record type from /dev/tar\n");
			exit(-1);
			}

		if (buf1[0] == 'Z') {
			fdt = open("/dev/tty",0);
			fprintf(stderr,"Mount next disk - press newline to continue\n");
			read(fdt,name,1);
			close(fdt);
			fclose(fd);	/* close floppy then reopen it */
			if ((fd = fopen("/dev/tar","r")) == NULL) {
				fprintf(stderr,"Can't open /dev/tar\n");
				exit (-1);
				}
			continue;
			}
		if (buf1[0] == 'F') {
			if (skipsw == 0) {
				fclose(fpo);
				printf("%s restored\n",name);
				}
			return;
			}
		if (buf1[0] != 'D') {
			fprintf(stderr,"Incorrect format on disk\n");
			exit(-1);
			}
		if (fread(&x,sizeof(unsigned),1,fd) < 1) {
			fprintf(stderr,"Can't read data record size from /dev/tar\n");
			exit(-1);
			}

		if (fread(buf1,1,x,fd) < x) {
			fprintf(stderr,"Can't read data record /dev/tar\n");
			exit(-1);
			}

		for(n=0; skipsw == 0 && n<x; ) {
			if (buf1[n] != CMPCHR) {
				fwrite(&buf1[n],1,1,fpo);
				++n;
				} 
			else {
				y = decmp(&buf1[n],buf2);
				if (buf2[0] == '\0')
					fseek(fpo,(long)y,1);
				else
					fwrite(buf2,1,y,fpo);
				n += 3;
				}
			}
		}
	}

