/*                                                           */
/*       Copyright 1983 Technical Analysis Corporation       */
/*                                                           */


#include <stdio.h>
#include "comm.h"

/* data global to comm() */
int lbye = 0, col = 0, buflen = 0;
char c, mode, data[133], cmsg[133], cmnd[133], rcmnd[133];
char buf[512],arg1[133], arg2[133], cmode;
char cs[128];
char sp1[] = {'\n', '\f', '\r', '\n', '\t', '^', '\0'};
char sp2[] = { 'L',  'F',  'L',  'N',  'T', '^', '\0'};

comm()
{
   char temp[133];
   cs[0] = NUL;
   for (c = ' '; c <= '~'; c++)
      if (c != '^')
	 append(cs, c);
   rcmnd[0] = NUL;
   mode = POLL;
   while (mode != QUIT) {
      mode = commio(mode);
      switch (mode) {

	 case QUIT:
	    continue;

	 case QUESTION_MARK:
	    mode = QUIT;
	    commio(mode);
	    continue;

	 case SYNC:
	    if (rc >= 0)
	       rclose();
	    if (wc >= 0)
	       wclose();
	    log("R: sync");
	    if (master)
	       mode = POLL;
	    continue;

	 case DATA:
	    if (wc >= 0) {
	       putdata();
	       mode = POLL;
	    } else {
	       mode = CONTROL;
	       copy(data, "ER File not opened");
	    }
	    continue;

	 case POLL:
	 case ACK:
	 case NAK:
	    moredata();
	    continue;

	 case CONTROL:
	    copy(temp, "R: ");
	    concat(temp, data);
	    log(temp);
	    copy(cmnd, data);
	    contproc(cmnd[0]); 
	    continue;

	 default:
	    copy(temp, "Invalid mode: ");
	    append(temp, mode);
	    log(temp);
	    abend(95);
      } /* end-switch */
   } /* end-while */
} /* end-comm */

getargs()
{
   int p;
   arg2[0] = NUL;
   p = 2;
   p = extract(arg1, cmnd, p);
   if (p > 0)
      p = extract(arg2, cmnd, p);
   return;
} /* end-getargs */

extract(outstr, instr, start)
char outstr[], instr[];
int start;
{
   int p; 
   p = start + 1;
   while (instr[p] == ' ')
      p++;
   while (instr[p] != ' ' && instr[p] != ',' && instr[p] != NUL)
      *outstr++ = instr[p++];
   *outstr = NUL;
   return(instr[p] ? p : 0);
} /* end-extract */

moredata()
{
   char temp[133];
   if (rc >= 0)
      if (getdata(data, PSIZE, cmode) != EOF)
	 mode = DATA;
      else {
	 if (rc >= 0)
	    rclose();
	 mode = CONTROL;
	 copy(data, "WE");
      }
   else {
      if (length(rcmnd) == 0) {
	 if (cc >= 0)
	    readcc(cmnd);
	 if (cc < 0) {
	    if (lbye)
	       mode = POLL;
	    else {
	       lbye = 1;
	       mode = CONTROL;
	       copy(data, "BYE");
	    }
	    cmnd[0] = NUL;
	    return;
	 }
      } else {
	 copy(cmnd, rcmnd);
	 rcmnd[0] = NUL;
      }
      copy(temp, "C: ");
      concat(temp, cmnd);
      log(temp);
      if (length(cmnd))
	 cmndproc(cmnd[0]); 
   }
   return;
} /* end-moredata */

contproc(code)
char code;
{
   char temp[133];
   switch (code) {
   
      case LOG:
	 mode = POLL;
	 return;

      case ERROR:
	 if (wc >= 0)
	    wc = -1;
	 mode = POLL;
	 return;
      
      case BYE:
	 if (lbye == 0) {
	    mode = POLL;
	    return;
	 }
	 if (master) {
	    mode = QUIT;
	    return;
	 }
	 lbye = 1;
	 mode = CONTROL;
	 copy(data, "BYE");
	 return;
	 
      case READ:
	 getargs();
	 rcmnd[0] = WRITE;
	 rcmnd[1] = cmnd[1];
	 rcmnd[2] = ' ';
	 rcmnd[3] = NUL;
	 concat(rcmnd, arg2);
	 concat(rcmnd, " ");
	 concat(rcmnd, arg1);
	 lbye = 0;
	 moredata();
	 return;
      
      case WRITE:
	 if (wc >= 0) {
	    putbuf();
	    wclose();
	 }
	 if (cmnd[1] == ERROR) {
	    mode = POLL;
	    return;
	 }
	 getargs();
	 if  ((wp = fopen(arg2, "w")) == NULL) {
	    copy(temp, "E: ");
	    concat(temp, data);
	    log(temp);
	    mode = CONTROL;
	    copy(data, "ER Unable to open file for writing");
	    return;
	 }
	 wc = 2;
	 cmode = (cmnd[1] == TEXT) ? TEXT : BINARY;
	 initbuf();
	 mode = POLL;
	 return;
      
      default:
	 copy(temp, "Invalid control code: ");
	 append(temp, code);
	 log(temp);
	 abend(98);
   } /* end-switch */
} /* end-contproc */

initbuf()
{
   buflen = 0;
   return;
} /* end-initbuf */

cmndproc(command)
char command;
{
   char temp[133];
   switch (command) {

      case COMMENT:
	 mode = POLL;
	 return;

      case WRITE:
	 getargs();
	 if (rc >= 0)
	    rclose();
	 if ((rp = fopen(arg1, "r")) == NULL) {
	    copy(temp, "E: ");
	    concat(temp, data);
	    log(temp);
	    mode = CONTROL;
	    copy(data, "ER Unable to open file for reading");
	    return;
	 }
	 rc = 3;
	 cmode = (cmnd[1] == TEXT) ? TEXT : BINARY;
         initbuf();
	 col = 0;

      case READ:
      case LOG:
	 mode = CONTROL;
	 copy(data, cmnd);
	 return;

      default:
	 copy(temp, "Invalid command: ");
	 append(temp, command);
	 log(temp);
	 abend(99);
   } /* end-switch */
} /* end-cmndproc */

putbuf()
{
   int p;
   for (p = 0; p < buflen; p++)
      putc(buf[p], wp);
   buflen = 0;
   return;
} /* end-putbuf */

readcc(line)
char line[];
{
   char c;
   while ((c = getline(cp, line, 132)) == EOL && length(line) == 0)
      ;
   if ((int) c == EOF) {
      fclose(cp);
      cc = -1;
   }
   return;
} /* end-readcc */

rclose()
{
   fclose(rp);
   rc = -1;
   return;
} /* end-rclose */

wclose()
{
   fclose(wp);
   wc = -1;
   return;
} /* end-wclose */

putdata()
{
   int i;
   char h[3];
   col = 0;
   while ((c = cget()) != NUL) {
      if (buflen >= 512)
	 putbuf();
      if (c != '^') {
	 addbuf(c);
	 continue;
      }
LAB1: if ((c = cget()) == NUL)
	 return;
      if (c != 'H') {
	 if (c == 'A')
	    continue;
	 if ((i = pos(sp2, c)) >= 0)
	    addbuf(sp1[i]);
	 if (i == 0 || i == 1)
	    putbuf();
	 continue;
      }
      while ((c = cget()) != NUL) {
	 if (c == '^')
	    goto LAB1;
	 h[0] = c;
	 h[1] = cget();
	 h[2] = NUL;
	 addbuf(hextoi(h));
	 if (buflen >= 512)
	    putbuf();
      }
   }
   return;
} /* end-putdata */

addbuf(c)
char c;
{
   buf[buflen++] = c;
   return;
} /* end-addbuf */

cget()
{
   return( (col < length(data)) ? data[col++] : NUL);
} /* end-cget */

getdata(buffer, lim, tmode)
char buffer[], tmode;
int lim;
{
   int i;
   char h[3];
   if (tmode == TEXT)
      buffer[0] = NUL;
   else
      copy(buffer, "^H");
   while (length(buffer) <= lim && (int) (c = getch()) != EOF)
      if (tmode != TEXT) {
	 itohex(h, (int) c, 2);
	 concat(buffer, h);
      } else
	 if (pos(cs, c) >= 0)
	    append(buffer, c);
	 else
	    if ((i = pos(sp1, c)) >= 0) {
	       append(buffer, '^');
	       append(buffer, sp2[i]);
	    } else {
	       itohex(h, (int) c, 2);
	       concat(buffer, "^H");
	       concat(buffer, h);
	       concat(buffer, "^A");
	    }
   if ((int) c == EOF)
      if ((tmode == TEXT && length(buffer) > 0) || 
	  (tmode != TEXT && length(buffer) > 2))
	    c = EOL;
   return(c);
} /* end-getdata */

getch()
{
   char c;
   if (cmode == TEXT) {
      while ((c = getc(rp)) == NUL)
	 ;
   } else
      c = getc(rp);
   return(c);
} /* end-getch */
