rem tarx - Read a floppy created with 'tar' utility on Altos system.
rem Multiple files & multiple volumns are supported.
rem Pathnames in input files are allowed. Pathnames are converted to
rem   AOS format (':' sub'ed for '/'). Note that pathname is ignored if
rem   'FLAT' is set.
rem
rem 7/3/84		waf

rem global consts
DBUG = 0						: Enables debugging
TEST = 1						: Don't create actual output files
SECSIZ = 512					: Sector size
dfni = 0						: Used to create test files

AOS = 0							: Select AOS environment
ALTOS = 1						: Select Altos environment
FLAT = 1						: All files dumped to current dir


dim flp$(32)					: Floppy disk filename
dim buf$(SECSIZ)				: Sector buffer
dim name$(100)					: Filename(s)
dim oct$(16)					: Octal string

rem System specific data
if AOS then
	flp$="@DPI0"				: Floppy filename
	fm=4						: Open mode
	sect = 64					: Starting sector
else
	flp$="/dev/tar"
	fm=0
	sect = 0
end if
gosub 9400						: Set initial sector


rem Open floppy disk as file
open file(0,fm),flp$


1000 rem ++ Get next file

1100 rem ++ Get header info
gosub 9000							: Read header sector

rem Get name
name$=trun$(buf$(1,100))
if name$="" then 8000				: End of dump
if DBUG then print ">> pathname = ";name$
gosub 9500							: Chk chksum
x=0									: ptr to rightmost '/'
for i=1 to len(name$)
	if name$(i,i)="/" then
		if FLAT then
			x=i
		else
			name$(i,i)=":"
		end if
	end if
next i
name$=name$(x+1)
if name$="" then stop
rem Get size
oct$=buf$(125,135)					: File size (octal)
gosub 9100							: Convert to number
fsiz = oct							: File size (dec)
nb = (fsiz+(SECSIZ-1))/SECSIZ		: # blocks
print name$,fsiz;"/";nb

1500 rem ++ Create output file
if TEST then
	name$="data",dn
	dn=dn+dfni
end if
open file(1,1),name$

1600 rem ++ Copy data
l=fsiz
nb=1
1650 if l<=0 goto 1900
gosub 9000							: Read next sect
if l<SECSIZ then buf$(l+1)=""		: Trunc last block
if DBUG then
	print">> blk#";nb;"size =";len(buf$)
	nb=nb+1
end if
write file(1),buf$(1,len(buf$))
l=l-len(buf$)
goto 1650
1900 close file(1)

goto 1000


8000 rem ++ End of tape
end


9000 rem ++ Read next sector
if AOS then
	if and(sect,15)=0 then sect=sect+1
	position file(0,sect*SECSIZ)
end if
volflg=0							: Reset new vol flag
on err gosub 9200					: Chk for end of vol
read file(0),buf$
on err then int						: Reset error trap
if eof(0) then volflg=1				: AOS end of vol flag (?)
if volflg then 
	gosub 9300						: Change vols
	goto 9000						: Get next sect
end if
sect=sect+1
return

9100 rem ++ Convert oct$ to oct
oct = 0
for i=1 to len(oct$)
	if oct$(i,i)<"0" then 9170
	if oct$(i,i)>"7" then 9170
	oct=oct*8+asc(oct$(i,i))-48
9170 next i
return

9200 rem ++ I/O error - chk for mult vol error code.
rem tar uses an ERXIO error code returned from read() to flag the
rem end of a volumn in a multi-volumn dump.
print "<7>"
x=sys(7)
if x <> -30 then
	buf$=erm$(x)
	print "** Error # ";x;": ";buf$
	print buf$
	stop
else
	volflg=1						: Flag end of vol
end if
return

9300 rem ++ Change vols
close file(0)
gosub 9350							: Show msg
open file(0,fm),flp$
gosub 9400							: Set intial sect
return
9350 rem Show msg
print "Insert next volumn. Enter RETURN to continue."
input x
return

9400 rem ++ Set intial sector value
if AOS then
	sect=64
else
	sect=0
end if
return

9500 rem ++ Chk chksum
oct$=buf$(149,156)
gosub 9100
cs=oct
buf$(149,156)="         "
cs2=0
for i=1 to SECSIZ
	cs2=cs2+asc(buf$(i,i))
next i
if cs2<>cs then
	print "<7>** Header chksum error **"
	if dbug then print "cs,cs2 =";cs;cs2
	stop
end if
return
