/*  mycb - my c program beautifier.
	Converts brace indentation (only)
	from KR conventions
	to
			<block head> {
				<block body>
				}
			and
			<fn-decl>()
			{
				<fn-body>
				}
*/

#include	<stdio.h>

main ( argc, argv )

int	argc;
char *argv[];
{
	char	c;

	while ( (c=getchar()) != EOF ) {

		if ( c != '\n' )
			putchar( c );

		else {

			do 
				putchar( c );		/* show <cr> */
				while ( (c=getchar()) == '\n' );

				if ( c == '{' )
					/* start of fn */
					goto skip;

				if ( c == '}' ) {
					/* end of fn */
					putchar( '\t' );
					goto skip;
					}

				/** chk for <ws>{ or <ws>} **/
				/* skip <ws> */
				while ( c == ' ' || c == '\t' ) {
					putchar(c);
					c = getchar();
					}
				/* chk for brace */
				if ( c == '{' || c == '}' )
					/* add '/t' */
					putchar( '\t' );

skip:
				putchar(c);
				}
			}

		}
