/*	Separate files downloaded using the 'emxfer' utility.
	Format of emxfer output -
		xfer	::=  <fsep> <endflg> <file># <endflg>
		<file>	::=  <file name> <file text> <file sep>
		<file text> ::=  (lines of text)

	To Do -
	> Option to back up target files?
	> Delete capture file?
*/

#include	<stdio.h>

#define	DBUG		0			/* debugging switch */
#define	PGMNAME		"emsep"		/* name of this pgm */
#define	CAPFILE		"em.cap"	/* capture filename */
#define	CMODE		0777		/* mode value for creat() */

FILE	*capfp, *outfp ;	/* file ptrs (capture file & output file) */



main ()

{
	char	outfile[16] ;		/* filename of next output file */
	char	line[256] ;			/* current input line */
	char	fsep[256] ;			/* file separator line */
	char	endflg[256] ;		/* end flag line */
	register int	i ;
	register int	lcnt ;


	/* Open capture file */
	capfp = fopen(CAPFILE, "r") ;
	if ( capfp == NULL )
		abend("Can't open capture file.") ;
	
	/* Get file separator line */
	nxtemline(fsep) ;
#if	DBUG
	strcpy(line, fsep) ;
	strip(line) ;
	printf("File sep line = >%s<\n", line) ;
#endif
	
	/* Get end flag line */
	nxtemline(endflg) ;
#if	DBUG
	strcpy(line, endflg) ;
	strip(line) ;
	printf("File sep line = >%s<\n", line) ;
#endif


	for (;;) {
		/** Get next file **/

		/* Get filename / end flag */
		nxtemline(outfile) ;
		if ( strcmp(outfile, endflg) == 0 )
			/* Done */
			break ;
		strip(outfile) ;
		printf("%s\t", outfile) ;
		if ( strlen(outfile) < 8 )
			putchar('\t') ;		/* pretty print */

		/* Open output file */
		i = creat(outfile, CMODE) ;
		if ( i < 0 ) {
			sprintf(line, "Can't create output file - %s.", outfile) ;
			abend(line) ;
			}
		close(i) ;
		outfp = fopen(outfile, "w") ;
		if ( outfp == NULL ) {
			sprintf(line, "Can't open output file - %s.", outfile) ;
			abend(line) ;
			}
		
		/* Read file text */
		lcnt = 0 ;
		nxtemline(line) ;
		while ( strcmp(fsep, line) ) {
			lcnt++ ;
			fputs(line, outfp) ;
			nxtemline(line) ;
			}
		fclose(outfp) ;

		printf("%d lines.\n", lcnt) ;
		}
	
	/* Delete capture file */
	i = unlink(CAPFILE) ;
	if ( i == 0 )
		puts("Capture file removed.") ;

	exit(0) ;
	}

nxtemline ( sptr )

char	*sptr ;

/* Get next input line from capture file.
*/

{
	register int	i ;


	i = fgets(sptr, 256, capfp) ;
	if ( i == NULL )
		abend("Premature end of capture file.") ;
	}



strip ( line )

char	*line ;

/* Strip 'newline' char(s) from input line.
*/

{
	register int	i ;
	register char	c ;


	i = strlen(line) ;
	i-- ;
	while ( (c = line[i]) == '\n' || c == '\r' )		/* while 'newline' */
		i-- ;
	i++ ;
	line[i] = '\0' ;		/* strip \n */
	}



abend ( msg )

char	*msg ;

/* Abnormal end */

{


	printf("%s: %s\n", PGMNAME, msg) ;
	exit( -1 ) ;
	}
