/*************************************************************************
*
*
*	Name:  intio.c
*
*	Description:  Integer i/o.
*
*					sfintio()	- Set up for i/o.
*					sfintdisp()	- Display integer.
*					sfintinp()	- Input integer.
*
*
*	History:
*	Date		By		Comments
*
*	03/23/84	waf
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

*/

#include	"/sform/src/sfint.h"


extern	int		sfintinp(), sfintdisp() ;


#define		INTSIZE	sizeof(int)	/* # bytes in an 'int' */

/* Global vars used for int i/o */
static	char	dtype ;			/* data type (radix) character */
static	char	inpfmt[16] ;	/* Input format string.
								   Converts number to string. */
static	int		sgnflag ;		/* flags signed numeric fields */
static	char	numchrs[] = {	/* legal numeric characters */
	"-1234567890"
} 
;
static	char	hexchrs[] = {	/* legal hexadecimal characters */
	"1234567890abcdefABCDEF"
} 
;

sfintio ( fld_desc, mode, data_ptr )

struct SF_FIELD *fld_desc ;
int		mode ;
int		*data_ptr ;

/*
  Synopsis -
	Integer (2 byte) i/o.

  Description -
	This fn does some set-up, then calls genio() to handle flow control
	and invocation of the display & input fn's.
	The printf() style format strings are created in this fn, and used by
	the intinp() and inpdisp() fn's.
	The input fmt is used to convert from numeric to string.

  Return -
	return val	= Completion code.

  Notes -
*/

{
	register int fc ;
	unsigned flag ;
	int		radix ;
	struct SF_FIELD tmp_desc ;	/* scratch field desc */
	struct SF_IFDATA *iodata ;	/* ptr to int field i/o data */
	char	*sptr, *dptr ;



	/* Get private version of fld desc */
	sptr = (char *) fld_desc ;
	dptr = (char *) &tmp_desc ;
	fc = sizeof(struct SF_FIELD) ;
	while ( fc-- != 0 )
		*dptr++ = *sptr++ ;
	fld_desc = &tmp_desc ;		/* change ptr */

	/* Get ptr to i/o data */
	iodata = (struct SF_IFDATA *) fld_desc->sf_iodata ;

	/* Set/reset certain bit flags in fld_desc,
		   so that string fn's can be used. */
	flag = iodata->sf_iflags ;	/* get flags */
	flag |= SF_BFILL ;		/* blank fill the numeric string data */
	flag &= ~SF_ANUM ;		/* reset alpha/num flags */
	flag |= SF_SPCHR ;		/* use special char set - */
	sf_spchr = numchrs ;	/*   numeric characters */
	iodata->sf_iflags == flag ;	/* set new flags */


	/** Create input fmt string **/
	radix = iodata->sf_iradix ;
	sgnflag = 0 ;		/* assume unsigned */
	switch ( radix ) {
		case 8 :
			dtype = 'o' ;
			break ;
		case 10 :
			if ( flag & SF_UNSGN )
				dtype = 'u' ;
			else {
				dtype = 'd' ;
				sgnflag = -1 ;		/* flag signed */
			}
			break ;
		case 16 :
			dtype = 'x' ;
			sf_spchr = hexchrs ;	/* allow hex chars */
			break ;
		default :
			sfpanic("Bad number radix - must be 8,10,16.") ;
	}
	sfprintf(inpfmt, "%%%c", dtype) ;


	/* Do i/o */
	fc = sfgenio(fld_desc, mode, data_ptr, INTSIZE, sfintinp, sfintdisp) ;

	/* Return completion code */
	return(fc) ;
}

sfintdisp ( fld_desc, data_ptr )

struct SF_FIELD *fld_desc ;
int		*data_ptr ;

/*
  Synopsis -
	Display an integer field.

  Description -
	This fn is called by genio(). 
	'data_ptr' points to binary data.

  Return -
	return val	= SF_OK.

  Notes -
*/

{
	register int fc ;		/* completion code */


	/* Show it */
	fc = sfflddisp(fld_desc, *data_ptr, dtype) ;

	return(fc) ;
}

sfintinp ( fld_desc, data_ptr )

struct SF_FIELD *fld_desc ;
int		*data_ptr ;

/*
  Synopsis -
	Integer field input.

  Description -
	The string input routine is used to input data into the tmp area.
	The sfscanf() fn is used to convert the input field. The fmt used for
	conversion is in the 'inpfmt' var, set up by intio().

  Return -
	return val	= Completion code.

  Notes -
  > The dedicated fn 'sfscanf()' is used instead of the standard scanf() fn.
  The sfscanf() function detects overflow and restricts the input to one field.
  > If the CLEAR FIELD fn is entered, the integer field is set to '0'.
*/

{
	register int fc ;		/* completion code */
	int		numval ;
	int		i ;
	struct SF_IFDATA *iodata ;	/* ptr to i/o data */
	int		errflg ;


	/* Get ptr to i/o data */
	iodata = (struct SF_IFDATA *) fld_desc->sf_iodata ;

	/* Use string routines to input the field */
	fc = sfstrinp(fld_desc, data_ptr) ;

	/* Chk the return code */
	if ( fc < 0 || fc == SF_ABORT )
		return(fc) ;
	if ( fc == SF_CLRFLD ) {
		/* 'clear' the field & return */
		*data_ptr = 0 ;
		return(fc) ;
	}
	if ( sf_nchars == 0 ) {
		/* no field input, don't change current data */
		return(fc) ;
	}

	/* Convert the input field */
	i = sfscanf(data_ptr, inpfmt, &numval) ;		/* try to convert it */

	/* Chk for error */
	if ( i <= 0  ) {
		/* conversion error */
		fmterr(i) ;				/* show error */
		return(SF_ERROR) ;		/* re-display field & retry */
	}

	/* Chk the range */
	errflg = 0 ;
	if ( sgnflag ) {
		/* signed range */
		if ( numval < iodata->sf_ilbnd
		    || numval > iodata->sf_iubnd )
			errflg = -1 ;
	}
	else {
		/* unsigned range */
		if ( (unsigned) numval < (unsigned) iodata->sf_ilbnd
		    || (unsigned) numval > (unsigned) iodata->sf_iubnd )
			errflg = -1 ;
	}
	if ( errflg ) {
		/* out of range */
		sferrmsg("Numeric value out of range.") ;
		return(SF_ERROR) ;		/* re-display field & retry */
	}

	/* Return numeric data */
	*data_ptr = numval ;

	/* Return completion code */
	return(fc) ;
}

static	fmterr ( errcode )

int		errcode ;

/* Report error from format routines.
   'code' = error code returned by sfprintf/sfscanf.
*/

{
	register char	*cp ;


	switch ( errcode ) {
		case  SF_FNOVF :
			cp = "Numeric overflow." ;
			break ;
		default :
			cp = "Numeric conversion error." ;
	}
	sferrmsg(cp) ;			/* Do not wait for 'Clear Error' */
}
