/*************************************************************************
*
*
*	Name:  genio.c
*
*	Description:  Generic field i/o.
*
*
*	History:
*	Date		By		Comments
*
*	03/23/84	waf
*	05/03/84	waf		Show blank field if Input mode.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

	5/21/84
	  Currently, the temporary space used to input data is static data
	memory. The code to allocate and de-allocate dynamic memory for this
	purpose is disabled.

*/

#include	"/sform/src/sfint.h"

#define		STATMEM		1		/* 1 = use static memory for input buffer
0 = use dynamic memory for input buffer */

int		sfclrfld ;				/* set if 'Clear Field' entered */
#if	STATMEM
static	char	inpbuf[129] ;
#endif



sfgenio ( fld_desc, mode, data_ptr, bsize, inpfn, dispfn )

struct SF_FIELD *fld_desc ;
int		mode ;
char	*data_ptr ;		/* ptr to type '?' binary data */
int		bsize ;			/* binary data size (in bytes) */
int		(*inpfn)(), (*dispfn)() ;	/* ptrs to input & display fn's */

/*
  Synopsis - Generic field i/o function.

  Description -
	This function is invoked by a type specific field i/o fn
	(i.e strio(), intio(), etc). It implements the flow control necessary to
	display/input/edit a given field. It also handles allocation of dynamic
	memory for scratch data. (The use of this fn will eliminate a lot of
	redundant code in each <type>io() fn).
	Upon return, data_ptr contains the (possibly) updated data.
	This fn will operate with any type of data, using bsize as the number
	of bytes to pass (in the scratch data area) to the type specific display
	& input fn's.

  Return -
	return val	= Completion code or Fn Key value -
				Valid completion codes are
				SF_ERROR	= non-recoverable error during data entry.
				SF_EDPROT	= tried to update a protected field.
				Valid Fn Key return values are
				SF_NXTFLD,SF_PRVFLD
				SF_NXTGRP,SF_PRVGRP
				SF_NXTWIN,SF_PRVWIN
				SF_ABORT
				SF_FINISH

  Notes -
	*> Note that this function should be exited via the 'exit' label.
	This code frees the allocated data space.
	> Note that the scratch data area created by this fn is used both to
	pass the binary data to & from the input & display fns, and as an input
	buffer for entering new fields. Numeric fns called by this fn must
	save the binary data while input is occurring.
	> The 'field width' and 'binary data size' are the same for string
	data, but are usually different for numeric data. The scratch data
	area is used to hold both field data & binary data, so it must be
	large enough for either one.
*/

{
	register int fc ;		/* return code from input fn */
	register int fwid ;		/* (Display) field width */
	char	*tmp_data ;
	unsigned datr, catr ;	/* display attribute word */
	unsigned flag ;			/* bit flags */
	unsigned asize ;
	char	*malloc() ;
	char	*cptr ;



	/* Get field width */
	fwid = fld_desc->sf_width ;

	/* Allocate scratch data area.
		   Use the larger of the field width and the binary data size
		   as the allocation size. Also add one extra byte for a trailing
		   null. */
	asize = (fwid > bsize)? fwid : bsize ;
#if	STATMEM
	tmp_data = inpbuf ;		/* ptr to input buffer */
#else
	tmp_data = malloc(asize + 1) ;
	if ( tmp_data == 0 )
		sfpanic("genio: malloc() error.") ;
#endif
	tmp_data[asize] = '\0' ;	/* null term the str data */

	/* Get display attribute word */
	datr = fld_desc->sf_iodata->sf_datr ;	/* attr word */

	/* Reset 'fld cleared flag */
	sfclrfld = 0 ;


again:
	/** Show current field **/

	/* If mode is Display or Edit,
		   move current field data into tmp_data (for fld display).
		   Append a null (for string data).
		   Note - move is postponed until after the field display if
		   mode is 'input only' */
	if ( mode != SF_INPUT )
		sftmpcpy(tmp_data, data_ptr, bsize) ;
	tmp_data[bsize] = '\0' ;		/* append null */
	if ( mode == SF_INPUT ) {
		/* Input only field.
				   Blank fill the current field data so that
				   'empty' field is displayed. */
		cptr = tmp_data ;
		for ( fc = 0 ; fc < asize ; fc++ )
			*cptr++ = ' ' ;			/* blank fill */
	}

	/* Set display attributes */
	if ( mode == SF_DISPLAY )
		catr = datr ;					/* use normal display attr */
	else
		catr = datr ^ sf_inatros ;		/* use input mask attr */
	sfsetdatr(catr) ;	/* set display attr */

	/* display the field */
	if ( mode == SF_INPUT )
		sfflddisp(fld_desc, tmp_data, 's') ;	/* display blank field */
	else
		(*dispfn)(fld_desc, tmp_data) ;		/* display the data */

	/* If input only field, move current fld data
		   into tmp_data now. */
	if ( mode == SF_INPUT )
		sftmpcpy(tmp_data, data_ptr, bsize) ;


	/* Chk for display only field */
	if ( mode == SF_DISPLAY ) {
		/* display only field */
		fc = SF_NXTFLD ;	/* display next field */
		goto xit ;
	}

	/* Chk for protected field */
	flag = fld_desc->sf_iodata->sf_flags ;	/* bit flags */
	if ( flag & SF_PROTFLD ) {
		fc = SF_EDPROT ;	/* wrong mode for protected field */
		goto xit ;
	}


	/* Do input fn */
	fc = (*inpfn)(fld_desc, tmp_data) ;

	/* Process completion code */
	if ( fc < 0 || fc == SF_ABORT ) {		/* error condition */

		/* Process error */
		if ( fc == SF_RETRY ) {
			/* non-fatal error in input.
						   Re-display orig fld & try again. */
			goto again ;
		}
		/* fatal error */
		if ( fc == SF_ERROR ) {
			/* entry error - call user error handler.
						   If user returns SF_OK, try again. */
			fc = (*sf_usrerr)(fld_desc, data_ptr) ;
			sfclrerm() ;		/* clear error message */
			if ( fc == SF_OK )
				goto again ;	/* try again */
		}
	}

	else {

		/* Chk for 'disallowed' fn keys */
		if ( fc == SF_NXTENM || fc == SF_PRVENM ) {
			sfbeep() ;
			goto again ;
		}

		/* Update data */
		if ( sf_nchars != 0 		/* if new data was entered */
		|| fc == SF_CLRFLD ) {	/*   or field was cleared */
			/* move new data into data_ptr */
			sftmpcpy(data_ptr, tmp_data, bsize) ;
			if ( fc == SF_CLRFLD ) {
				/* Field was cleared by input fn.
								   Re-edit the cleared field. */
				sfclrfld = -1 ;		/* flag fld cleared */
				goto again ;
			}
		}
	}


	/* Reset display characteristics
		   and re-display the (possibly updated) fld.
		   Note - tmp_data must be used, since it is 
		   guaranteed null terminated. */
	sfsetdatr(datr) ;		/* set fld display attr's */
	sftmpcpy(tmp_data, data_ptr, bsize) ;	/* move data into tmp_data */
	(*dispfn)(fld_desc, tmp_data) ;		/* show it */


xit:
	/* Free the dynamic memory */
#if	(STATMEM == 0)
	free(tmp_data) ;
#endif

	/* return the completion code */
	return(fc) ;
}

sftmpcpy ( dst, src, n )

char	*dst, *src ;
int		n ;

/* Move n chars from src to dst.
   This is a 'dumb' move. The data areas are not checked for overlap.
*/

{
	register char	*dptr, *cptr ;


	dptr = dst ;
	cptr = src ;

	while ( n-- > 0 )
		*dptr++ = *cptr++ ;
}



sf_nulerr ()

/* This is a dummy fn to simulate a user error fn.
   If sf_usrerr is not set by the user, this fn is called when an
   error occurs during input.
   The user must enter the 'Clear Error' fn key before continuing.
*/
{


	sferrwait() ;
	sfclrerm() ;

	return(SF_OK) ;
}
