/*************************************************************************
*
*
*	Name:  winio.c
*
*	Description:  User entry SForm functions.
*					sfwinio()	- Window i/o.
*					sffldio()	- Individual field i/o.
*					sfwfdio()	- Individual field i/o.
*
*
*	History:
*	Date		By		Comments
*
*	03/16/84	waf
*	06/08/84	waf		**  Rev. 2.0  **
*	07/02/84	waf		M000 - Allow fld wrapping.
*
*
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*  This document contains confidential/proprietary information.
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -
*/

#include	"/sform/src/sfint.h"


static	struct SF_FIELD *fld_desc ;	/* ptr to fld desc */
static	unsigned flags ;			/* bit flags */




sfwinio ( window, fld_num, mode )
struct SF_WINDOW *window ;	/* window structure */
int		*fld_num ;			/* entry - starting field number
							   return - ending field number */
int		mode ;				/* SF_DISPLAY / SF_INPUT / SF_EDIT */
/*
  Synopsis -
	Perform window i/o, starting with field '*fld_num' and continueing
	until all fields have been processed or one of certain completion codes
	is returned.

  Description -
	This function will perform i/o on multiple fields within a given
	window. It is presumed that sfopen() has already been run (at some
	time) for this window.

	The modes are -
		SF_DISPLAY	- Display all fields in window & return.
		SF_INPUT	- Input fields without displaying current values.
		SF_EDIT		- Display current value of field, then input new value.
					  (The value is unchanged if no new value is input).
		SF_LABELS	- Display all the string literal ('label') fields only.
	In DISPLAY mode, all fields are displayed.
	In INPUT and EDIT modes, all fields are displayed (if EDIT), and all data
	(e.g. non-label) fields are input. Trying to input into a protected field
	(SF_PROTFLD flag set) returns a SF_EDPROT error. All SF_LABFLD fields are
	skipped.
	In LABELS mode, only label fields are displayed.
    Note that the mode arg contains bit flags. In particular, SF_DISPLAY and
	SF_LABELS could be combined to display both types in one sfwinio() call.
    The sfinit() fn will be automatically invoked if necessary.
	If the sf_fwrap flag in the window desc is set, the window will 'wrap'
	from the last fld to the first fld and vica-versa.

  Return -
	return val	= Completion code (see sform.h).
	*fld_num	= Field # of last field edited.
	sf_fldmod	= -1 if no fld was modified by the user,
				  else sf_fldmod = the fld# of the last fld modified.

  Notes -
  > Note that label (prompt) flds are displayed ONLY if the SF_LABELS bit
  flag is set in the mode.
*/
{
	register int fld ;		/* current field number */
	register int sfc ;		/* completion code */
	int		flg ;
	int		lflg, dflg ;
	int		fwrap ;
	int		eflg ;

	/* Chk for new window */
	if (sf_curwin != window) {

		/* Get highest field # in this window.
		   This code assumes that the fld list is terminated by a 'null'
		   field desc, which is flagged by a field width of '-1' */
		sf_hifld = 0 ;
		while ((*window->sf_fldlist)[sf_hifld].sf_width != -1)
			sf_hifld++ ;
		sf_hifld-- ;				/* fld # of last field */
		sf_curwin = window ;		/* make this win the current window */
	}

	/* Initialize */
	fld = *fld_num ;				/* starting field # */
	fwrap = window->sf_fwrap ;		/* fld wrap flag */
	sfc = SF_NXTFLD ;				/* initial motion is fwd fld */
	sf_fldmod = -1 ;				/* flag 'no flds modified' */

	/* Get mode flags */
	lflg = mode & SF_LABELS ;
	dflg = (mode & SF_DISPLAY) | (mode & SF_EDIT) ;
	eflg = (mode & SF_EDIT) | (mode & SF_INPUT) ;


	/* Process fields */
	for (;;) {
		if ((fld < 0) || (fld > sf_hifld)) {
			/* Fld # is out of range */
			if ((fwrap == 0) || (eflg == 0))
				/* M000 - don't wrap */
				break ;
			/* M000 - Wrap fld */
			if (fld < 0)
				fld = prevfld(window, sf_hifld+1) ;		/* wrap to last fld */
			else
				fld = 0 ;								/* wrap to first fld */
		}

		/* Get fld_desc & flags for this fld */
		getfd(window, fld) ;

		/* Chk fld type (label/data).
		   If label, skip it unless mode is SF_LABELS.
		   If data, skip it unless mode is SF_DISPLAY or SF_EDIT. */
		flg = 0 ;					/* skip flag */
		if (flags & SF_LABFLD) {
			/* Label (prompt) field */
			if (lflg == 0)
				flg-- ;				/* skip this fld */
		}
		else {
			/* Data field */
			if (dflg == 0)
				flg-- ;				/* skip this fld */
		}
		if (flg) {
			/* skip this fld */
			fld++ ;
			continue ;
		}

		/* do field i/o */
		sfc = sfdofld(fld_desc, mode, fld_desc->sf_bindata) ;

		/* Chk for modified fld */
		if (st_mdt)
			sf_fldmod = fld ;		/* flag with fld # mod'ed */

		/* Chk completion code.
		   Return code to user if not recognized. */
		switch (sfc) {
			case  SF_NXTFLD :
			case  SF_PRVFLD :
			case  SF_NXTGRP :
			case  SF_PRVGRP :
				break ;				/* select to next fld */
			default :
				goto xit ;			/* return code to user */
		}


		/* Select next field */
		if (mode == SF_DISPLAY)
			fld++ ;		/* display next field */
		else {

			/* use 'sfc' code to select next field */
			switch (sfc) {

				case SF_NXTFLD :	/* next field */
					fld++ ;
					break ;

				case SF_PRVFLD :	/* prev field */
					fld = prevfld(window, fld) ;
					break ;

				case SF_NXTGRP :	/* next group */
					/* get 1st fld in next group */
					fld = sfnxtgrp(window, fld) ;
					/* adjust the 'motion' flag */
					sfc = SF_NXTFLD ;	/* use fwd fld motion */
					break ;

				case SF_PRVGRP :	/* prev group */
					/* get 1st fld in last group */
					fld = sfprvgrp(window, fld) ;
					/* adjust the 'motion' flag */
					sfc = SF_NXTFLD ;	/* use fwd fld motion */
					break ;
			}
		}
	}	/* end fld loop */


xit:
	/* Return to user pgm */
	*fld_num = fld ;		/* return last field */
	return(sfc) ;			/* return last completion code */
}



static	getfd ( window, fld )
struct SF_WINDOW *window ;
int		fld ;
/*
  Set up global vars 'fld_desc' and 'flags' for field # 'fld' in 'window'.
*/
{

	fld_desc = &((*window->sf_fldlist)[fld]) ;	/* fld desc ptr */
	flags = fld_desc->sf_iodata->sf_flags ;	/* bit flags */
}



static	prevfld ( win, fldnum )
struct SF_WINDOW	*win ;
int					fldnum ;
/*
  Backup to previous fld.
  The fld# of the first previous fld which can be edited is returned.
  Note - returned fld may be -1.
*/
{

	while (--fldnum >= 0) {
		getfd(win, fldnum) ;
		if ((flags & SF_LABFLD) || (flags & SF_PROTFLD))
			continue ;				/* skip this fld */
		/* Stop here */
		break ;
	}
	return(fldnum) ;
}

sffldio ( fld_desc, mode )
struct SF_FIELD	*fld_desc ;
int				mode ;
/*
  Synopsis -
	User entry point for field level i/o.

  Description -
	The sfinit() fn is invoked automatically, if necessary.

  Return -
	return val	= completion code (see sform.h).
	sf_fldmod	= 0 if fld modified by user.
				  -1 if fld not modified by user.

  Notes -
*/

{
	register int	sfc ;

	sfc = sfdofld(fld_desc, mode, fld_desc->sf_bindata) ;

	/* Chk for fld modified */
	if (st_mdt)
		sf_fldmod = 0 ;
	else
		sf_fldmod = -1 ;

	return(sfc) ;
}



sfwfdio ( win, fldnum, mode )
struct SF_WINDOW	*win ;
int					fldnum ;
int					mode ;
/*
  Same as sffldio(), but input args are window ptr & fld # instead
  of fld_desc ptr.
*/
{

	getfd(win, fldnum) ;
	return(sffldio(fld_desc, mode)) ;
}
