/* Device dependant i/o routines for use by SFORM on DG crt's on ALTOS

06/18/84	waf	M000	Flipped ERSEOF & FLDFMT fn key assignments.
06/19/84	waf			Changed Rubout device key code.
06/19/84	waf	M001	Flipped HELP & CLRERR fn key assignments.

*/
#include <sgtty.h>
#include <stdio.h>
#include "sform.h"

typedef int MAP[17];
static struct sgttyb oldmode, newmode;
int st_bottom = 23;

/* The attribute map consists of the max attribute value followed by the
   data values to be used for each attribute.  The first value will be used
   whenever the requested attribute exceeds the maximum. */
#define NORMAL  0
#define BLINK   1
#define USCORE  2
#define DIM     4
#define REVERSE 8
static MAP dgattrs = { 16,
   NORMAL,			/* Always considered "NORMAL" attribute */
   DIM,				/* Literal type 1 */
   REVERSE,			/* Literal type 2 */
   DIM | REVERSE,		/* Literal type 3 */
   NORMAL,			/* Display type 1 */
   DIM | USCORE,		/* Display type 2 */
   NORMAL,			/* Display type 3 */
   DIM | REVERSE,		/* Display type 4 */
   BLINK,			/* Attention (Blink) type */
   USCORE,			/* Literal type 4 */
   REVERSE,			/* Literal type 5 */
   NORMAL,			/* Literal type 6 */
   USCORE,			/* Input type 1 */
   USCORE,			/* Input type 2 */
   DIM | REVERSE,		/* Input type 3 */
   NORMAL			/* Input type 4 */
};
MAP *st_attrs = &dgattrs;
static int curattr = 0;

MAP *st_curtypes = 0;

/* The key translation table is an array of integer pairs, the first int is
   the device key code (>= 32 is assumed to be a function key), and the SF
   code to be returned. The last entry is indicated by the first int = -1.
   All untranslated special codes are converted to the second int. */
struct KYTRN { int keycode, sfcode; };
static struct KYTRN kytrn[] = {
   {  0177, SF_RUBOUT },
/* {   025, SF_CLRFLD }, */
   {   031, SF_CLEFT  },
   {   030, SF_CRIGHT },
   {   015, SF_ENTER  },
   {   012, SF_ENTER  },
   {   004, SF_EOF    },
   {   011, SF_NXTFLD },

   {   'q', SF_NXTFLD },
   {   'r', SF_NXTGRP },
   {   's', SF_NXTWIN },
   {   't', SF_NXTENM },
   {   'u', SF_ERSEOF },		/* M000 */
   {   'v', SF_RSTFLD },
   {   'w', SF_CLRERR },		/* M001 */
   {   'x', SF_FINISH },
   {   'y', SF_F9     },
   {   'z', SF_F10    },
   {   '{', SF_F11    },
   {   '~', SF_RSTWIN },
   {   'p', SF_INSERT },		/* <Alt> g */

   {   'a', SF_PRVFLD },
   {   'b', SF_PRVGRP },
   {   'c', SF_PRVWIN },
   {   'd', SF_PRVENM },
   {   'e', SF_FLDFMT },		/* M000 */
   {   'f', SF_RSTWIN },
   {   'g', SF_HELP   },		/* M001 */
   {   'h', SF_ABORT  },
   {   'i', SF_SF9    },
   {   'j', SF_SF10   },
   {   'k', SF_SF11   },
   {  0140, SF_DELCHR },		/* <Alt> t */

   {    -1, SF_INVALID }
};
struct KYTRN *st_kytrn = &kytrn[0];

struct ATRS { unsigned amask; char *ons, *offs; };
static struct ATRS atrs[] = {
   {   BLINK,  "\016",  "\017" },
   {  USCORE,  "\024",  "\025" },
   {     DIM,  "\034",  "\035" },
   { REVERSE, "\036D", "\036E" },
   {       0,       0,       0 }
};


/* Initialize the terminal for use by these routines.
   Also setup some global variables that user may later change.
*/
stinit()
{

/* Save current device characteristics */
   ioctl(0, TIOCGETP, &oldmode) ;

/* Set new characteristics to allow single character I/O */
   ioctl(0, TIOCGETP, &newmode);
   newmode.sg_flags |= CBREAK ;	
   newmode.sg_flags &= ~ECHO ;
   ioctl(0, TIOCSETP, &newmode) ;

   st_attrs = &dgattrs;
   st_curtypes = 0;
   st_kytrn = &kytrn[0];
   st_bottom = 23;
   curattr = 0;
   stputc(023);
}

/* Reset terminal characteristics back to their default
*/
stterm()
{
/* Reset to roll mode */
   stputc(022);

/* Reset characteristics */
   ioctl(0, TIOCSETP, &oldmode) ;
}

/* Put a character at the current cursor position using the current attribute
*/
stputc(c)
char c;
{
   putchar(c);
}

/* Put a string (null terminated) of characters
*/
stputs(s)
char *s;
{
   char c;
   while ((c = *s++) != 0) putchar(c);
}

/* Put a string in a field at the specified position with specified attributes.
*/
stputf(row, col, width, attr, str)
int row, col, width, attr;
char *str;
{
   int l;

   l = strlen(str);
/* When width is zero, use the current string length as the width */
   if (width == 0) width = l;

/* If the string is longer than the field width, ignore the extra */
   if (l > width) l = width;

/* Compute the number of spaces to display after the string */
   width -= l;

/* Now that we have computed all this junk, lets actually do it */
   stscp(row,col); stsatr(attr);
   while (l-- > 0) stputc(*str++);
   while (width-- > 0) stputc(' ');
}

/* Get a character from the keyboard and translate to SF codes as necessary.
   Return values are 0 <= c <= 255 for ordinary characters and > 255 for
   translated special functions, or EOF for end-of-file, or SF_INVALID when
   we have no idea.
*/
int stgetc()
{
   int c;
   struct KYTRN *ky;
    
/* Get a character and return it if it is not a control or function key */
   if ((c = getchar()) == EOF) return (SF_EOF);
   if (c >= ' ' && c <= 0176) return (c);

/* If it is a DG function key lead-in, get the function key character */
   if (c == 036) c = getchar();

/* Now, look the key up in the translation table */
   for (ky = st_kytrn; ky->keycode >= 0; ky++)
      if (ky->keycode == c) break;
   return (ky->sfcode);
}

/* Set cursor position
*/
stscp(r,c)
int r, c;
{
   int rflag, cflag;
#define UP    027
#define DOWN  032
#define LEFT  031
#define RIGHT 030

/* Force row and column in range */
   r = r % 24;
   c = c % 80;

/* Check for row values XENIX can't handle */
   if (r == 0 || r == 4 || r == 10 || r == 13) {
      r++; rflag = UP;
   } else if (r == 9) {
      r--; rflag = DOWN;
   } else {
      rflag = 0;
   }

/* Check for column values XENIX can't handle */
   if (c == 0 || c == 4 || c == 10 || c == 13) {
      c++; cflag = LEFT;
   } else if (c == 9) {
      c--; cflag = RIGHT;
   } else {
      cflag = 0;
   }

/* Now position to the modified location */
   stputc(020); stputc(c); stputc(r);

/* And adjust if necessary */
   if (rflag) stputc(rflag);
   if (cflag) stputc(cflag);
}

/* Map attribute into internal value
*/
static unsigned mapattr(attr)
int attr;
{
   if (attr >= (*st_attrs)[0]) attr %= (*st_attrs)[0];
   return ((*st_attrs)[attr+1]);
}

/* Set current attribute using map
*/
stsatr(attr)
int attr;
{
   struct ATRS *atrp;
   unsigned mask, newattr;

   newattr = mapattr(attr);
   for (atrp = &atrs[0]; (mask = atrp->amask) != 0; atrp++)
      if ((newattr & mask) != (curattr & mask)) {
	 if ((newattr & mask) != 0) stputs(atrp->ons);
	 else stputs(atrp->offs);
      }
   curattr = newattr;
}

/* Output a bell/beep of type beep
*/
stbeep(beep)
{
/* They all sound the same on DG */
   stputc(007);
}

/* Clear a window on the screen
*/
stclw(top, bottom, left, right, attr)
int top, bottom, left, right, attr;
{
   int row, col;

   if (mapattr(attr) == 0 && right == 79) {
      if (left == 0 && top == 0 && bottom == 23) {
	 stputc(014);
	 curattr = 0;
      } else {
	 for (row = top; row <= bottom; row++) {
	    stscp(row,left);
	    stputc(013);
	 }
      }
   } else {
      for (row = top; row <= bottom; row++) {
	 stsatr(attr);
	 stscp(row,left);
	 for (col = left; col <= right; col++)
	    stputc(' ');
      }
   }
   stscp(top,left);
}

/* Clear the whole screen
*/
stcls(attr)
{
   stclw(0,23,0,79,attr);
}

/* Set the cursor type (if possible)
*/
stsct(curtype)
{
/* Can't on a 6053 */
}
