/*************************************************************************
*
*
*	Name:  query.c
*
*	Description:  Implement queries on the status line.
*					sfmsgio()	- Status/Error line query w/ fld desc's.
*					sfquery()	- Status/Error line query w/ strings.
*
*
*	History:
*	Date		By		Comments
*
*	06/28/84	waf
*
*
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*  This document contains confidential/proprietary information.
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

  Unless the pgmr needs a non-string response, the sfquery() fn will be
  easier to use (sfmsgio() requires fld desc's for args).

  Note that row position info in the fld desc's is overridden by sfmsgio().

*/

#include	"/sform/src/sfint.h"



sfmsgio ( prmpt_desc, answ_desc )
struct SF_FIELD	*prmpt_desc, *answ_desc ;
/*
  Synopsis -
	Perform i/o on the status line.
	This call is used to prompt the user for info during window i/o.
	Note that this call uses fld desc's, so any type of i/o can be performed.
  Description -
	The i/o is forced to occur on the status line.
	Errors are ignored as much as possible.
	Note that this function is 'roll your own'. The desc's must be set up
	with good info. Use sfquery() for a simple string query.
  Return -
	Return value	= SF_OK if no error, else error code.
*/
{
	int			sfc ;
	char		*prmpt_data ;
	extern int	sfmioflg ;


	/* Disable user error msg's */
	sfmioflg = 1 ;

	/* Force i/o to occur on status line */
	prmpt_desc->sf_row = answ_desc->sf_row = SF_ERRROW ;

	/* Show prompt */
	sfdofld(prmpt_desc, SF_DISPLAY, prmpt_desc->sf_bindata) ;

	/* Get response */
	sfc = sfdofld(answ_desc, SF_EDIT, answ_desc->sf_bindata) ;

	/* Enable user error msg's */
	sfmioflg = 0 ;

	/* Return comp code */
	if (sfc >= 0)
		sfc = SF_OK ;
	return(sfc) ;
}

/* Define string io data desc */
static struct SF_IODATA		miodata = {
	sfstrio,			/* i/o fn */
	SF_DSP1,			/* display attr */
	0,					/* flags */
	} ;



sfquery ( prmpt_str, answ_str, astrsiz )
char	*prmpt_str, *answ_str ;
int		astrsiz ;		/* max size of answer string */
/*
  Synopsis -
	Perform i/o on the status line.
	This call is used to prompt the user for info during window i/o.
	Note that the flds are type string.
	Note that the answ_str is displayed before editing. This allows
	'default' responses. The user pgm must null the string if necessary.
  Description -
	Fld desc's are created for the 2 strings, then sfmsgio() is invoked.
	Note that astrsiz defines the size of the response string. The string
	buffer in the usr pgm MUST be at least this big.
  Return -
	Return value	= Comp code from sfmsgio().
*/
{
	struct SF_FIELD	prmpt_desc, answ_desc ;
	int				prmptsiz ;
	int				sfc ;
	

	/** Set up desc's **/
	/* Pos */
	prmpt_desc.sf_row = answ_desc.sf_row = SF_ERRROW ;
	prmpt_desc.sf_col = 0 ;
	prmptsiz = strlen(prmpt_str) ;
	answ_desc.sf_col = prmptsiz + 2 ;
	/* Size */
	prmpt_desc.sf_width = prmptsiz ;
	answ_desc.sf_width = astrsiz ;
	/* I/O data desc */
	prmpt_desc.sf_iodata = answ_desc.sf_iodata = &miodata ;
	/* Binary data ptr */
	prmpt_desc.sf_bindata = (union SF_BINDATA *) prmpt_str ;
	answ_desc.sf_bindata = (union SF_BINDATA *) answ_str ;

	/* Do the i/o */
	sfc = sfmsgio(&prmpt_desc, &answ_desc) ;
	return(sfc) ;
}
