/*************************************************************************
*
*
*	Name:  intio.c
*
*	Description:  Integer (1, 2, 4 byte) i/o.
*					sfbintio()	- Short (1 byte) integer i/o.
*					sfintio()	- Normal (2 byte) integer i/o.
*					sflintio()	- Long (4 byte) integer i/o.
*
*
*	History:
*	Date		By		Comments
*
*	03/23/84	waf
*	06/13/84	waf		**  Rev. 2.0  **
*
*
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*  This document contains confidential/proprietary information.
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

  Long integers can not be unsigned (due to 'c' limitations on longs).

*/

#include	"/sform/src/sfint.h"
#include	<ctype.h>



sfintio ( fld_desc, mode, data_ptr, tmp_data )
struct SF_FIELD *fld_desc ;
int		mode ;
int		*data_ptr ;
char	*tmp_data ;
/*
  Normal (2 byte) integer i/o.
*/
{

	return(sfgintio(fld_desc, mode, data_ptr, tmp_data, 2)) ;
}



sflintio ( fld_desc, mode, data_ptr, tmp_data )
struct SF_FIELD *fld_desc ;
int		mode ;
int		*data_ptr ;
char	*tmp_data ;
/*
  Long (4 byte) integer i/o.
*/
{

	return(sfgintio(fld_desc, mode, data_ptr, tmp_data, 4)) ;
}



sfbintio ( fld_desc, mode, data_ptr, tmp_data )
struct SF_FIELD *fld_desc ;
int		mode ;
int		*data_ptr ;
char	*tmp_data ;
/*
  Short (1 byte) integer i/o.
*/
{

	return(sfgintio(fld_desc, mode, data_ptr, tmp_data, 1)) ;
}

sfgintio ( fld_desc, mode, data_ptr, tmp_data, isize )
struct SF_FIELD *fld_desc ;
int		mode ;
char	*data_ptr ;
char	*tmp_data ;
int		isize ;				/* integer size (1/2/4) */
/*
  Synopsis -
	Integer (long, normal, & short) i/o.

  Description -

  Return -
	return val	= Completion code.

  Notes -
*/
{
	int					sfc ;
	int					radix ;
	long				ubnd, lbnd ;
	int					ce ;
	struct SF_LFDATA	*liodata ;
	struct SF_IFDATA	*niodata ;
	struct SF_BFDATA	*biodata ;
	int					unsflg ;
	long				*lptr ;
	int					*iptr ;
	char				*bptr ;
	long				rslt ;
	int					flags ;
	int					fwid ;
	long				tl, tlm ;
	long				orgval ;
	unsigned			mskwd ;
	long				sfmask() ;


	/** Get numeric info **/
	/* Get some info from iodata struct */
	if (isize == 1) {
		/* 1 byte int */
		biodata = (struct SF_BFDATA *) fld_desc->sf_iodata ;
		radix = biodata->sf_bradix ;
		ubnd = (long) biodata->sf_bubnd ;
		lbnd = (long) biodata->sf_blbnd ;
		mskwd = biodata->sf_bmask ;
	} else if (isize == 2) {
		/* 2 byte int */
		niodata = (struct SF_IFDATA *) fld_desc->sf_iodata ;
		radix = niodata->sf_iradix ;
		ubnd = (long) niodata->sf_iubnd ;
		lbnd = (long) niodata->sf_ilbnd ;
		mskwd = niodata->sf_imask ;
	} else {
		/* 4 byte int */
		liodata = (struct SF_LFDATA *) fld_desc->sf_iodata ;
		radix = liodata->sf_lradix ;
		ubnd = liodata->sf_lubnd ;
		lbnd = liodata->sf_llbnd ;
		mskwd = liodata->sf_lmask ;
	}

	/* Get other info */
	flags = fld_desc->sf_iodata->sf_flags ;
	fwid = fld_desc->sf_width ;
	/* signed/unsigned */
	if (flags & SF_UNSGN)
		unsflg = 1 ;
	else
		unsflg = 0 ;
	if (radix != 10)
		unsflg = 1 ;			/* always unsigned if not dec */
	/* Get type specific data ptr */
	iptr = (int *) data_ptr ;
	bptr = (char *) data_ptr ;
	lptr = (long *) data_ptr ;
	/* Get type specific masks */
	if (isize == 1)
		tlm = 0xffL ;
	else if (isize == 2)
		tlm = 0xffffL ;
	else
		tlm = 0xffffffff ;
	

	/** Convert binary data to string **/
	/* Get long binary value */
	if (isize == 1) {
		/* Get short val */
		rslt = (long) *bptr ;
	} else if (isize == 2) {
		/* Get int val */
		rslt = (long) *iptr ;
	} else
		/* Get long val */
		rslt = *lptr ;
	if (unsflg)
		rslt &= tlm ;

	/* Save the orig value */
	orgval = rslt ;

	/* Convert binary to string */
	ce = sfntoa(rslt, radix, unsflg, tmp_data, fwid) ;
	if (ce < 0)
		strcpy(tmp_data, "?") ;		/* conversion error */
	

again:
	/** Do i/o on str **/
	sfc = sfgenio(fld_desc, mode, tmp_data) ;
	if (sfc < 0)
		return(sfc) ;				/* return error code */


	/* Chk comp code */
	if (sfc < SF_CB2) {
		/* Process special codes */
		switch (sfc) {
			case  SF_FLDFMT :
				/* Show fld format */
				intfmt(fwid, isize, flags, mskwd) ;
				goto again ;
			case  SF_NXTENM :
			case  SF_PRVENM :
				/* Not valid here */
				sfbeep() ;
				goto again ;
			default :
				/* Let caller handle it */
				return(sfc) ;
		}
	}


	/** Chk for fld modified **/
	if (st_mdt == 0)
		return(sfc) ;			/* no change */
	

	/** Fld was modified **/
	/* Convert user input to number */
	ce = sfaton(tmp_data, radix, unsflg, &rslt) ;
	if (ce) {
		(*sf_usrerr)(ce) ;		/* report error */
		goto again ;			/* try again */
	}
	if (isize != 4) {
		/* Chk for number too big */
		if (rslt & ~tlm)
			if ((rslt | tlm) != -1L) {
				/* Too big */
				(*sf_usrerr)(SF_ENOVF) ;
				goto again ;
			}
	}

	/* Chk range.
	   Note - unsigned longs not supported. */
	tl = rslt ;
	if (unsflg) {
		/* adjust for unsigned int comparison */
		tl &= tlm ;
		ubnd &= tlm ;
		lbnd &= tlm ;
	}
	if ((tl > ubnd) || (tl < lbnd)) {
		(*sf_usrerr)(SF_ENRNG) ;		/* out of range */
		goto again ;
	}

	/* Update binary data */
	rslt = sfmask(orgval, rslt, mskwd) ;	/* mask the result */
	if (isize == 1)
		*bptr = rslt ;
	else if (isize == 2)
		*iptr = (int) rslt ;
	else
		*lptr = rslt ;
	
	return(sfc) ;
}

sfntoa ( value, radix, unsgn, rstr, ssize )
long	value ;				/* input value */
int		radix ;				/* conversion radix */
int		unsgn ;				/* 1 = unsigned result / 0 = signed result */
char	rstr[] ;			/* result str */
int		ssize ;				/* size of result string buf */
/*
  Convert number to string.
  Input number is of type 'long integer'.
  The radix arg determines the output base.
  Note - Unsigned longs are not supported.

  Return -
	return value	= SForm user conversion error code if error, else 0.
	rstr			= String representaion of number.
*/
{
	char	tmpbuf[16] ;
	int		bp, sp ;
	int		sgnflg ;
	int		digit ;


	/* Chk for input == 0 */
	if (value == 0L) {
		strcpy(rstr, "0") ;
		return(0) ;
	}

	/* Get sign of result.
	   Note that unsigned long is not supported,
	   and that octal and hex radix implies unsigned */
	sgnflg = 0 ;					/* assume no sign */
	if ((unsgn == 0) && (radix == 10)) {
		/* Signed number, chk sign */
		if (value < 0L) {
			sgnflg = -1 ;			/* set sign flag */
			value = -(value) ;
		}
	}

	/* Init buf ptr */
	bp = 0 ;

	/* Get str digits */
	while (value) {
		digit = shft(&value, radix) ;		/* shift out next digit */
		tmpbuf[bp++] = (char) digit ;		/* add next digit to buf */
		if (bp == ssize)
			return(SF_ENOVF) ;				/* number too big for string */
	}

	/* Transpose tmpbuf into result string */
	sp = 0 ;
	/* Chk sign */
	if (sgnflg)
		rstr[sp++] = '-' ;
	/* Transpose digits */
	while (--bp >= 0)
		rstr[sp++] = tmpbuf[bp] ;
	rstr[sp] = '\0' ;				/* term result str */

	return(0) ;
}



static	shft ( value, radix )
long	*value ;
int		radix ;
/*
  Shift the long value to the right, by the radix.
  Return the char value of the digit shifted out.
*/
{
	int		digit ;
	long	val ;

	val = *value ;
	switch (radix) {
		case  2 :
			/* Binary */
			digit = ((int) val) & 01 ;
			val >>= 1 ;
			break ;
		case  8 :
			/* Octal */
			digit = ((int) val) & 07 ;
			val >>= 3 ;
			break ;
		case  16 :
			/* Hex */
			digit = ((int) val) & 0xf ;
			val >>= 4 ;
			break ;
		default :
			/* Decimal */
			/* Note - unsigned long not supported */
			digit = val % 10 ;
			val /= 10 ;
	}
	val &= 0x7fffffff ;				/* for non-dec vals w/ hi bit set */

	/* Update value */
	*value = val ;

	/* Convert digit to char */
	if (digit > 9)
		digit += 55 ;
	else
		digit += 0x30 ;
	
	return(digit) ;
}



sfitoa ( ival, str )
int		ival ;
char	*str ;
/*
  Convert int val to string.
  If error, return "?".
  Used internally by sform.
*/
{
	register int	rv ;

	rv = sfntoa((long) ival, 10, 0, str, 7) ;
	if (rv < 0)
		strcpy(str, "?") ;
}

sfapton ( str, radix, unsflg, rptr )
char	**str ;			/* ptr to addr of source str */
int		radix ;
int		unsflg ;		/* set = unsigned input */
long	*rptr ;			/* ptr to long result */
/*
  Convert a string into a 'number'.
  The number returned is of type 'long integer'.
  Note that, upon successful return, the str ptr is updated to point to
  the next char after the scanned number. Scanning stops at the first
  illegal character, or end of string. Note that sfaton() should be used
  if caller wants to stop only at end of string.
  The radix arg determines the conversion radix.
  Leading and trailing spaces allowed, but no imbedded spaces and no
  chars except radix digits allowed. Note that 'space' means ' ' only,
  NOT whitespace.
  One leading sign char allowed.
  Note that null input converts to '0'.
  Note that unsigned longs are not supported (e.g. hi bit can not be set).

  Return -
	return value	= SForm user conversion error code if error, else 0.
	*rptr			= converted result (if successful).
*/
{
	register char	*cp ;
	register char	c ;
	long	rslt ;
	int		sgn ;
	int		digit ;
	int		oflg ;
	unsigned h ;


	/* Skip leading spaces */
	cp = *str ;					/* src str ptr */
	while (*cp == ' ')
		cp++ ;
	
	/* Chk for sign */
	sgn = 0 ;					/* assume none */
	c = *cp ;
	if ((c == '+') || (c == '-')) {
		if (c == '-') {
			if (unsflg)			/* unsigned number */
				return(SF_ENCNV) ;
			sgn = -1 ;			/* flag 'signed number' */
		}
		cp++ ;					/* skip sign char */
	}


	/** Get number **/
	rslt = 0 ;
	while (c = *cp) {

		/* Chk for trailing spaces */
		if (c == ' ') {
			/* skip trailing spaces */
			cp++ ;
			while (*cp == ' ')
				cp++ ;
			goto xit ;				/* exit loop */
		}
	
		/* Get next digit */
		if (islower(c))
			c = toupper(c) ;		/* convert hex chars to ucase */
		if (c < '0')
			goto xit ;				/* bad digit */
		if (c > '9') {
			if (c < 'A')
				goto xit ;			/* bad digit */
			c -= 7 ;				/* adjust hex char */
		}
		digit = ((int) c) - 48 ;	/* value of next digit */
		if (digit >= radix)
			goto xit ;				/* illegal digit */
		
		/* Shift rslt left by radix,
		   and chk for overflow. */
		oflg = 0 ;					/* overflow flag */
		h = (int)(rslt >> 16) ;		/* hi word */
		switch (radix) {
			case  2:
				if (h & 0x8000)
					oflg-- ;			/* overflow */
				rslt <<= 1 ;
				break ;
			case  8:
				if (h & 0xe000)
					oflg-- ;			/* overflow */
				rslt <<= 3 ;
				break ;
			case  16 :
				if (h & 0xf000)
					oflg-- ;			/* overflow */
				rslt <<= 4 ;
				break ;
			default :
				/* Chk for overflow.
				   Not that unsigned long is not supported. */
				if (rslt > 214748364L)
					oflg-- ;			/* overflow */
				else if (rslt == 214748364L)
					/* Chk the next digit */
					if (digit > 7)
						oflg-- ;		/* overflow */
				/* Shift rslt */
				rslt *= 10 ;		/* shift left */
		}
		if (oflg)
			return(SF_ENOVF) ;		/* we overflew */

		/* Add in next digit */
		rslt += (long) digit ;

		/* Get nxt char */
		cp++ ;

	}	/* loop */


xit:
	/** Return rslt **/
	/* Update result */
	if (sgn)
		rslt = -rslt ;
	*rptr = rslt ;

	/* Update str ptr */
	*str = cp ;

	return(0) ;
}



sfaton ( str, radix, unsflg, rptr )
char	*str ;
int		radix ;
int		unsflg ;
long	*rptr ;
/*
  Does an 'sfapton()', and chks that scan ended at end of string.
  If scan is not at end of string, returns user conversion error.
*/
{
	register int	ec ;
	char			*cp ;

	cp = str ;
	ec = sfapton(&cp, radix, unsflg, rptr) ;
	if (ec)
		return(ec) ;			/* conversion error */
	if (*cp != '\0')			/* must be end of str */
		return(SF_ENCNV) ;		/* conversion error */
	return(0) ;
}



sfaptoi ( str, rptr )
char	**str ;
int		*rptr ;
/*
  Converts string to int, and updates string ptr.
*/
{
	register int	ce ;
	long			tl ;

	ce = sfapton(str, 10, 0, &tl) ;
	if (ce == 0)
		*rptr = (int) tl ;
	return(ce) ;
}

long	sfmask ( orgval, newval, mask )
long	orgval, newval ;
unsigned mask ;
/*
  Mask orgval with val, using mask as the 'mask word'.
  Mask word:
	Lo byte = Shift count (e.g. 'bit position', with bit 0 = rightmost).
	Hi byte = Mask width (e.g. number of bits in mask).
  If the mask is zero, the newval is returned (unchanged).
  If the mask val is non-zero, the mask is used to create a mask word out
  of newval, and this value is masked onto orgval. The updated orgval is
  returned.
*/
{
	register unsigned	shft, mwid ;
	long				mskword ;

	/* Get shift & width */
	shft = mask & 255 ;
	mwid = mask >> 8 ;
	if (mwid == 0)
		/* No masking */
		return(newval) ;

	/* Get mask fld width */
	mskword = 0L ;
	while (mwid--) {
		mskword <<= 1 ;
		mskword++ ;
	}

	/* Isolate mask fld in newval */
	newval &= mskword ;

	/* Shift mskword & newval */
#if	SF_ALTOS /* Side-step Altos compiler bug */
	while (shft--) {
		mskword <<= 1 ;
		newval <<= 1 ;
	}
#else
	mskword <<= shft ;
	newval <<= shft ;
#endif

	/* Mask the org val */
	orgval &= ~mskword ;
	orgval |= newval ;

	/* Return the masked original val */
	return(orgval) ;
}

static	intfmt ( fwid, isize, flags, mask )
int		fwid ;
int		isize ;
int		flags ;
unsigned mask ;
/*
  Show integer fld format.
*/
{
	char	msg[SF_MAXCOL+1] ;

	/* Standard info */
	sffldfmt(msg, fwid, "Integer", flags) ;

	/* Int size */
	strcat(msg, "#bytes=") ;
	sfitoa(isize, msg + strlen(msg)) ;

	/* Chk mask */
	if (mask)
		strcat(msg, "  Masked") ;

	/* Show msg */
	sfmsg(msg) ;
}
