:! SCRNIO - DISPLAY/INPUT A FIELD
:#
:     SCRNIO display and/or inputs the specified field depending of the
:     setting of XMODE.  When in edit mode, the current value of the field
:     will be display and the cursor positioned to the beginning of the field
:     for input.  If the user responds with a null response, the routine will
:     return the old value as the new value, otherwise, the response will be
:     returned as the new value.  This routine also returns FUNC if a function
:     key terminated the input and X10 to indicate TAB, BACK TAB, FINISH, or
:     STOP.  Invalid numeric inputs are indicated and the normal error sequence
:     initiated.
:
:> CALLING SEQUENCE
:     F - Field number (See SFORM) - Only negative format allowed
:     XMODE - 0 = Display only
:             1 = Input only
:             2 = Edit (display and then input)
:     X$ - Field contents for string fields
:     X - Field contents for numeric fields
:     GOSUB 9200
:     X$ - New contents for string fields
:     X - New contents for numeric fields
:     XLEN - Length of new input (if any)
:     FUNC - Function key terminator (or -1)
:     X10 - 0 = TAB (Return or any other function key)
:           1 = BACK TAB (F8)
:           2 = FINISH (F6)
:           3 = STOP (F14)
:     F - Next field number (adjusted for function key pressed)
:$ STORAGE USED
:     OLDX$ - Old value of X$ (DIMensioned same as X$)
:     OLDX - Old value of X
:& EXTERNAL ROUTINES
:     SCRNSET (9800)
:     WRITEFORM (9500)
:     READFORM (9300)
:     ERROUT (9850)
:     WAITCLEAR (9775)
:     ERRCLEAR (9890)
:     READFUNC (9560)
:
9200 REM \ SCRNIO
9202 GOSUB 9800 :  \ SCRNSET
9204 LET X10=0
9206 LET OLDX$=X$
9208 LET OLDX=X
9210 IF XMODE=1 THEN GOTO 9228
9212 GOSUB 9504
9214 IF XMODE=0 THEN GOTO 9236
9216 GOSUB 9304
9218 IF E THEN GOTO 9252
9220 IF XLEN THEN GOTO 9236
9222 LET X$=OLDX$
9224 LET X=OLDX
9226 GOTO 9236
9228 LET OLDX$=""
9230 LET OLDX=0
9232 PRINT @(XROW,XCOL);SPACES$[1,XWID];
9234 GOTO 9216
9236 LET F=F-1
9240 IF FUNC=8 THEN LET F=F+2
9242 LET X10=0
9244 IF FUNC=8 THEN LET X10=1
9246 IF FUNC=6 THEN LET X10=2
9248 IF FUNC=14 THEN LET X10=3
9250 RETURN
9252 GOSUB 9850 :  \ ERROUT
9254 GOSUB 9775 :  \ WAITCLEAR
9256 GOSUB 9890 :  \ ERRCLEAR
9258 LET X$=OLDX$
9260 LET X=OLDX
9262 GOTO 9210
