:! INITINDEX - Initialize an index file for KADD etc.
:#
:     INITINDEX creates block 0 and block 1 of an index file.
:> CALLING SEQUENCE
:     T9$ - Scratch string (MUST BE DIM'ED TO AT LEAST 512 BYTES)
:     F%  - Logical file number (of an LOPENed file)
:     X   - Key length in bytes
:     Y   - Duplicate-key-flag (=1 if duplicate keys are allowed)
:     Z   - Blocking factor (percent)
:     GOSUB 7700
:$ STORAGE USED
:     X1 - temporary
:     Y1 - Temporary
:     Z1 - Temporary
::
7700 REM \ INITINDEX
7705 UNPACK "CL+14L",LFTABL$[(F%-1)*26+1],Z1,Y1,X1         :UNPACK channel, offset and last-record-number
7710 IF ASC(LFTABL$[(F%-1)*26+7,(F%-1)*26+8])=0 THEN LOCK 32767,LFTABL$[(F%-1)*26+9,(F%-1)*26+18],0,512    :LOCK if necessary
7715 POSITION FILE[Z1,Y1]                        :Position to block 0
7720 PACK "Z512CCCCCCC",T9$,X+4,508/(X+4),X1,2,1,508/(X+4)*Z/100,Y   :Set up block 0
7725 WRITE FILE[Z1],T9$[1,512]                   :Write block 0
7730 LET T9$=CHR$(1,2),FILL$(-1,510)             :Set up block 1
7735 WRITE FILE[Z1],T9$[1,512]                   :Write block 1
7740 UNLOCK 32767                                :Unlock (even if not locked)
7745 RETURN                                      :Done
7749 REM * END INITINDEX 03/15/79
